/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.jxta.util.WatchedStream;

public class WatchedInputStream
extends FilterInputStream
implements WatchedStream {
    Collection watchList = null;
    volatile boolean stalled = false;
    volatile boolean idle = true;
    boolean closed = false;
    InputStream in = null;

    public WatchedInputStream(InputStream in) {
        super(in);
        this.in = in;
    }

    public String toString() {
        if (null == this.in) {
            return "closed/" + super.toString();
        }
        return this.in.toString() + "/" + super.toString();
    }

    public synchronized void setWatchList(Collection watchList) {
        if (this.watchList != null) {
            this.watchList.remove(this);
        }
        this.watchList = watchList;
        watchList.add(this);
    }

    public void watch() {
        if (this.idle) {
            return;
        }
        if (!this.stalled) {
            this.stalled = true;
            return;
        }
        try {
            this.close();
        }
        catch (IOException ioe) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.idle = true;
        WatchedInputStream watchedInputStream = this;
        synchronized (watchedInputStream) {
            if (this.watchList != null) {
                this.watchList.remove(this);
                this.watchList = null;
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.stalled = false;
        this.idle = false;
        try {
            int n = this.in.read();
            Object var3_2 = null;
            this.idle = true;
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.idle = true;
            throw throwable;
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        block14: {
            int n2;
            block13: {
                int n3;
                block10: {
                    int n4;
                    block12: {
                        int n5;
                        block11: {
                            if (off < 0) throw new IndexOutOfBoundsException();
                            if (len < 0) throw new IndexOutOfBoundsException();
                            if (off + len > b.length) throw new IndexOutOfBoundsException();
                            if (off + len < 0) {
                                throw new IndexOutOfBoundsException();
                            }
                            if (len == 0) {
                                return 0;
                            }
                            this.stalled = false;
                            this.idle = false;
                            int left = len;
                            try {
                                int i;
                                block8: {
                                    block9: {
                                        i = 0;
                                        do {
                                            if (left <= 4096) {
                                                i = this.in.read(b, off, left);
                                                if (i > 0) break block8;
                                                if (left != len) break block9;
                                                n3 = i;
                                                break block10;
                                            }
                                            i = this.in.read(b, off, 4096);
                                            this.stalled = false;
                                            if (i <= 0) {
                                                if (left == len) {
                                                    int n6 = i;
                                                    Object var9_10 = null;
                                                    this.idle = true;
                                                    return n6;
                                                }
                                                n5 = len - left;
                                                break block11;
                                            }
                                            off += i;
                                            left -= i;
                                        } while (this.in.available() != 0);
                                        n4 = len - left;
                                        break block12;
                                    }
                                    n2 = len - left;
                                    break block13;
                                }
                                n = len - left + i;
                                break block14;
                            }
                            catch (Throwable throwable) {
                                Object var9_16 = null;
                                this.idle = true;
                                throw throwable;
                            }
                        }
                        Object var9_11 = null;
                        this.idle = true;
                        return n5;
                    }
                    Object var9_12 = null;
                    this.idle = true;
                    return n4;
                }
                Object var9_13 = null;
                this.idle = true;
                return n3;
            }
            Object var9_14 = null;
            this.idle = true;
            return n2;
        }
        Object var9_15 = null;
        this.idle = true;
        return n;
    }
}

