/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.impl.config.Config;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.util.config.EndpointConfigurator;
import net.jxta.util.config.FetchTimerTask;
import net.jxta.util.config.Fetcher;
import net.jxta.util.config.HttpConfigurator;
import net.jxta.util.config.PSESecurityConfigurator;
import net.jxta.util.config.PlatformConfiguration;
import net.jxta.util.config.RdvConfigurator;
import net.jxta.util.config.RelayConfigurator;
import net.jxta.util.config.TcpConfigurator;
import org.apache.log4j.Category;

public class Configurator {
    public static final int DEFAULT_HTTP_PORT = 9700;
    public static final int DEFAULT_TCP_PORT = 9701;
    public static final String IPADDRESS_ANY_ALL = "anyAll";
    public static final String IPADDRESS_DISCOVER = "discover";
    public static final String DEFAULT_IP_ADDRESS = "0.0.0.0";
    public static final String DEFAULT_MULTICAST_IP_ADDRESS = "224.0.1.85";
    public static final int DEFAULT_MULTICAST_PORT = 1234;
    public static final int DEFAULT_MULTICAST_SIZE = 16384;
    public static final int DEFAULT_ENDPOINT_QUEUE_SIZE = 100;
    public static final String RENDEZVOUS_BOOTSTRAP = "http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2";
    public static final String RELAY_BOOTSTRAP = "http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2";
    static final String HTTP_PROTOCOL = "http";
    static final String HTTPS_PROTOCOL = "https";
    static final String TCP_PROTOCOL = "tcp";
    private static final int FETCH_MAX_TIME = 5000;
    private static final int SLEEP = 100;
    private static final String DESCRIPTION_DOCUMENT_TYPE = "Desc";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$util$config$Configurator == null ? (class$net$jxta$util$config$Configurator = Configurator.class$("net.jxta.util.config.Configurator")) : class$net$jxta$util$config$Configurator).getName());
    private PlatformConfig pAdv = null;
    private HttpConfigurator httpConf = null;
    private TcpConfigurator tcpConf = null;
    private RelayConfigurator relayConf = null;
    private RdvConfigurator rdvConf = null;
    private String principal = null;
    private String password = null;
    private int endpointQueueSize = 100;
    static /* synthetic */ Class class$net$jxta$util$config$Configurator;

    public Configurator() throws IllegalStateException {
        this(null, null, null, null);
    }

    public Configurator(String name, String description) throws IllegalStateException {
        this(name, description, null, null);
    }

    public Configurator(String name, String principal, String credential) throws IllegalStateException {
        this(name, null, principal, credential);
    }

    public Configurator(String name, String description, String principal, String password) throws IllegalStateException {
        String msg = this.constructDelegates();
        if (msg != null) {
            throw new IllegalStateException("can't create: " + msg);
        }
        if (name != null) {
            this.pAdv.setName(name);
        }
        if (description != null) {
            this.setDesc(description);
        }
        this.principal = principal;
        this.password = password;
        this.initHttp();
        this.initTcp();
        this.initRdv();
        this.initRelay();
    }

    public void setPeerName(String peerName) {
        this.pAdv.setName(peerName);
    }

    public void setPeerDescription(String description) {
        this.setDesc(description);
    }

    public void setHttpEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.httpConf.enable();
        } else {
            this.httpConf.disable();
        }
    }

    public void setHttpPort(int port) {
        this.httpConf.setPort(port);
    }

    public void setHttpServer(String ipAddress, int port) {
        String s = ipAddress != null ? ipAddress : this.discoverIPAddress();
        this.httpConf.setServer(s + ":" + String.valueOf(port));
        this.httpConf.setServerEnabled(true);
    }

    public void setHttpInterfaceAddress(String ipAddress) {
        String s = null;
        if (IPADDRESS_DISCOVER.equalsIgnoreCase(ipAddress)) {
            s = this.discoverIPAddress();
        } else if (!IPADDRESS_ANY_ALL.equalsIgnoreCase(ipAddress)) {
            s = ipAddress;
        }
        if (s != null) {
            this.httpConf.setInterfaceAddress(s);
        }
    }

    public void setHttpProxy(String proxy) {
        this.httpConf.setProxy(proxy);
        this.httpConf.setProxyEnabled(true);
    }

    public void setTcpEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.tcpConf.enable();
        } else {
            this.tcpConf.disable();
        }
        this.tcpConf.setServerEnabled(isEnabled);
    }

    public void setTcpPort(int port) {
        this.tcpConf.setPort(port);
    }

    public void setTcpMulticastEnabled(boolean isEnabled) {
        this.tcpConf.setMulticastState(isEnabled);
    }

    public void setTcpMulticastAddress(String multicastAddress) {
        this.tcpConf.setMulticastAddr(multicastAddress);
    }

    public void setTcpMulticastPort(int port) {
        this.tcpConf.setMulticastPort(port);
    }

    public void setTcpMulticastSize(int size) {
        this.tcpConf.setMulticastSize(size);
    }

    public void setTcpInterfaceAddress(String ipAddress) {
        String s = null;
        if (IPADDRESS_ANY_ALL.equalsIgnoreCase(ipAddress)) {
            s = ipAddress;
        }
        if (s != null) {
            this.tcpConf.setInterfaceAddress(s);
        }
    }

    public void setRendezVous(List rendezVous) {
        this.rdvConf.setRendezVous(new Vector(rendezVous));
    }

    public void setRendezVous(boolean isRendezVous) {
        this.rdvConf.setIsRendezVous(isRendezVous);
    }

    public void setHttpRelays(List relays) {
        this.relayConf.setHttpRelays(new Vector(relays));
    }

    public void setTcpRelays(List relays) {
        this.relayConf.setTcpRelays(new Vector(relays));
    }

    public void setRelay(boolean isRelay) {
        this.relayConf.setClientEnabled(!isRelay);
    }

    public void setSecurity(String principal, String password) {
        this.principal = principal;
        this.password = password;
    }

    public void setEndpointQueueSize(int queueSize) {
        this.endpointQueueSize = queueSize;
    }

    public void save() throws IOException {
        this.save(Config.JXTA_HOME + File.separator + "PlatformConfig");
    }

    public void save(String location) throws IOException {
        this.httpConf.save(this.pAdv);
        this.tcpConf.save(this.pAdv);
        this.relayConf.save(this.pAdv);
        this.rdvConf.save(this.pAdv);
        new PSESecurityConfigurator(this.principal, this.password, new File(Config.JXTA_HOME)).save(this.pAdv);
        new EndpointConfigurator(this.endpointQueueSize).save(this.pAdv);
        PlatformConfiguration.save(location, this.pAdv);
    }

    private String constructDelegates() {
        StringBuffer b = new StringBuffer();
        try {
            this.pAdv = PlatformConfiguration.createDefaultPlatformConfig();
        }
        catch (IOException ioe) {
            b.append("PlatformConfig");
        }
        try {
            this.httpConf = new HttpConfigurator();
        }
        catch (Exception e) {
            b.append(b.length() > 0 ? ", " : "HttpConfigurator");
        }
        try {
            this.tcpConf = new TcpConfigurator();
        }
        catch (Exception e) {
            b.append(b.length() > 0 ? ", " : "TcpConfigurator");
        }
        this.rdvConf = new RdvConfigurator();
        this.relayConf = new RelayConfigurator();
        return b.length() > 0 ? b.toString() : null;
    }

    private void initHttp() {
        this.httpConf.enable();
        this.httpConf.setPort(9700);
        this.httpConf.setServerEnabled(false);
        this.httpConf.setServer(null);
    }

    private void initTcp() {
        this.tcpConf.enable();
        this.tcpConf.setPort(9701);
        this.tcpConf.setMulticastAddr(DEFAULT_MULTICAST_IP_ADDRESS);
        this.tcpConf.setMulticastPort(1234);
        this.tcpConf.setMulticastSize(16384);
        this.tcpConf.setServer("");
    }

    private void initRdv() {
        Fetcher fetcher = this.fetch(RENDEZVOUS_BOOTSTRAP);
        if (fetcher != null) {
            ArrayList<String> b = new ArrayList<String>();
            Iterator r = fetcher.getLocations();
            while (r.hasNext()) {
                b.add((String)r.next());
            }
            this.rdvConf.setRendezVous(new Vector(b));
        }
    }

    private void initRelay() {
        this.relayConf.setClientEnabled(true);
        Fetcher fetcher = this.fetch(RELAY_BOOTSTRAP);
        if (fetcher != null) {
            ArrayList<String> h = new ArrayList<String>();
            ArrayList<String> t = new ArrayList<String>();
            String s = null;
            Iterator r = fetcher.getLocations();
            while (r.hasNext()) {
                s = (String)r.next();
                if (s.toLowerCase().startsWith(HTTP_PROTOCOL)) {
                    h.add(s);
                    continue;
                }
                if (!s.toLowerCase().startsWith(TCP_PROTOCOL)) continue;
                t.add(s);
            }
            this.relayConf.setHttpRelays(new Vector(h));
            this.relayConf.setTcpRelays(new Vector(t));
        }
    }

    private Fetcher fetch(String location) {
        Fetcher fetcher = null;
        URL u = null;
        try {
            u = new URL(location);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (u != null) {
            fetcher = new Fetcher(u);
            new Thread((Runnable)fetcher, fetcher.getClass().getPackage() + "." + fetcher.getClass().getName()).start();
            Timer timer = new Timer();
            timer.schedule((TimerTask)new FetchTimerTask(fetcher), 5000L);
            while (!fetcher.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        return fetcher;
    }

    private void setDesc(String description) {
        this.pAdv.setDesc(StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, DESCRIPTION_DOCUMENT_TYPE, description));
    }

    private String discoverIPAddress() {
        InetAddress[] a = null;
        try {
            a = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        return a != null && a.length == 1 ? a[0].getHostAddress() : DEFAULT_IP_ADDRESS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

