/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Fetcher
implements Runnable {
    private static final String MIME_CONTENT_LENGTH = "Content-Length";
    private static final int BLOCK = 1024;
    private URL location = null;
    private List locations = new ArrayList();
    private boolean isDone = false;
    private boolean isInterrupted = false;
    private URLConnection connection = null;

    public Fetcher(URL location) {
        this.location = location;
    }

    public Iterator getLocations() {
        return this.locations.iterator();
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void interrupt() {
        this.isInterrupted = true;
        this.connection = null;
    }

    public void run() {
        this.locations = this.fetch(this.location);
        this.isDone = true;
    }

    private List fetch(URL location) {
        ArrayList<String> l;
        block10: {
            l = new ArrayList<String>();
            String s = null;
            if (!this.isInterrupted) {
                try {
                    this.connection = this.openConnection(location);
                    s = this.read(this.connection);
                }
                catch (MalformedURLException mue) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (s == null) break block10;
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            st.wordChars(32, 126);
            st.eolIsSignificant(true);
            try {
                while (st.nextToken() != -1) {
                    switch (st.ttype) {
                        case -3: {
                            l.add(st.sval.trim());
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {}
        }
        return l;
    }

    private URLConnection openConnection(URL u) throws IOException {
        URLConnection c = null;
        String p = u.getProtocol();
        c = p.equalsIgnoreCase("http") || p.equalsIgnoreCase("https") ? (HttpURLConnection)u.openConnection() : u.openConnection();
        return c;
    }

    private String read(URLConnection c) throws IOException {
        String content = null;
        BufferedReader r = new BufferedReader(new InputStreamReader(c.getInputStream()));
        char[] buf = new char[4096];
        int l = 0;
        CharArrayWriter w = new CharArrayWriter();
        while ((l = r.read(buf, 0, 1024)) > -1) {
            w.write(buf, 0, l);
        }
        r.close();
        content = w.toString();
        return content;
    }
}

