/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.TransportAdvertisement;

public class HttpConfigurator {
    public static final int DEFAULT_PORT = 9700;
    private boolean enabled = false;
    private HTTPAdv httpAdv = null;

    public HttpConfigurator(ConfigParams configAdv) throws RuntimeException {
        try {
            Element param = configAdv.getServiceParam(PeerGroup.httpProtoClassID);
            if (param == null) {
                throw new RuntimeException("no advertisement");
            }
            this.enabled = !param.getChildren("isOff").hasMoreElements();
            Enumeration httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (!httpChilds.hasMoreElements()) {
                throw new IllegalStateException("Missing HTTP Transport Advertisement");
            }
            param = (Element)httpChilds.nextElement();
            this.httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
        }
        catch (Exception thatsbad2) {
            throw new RuntimeException("Broken ConfigParams. Cannot proceed.");
        }
    }

    public HttpConfigurator() throws RuntimeException {
        try {
            this.httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(HTTPAdv.getAdvertisementType());
        }
        catch (Exception serious) {
            throw new RuntimeException(serious.getMessage());
        }
        this.httpAdv.setProtocol("http");
        this.httpAdv.setPort(9700);
        this.httpAdv.setConfigMode("auto");
    }

    public void save(ConfigParams padv) {
        StructuredDocument param = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
        StructuredDocumentUtils.copyElements(param, param, (StructuredDocument)this.httpAdv.getDocument(MimeMediaType.XMLUTF8));
        if (!this.enabled) {
            param.appendChild(param.createElement("isOff"));
        }
        padv.putServiceParam(PeerGroup.httpProtoClassID, param);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPort() {
        return this.httpAdv.getPort();
    }

    public void setPort(int port) {
        this.httpAdv.setPort(port);
    }

    public String getServer() {
        return this.httpAdv.getServer();
    }

    public void setServer(String a) {
        this.httpAdv.setServer(a);
    }

    public boolean isServerEnabled() {
        return this.httpAdv.isServerEnabled();
    }

    public void setClientEnabled(boolean enabled) {
        this.httpAdv.setClientEnabled(enabled);
    }

    public boolean isClientEnabled() {
        return this.httpAdv.isClientEnabled();
    }

    public String getInterfaceAddress() {
        return this.httpAdv.getInterfaceAddress();
    }

    public void setInterfaceAddress(String ia) {
        this.httpAdv.setInterfaceAddress(ia);
    }

    public String getConfigMode() {
        return this.httpAdv.getConfigMode();
    }

    public void setConfigMode(String mode) {
        this.httpAdv.setConfigMode(mode);
    }

    public void setServerEnabled(boolean enabled) {
        this.httpAdv.setServerEnabled(enabled);
    }

    public String getProxy() {
        return this.httpAdv.getProxy();
    }

    public boolean isProxyEnabled() {
        return this.httpAdv.isProxyEnabled();
    }

    public void setProxy(String name) {
        this.httpAdv.setProxy(name);
    }

    public void setProxyEnabled(boolean enabled) {
        this.httpAdv.setProxyEnabled(enabled);
    }

    public String toString() {
        String res = "inet addr:" + this.httpAdv.getInterfaceAddress() + ":" + this.httpAdv.getPort() + "\n";
        res = this.httpAdv.isServerEnabled() ? res + "Server addr:" + this.httpAdv.getServer() + "\n" : res + "server disabled\n";
        return res;
    }
}

