/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.impl.membership.pse.PSEConfig;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import org.apache.log4j.Logger;

public class PSESecurityConfigurator {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$util$config$PSESecurityConfigurator == null ? (class$net$jxta$util$config$PSESecurityConfigurator = PSESecurityConfigurator.class$("net.jxta.util.config.PSESecurityConfigurator")) : class$net$jxta$util$config$PSESecurityConfigurator).getName());
    PSEConfigAdv pseAdv = null;
    static /* synthetic */ Class class$net$jxta$util$config$PSESecurityConfigurator;

    public PSESecurityConfigurator(String principal, String password, File pseDir) throws IOException {
        if (!PSEConfig.isInitialized(pseDir)) {
            System.setProperty("net.jxta.tls.principal", principal);
            System.setProperty("net.jxta.tls.password", password);
        }
        PSEUtils.IssuerInfo info = PSEUtils.genCert(principal, null);
        this.pseAdv = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
        this.pseAdv.setRootCert(info.cert);
        char[] passchars = password.toCharArray();
        this.pseAdv.setPrivateKey(passchars, info.subjectPkey);
        int zeroChar = passchars.length - 1;
        while (zeroChar >= 0) {
            passchars[zeroChar] = '\u0000';
            --zeroChar;
        }
    }

    public PSESecurityConfigurator(ConfigParams padv, File pseDir) {
        StructuredDocument pseparam = padv.getServiceParam(PeerGroup.membershipClassID);
        if (null == pseparam) {
            throw new IllegalArgumentException("Provided Advertisement does not contain a " + PSEConfigAdv.getAdvertisementType());
        }
        Advertisement paramsAdv = AdvertisementFactory.newAdvertisement((TextElement)((Object)pseparam));
        if (!(paramsAdv instanceof PSEConfigAdv)) {
            throw new IllegalArgumentException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
        }
        this.pseAdv = (PSEConfigAdv)paramsAdv;
    }

    public void save(ConfigParams padv) {
        XMLDocument param = (XMLDocument)this.pseAdv.getDocument(MimeMediaType.XMLUTF8);
        param.addAttribute("type", param.getName());
        padv.putServiceParam(PeerGroup.membershipClassID, param);
    }

    public Certificate getRootCertificate() {
        return this.pseAdv.getRootCertificate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

