/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.peergroup.PeerGroupID;

public final class PlatformConfiguration {
    private PlatformConfiguration() {
    }

    public static void save(String fileName, PlatformConfig advertisement) throws IOException {
        File saveFile = new File(fileName);
        File parent = saveFile.getParentFile();
        parent.mkdirs();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(saveFile);
            Document aDoc = advertisement.getDocument(MimeMediaType.XMLUTF8);
            aDoc.sendToStream(out);
        }
        catch (Exception e) {
            throw new IOException("Cannot write advertisement the file: " + fileName);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception ignored) {}
            out = null;
        }
    }

    public static PlatformConfig load(String fileName) throws IOException {
        FileInputStream advStream = null;
        File file = null;
        PlatformConfig advertisement = null;
        try {
            file = new File(fileName);
            advStream = new FileInputStream(file);
            advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, advStream);
        }
        catch (FileNotFoundException e) {
            throw new IOException("No Existing " + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IOException("Exception: " + e);
        }
        finally {
            try {
                if (advStream != null) {
                    advStream.close();
                }
                advStream = null;
            }
            catch (Exception ignored) {}
        }
        return advertisement;
    }

    public static PlatformConfig createDefaultPlatformConfig() throws IOException {
        PlatformConfig advertisement = null;
        try {
            advertisement = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
            advertisement.setName("Anonymous Peer");
            advertisement.setDescription("Created by PlatformConfiguration");
            advertisement.setPeerID(IDFactory.newPeerID(PeerGroupID.worldPeerGroupID));
        }
        catch (Exception serious) {
            throw new IOException("Error " + serious);
        }
        return advertisement;
    }
}

