/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import net.jxta.impl.config.Config;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.protocol.ConfigParams;
import net.jxta.util.config.EndpointConfigurator;
import net.jxta.util.config.HttpConfigurator;
import net.jxta.util.config.PSESecurityConfigurator;
import net.jxta.util.config.PlatformConfiguration;
import net.jxta.util.config.RdvConfigurator;
import net.jxta.util.config.RelayConfigurator;
import net.jxta.util.config.TcpConfigurator;

public class PlatformConfigurator {
    public static final String PLATFORM_CONFIG_FILENAME = "PlatformConfig";
    public static final String BOOT_STRAP_RENDEZVOUS = "http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2";
    public static final String BOOT_STRAP_RELAYS = "http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2";

    public static String getPlatformConfigFileName() {
        return Config.JXTA_HOME + File.separator + PLATFORM_CONFIG_FILENAME;
    }

    public static ConfigParams createTcpEdge(String peerName, String peerDesc, String ip, int port, Vector rdvs, String user, String password) {
        PlatformConfig padv = null;
        try {
            padv = PlatformConfiguration.createDefaultPlatformConfig();
            if (padv == null) {
                return null;
            }
            if (peerName != null) {
                padv.setName(peerName);
            }
            if (peerDesc != null) {
                padv.setDescription(peerDesc);
            } else {
                padv.setDescription("Created by JxtaConfigWizard - createTcpEdge profile");
            }
            TcpConfigurator tcpConf = new TcpConfigurator();
            if (ip != null) {
                tcpConf.setInterfaceAddress(ip);
            }
            tcpConf.setPort(port);
            tcpConf.setServerEnabled(true);
            tcpConf.setMulticastState(false);
            tcpConf.enable();
            tcpConf.save(padv);
            HttpConfigurator httpConf = new HttpConfigurator();
            httpConf.disable();
            httpConf.save(padv);
            RelayConfigurator relayConf = new RelayConfigurator(false, false, null, null);
            relayConf.save(padv);
            PSESecurityConfigurator securityConf = new PSESecurityConfigurator(user, password, null);
            securityConf.save(padv);
            EndpointConfigurator endpointConf = new EndpointConfigurator(100);
            endpointConf.save(padv);
            RdvConfigurator rdvConf = null;
            rdvConf = new RdvConfigurator();
            rdvConf.setRendezVous(rdvs);
            rdvConf.setIsRendezVous(false);
            rdvConf.save(padv);
            PlatformConfigurator.save(padv);
        }
        catch (Exception ez1) {
            return null;
        }
        return padv;
    }

    public static PlatformConfig createTcpAdHocEdge(String peerName, String peerDesc, String ip, int port, Vector rdvs, String user, String password) {
        PlatformConfig padv = null;
        try {
            padv = PlatformConfiguration.createDefaultPlatformConfig();
            if (padv == null) {
                return null;
            }
            if (peerName != null) {
                padv.setName(peerName);
            }
            if (peerDesc != null) {
                padv.setDescription(peerDesc);
            } else {
                padv.setDescription("Created by JxtaConfigWizard - createTcpEdge profile");
            }
            TcpConfigurator tcpConf = new TcpConfigurator();
            if (ip != null) {
                tcpConf.setInterfaceAddress(ip);
            }
            tcpConf.setPort(port);
            tcpConf.setServerEnabled(true);
            tcpConf.setMulticastState(true);
            tcpConf.enable();
            tcpConf.save(padv);
            HttpConfigurator httpConf = new HttpConfigurator();
            httpConf.disable();
            httpConf.save(padv);
            RelayConfigurator relayConf = new RelayConfigurator(false, false, null, null);
            relayConf.save(padv);
            PSESecurityConfigurator securityConf = new PSESecurityConfigurator(user, password, null);
            securityConf.save(padv);
            EndpointConfigurator endpointConf = new EndpointConfigurator(100);
            endpointConf.save(padv);
            RdvConfigurator rdvConf = null;
            rdvConf = new RdvConfigurator();
            rdvConf.setRendezVous(rdvs);
            rdvConf.setIsRendezVous(false);
            rdvConf.save(padv);
            PlatformConfigurator.save(padv);
        }
        catch (Exception ez1) {
            return null;
        }
        return padv;
    }

    public static PlatformConfig createTcpRelayEdge(String peerName, String peerDesc, String ip, int port, Vector relays, Vector rdvs, String user, String password) {
        PlatformConfig padv = null;
        try {
            padv = PlatformConfiguration.createDefaultPlatformConfig();
            if (padv == null) {
                return null;
            }
            if (peerName != null) {
                padv.setName(peerName);
            }
            if (peerDesc != null) {
                padv.setDescription(peerDesc);
            } else {
                padv.setDescription("Created by JxtaConfigWizard - createTcpEdge profile");
            }
            TcpConfigurator tcpConf = new TcpConfigurator();
            if (ip != null) {
                tcpConf.setInterfaceAddress(ip);
            }
            tcpConf.setPort(port);
            tcpConf.setServerEnabled(false);
            tcpConf.setMulticastState(false);
            tcpConf.enable();
            tcpConf.save(padv);
            HttpConfigurator httpConf = new HttpConfigurator();
            httpConf.disable();
            httpConf.save(padv);
            RelayConfigurator relayConf = new RelayConfigurator(false, true, relays, null);
            relayConf.save(padv);
            PSESecurityConfigurator securityConf = new PSESecurityConfigurator(user, password, null);
            securityConf.save(padv);
            EndpointConfigurator endpointConf = new EndpointConfigurator(100);
            endpointConf.save(padv);
            RdvConfigurator rdvConf = null;
            rdvConf = new RdvConfigurator();
            rdvConf.setRendezVous(rdvs);
            rdvConf.setIsRendezVous(false);
            rdvConf.save(padv);
            PlatformConfigurator.save(padv);
        }
        catch (Exception ez1) {
            return null;
        }
        return padv;
    }

    public static PlatformConfig createHttpProxyEdge(String peerName, String peerDesc, String proxy, Vector relays, Vector rdvs, String user, String password) {
        PlatformConfig padv = null;
        try {
            padv = PlatformConfiguration.createDefaultPlatformConfig();
            if (padv == null) {
                return null;
            }
            if (peerName != null) {
                padv.setName(peerName);
            }
            if (peerDesc != null) {
                padv.setDescription(peerDesc);
            } else {
                padv.setDescription("Created by JxtaConfigWizard - createTcpEdge profile");
            }
            TcpConfigurator tcpConf = new TcpConfigurator();
            tcpConf.setServerEnabled(false);
            tcpConf.setMulticastState(false);
            tcpConf.disable();
            tcpConf.save(padv);
            HttpConfigurator httpConf = new HttpConfigurator();
            httpConf.enable();
            httpConf.setServerEnabled(false);
            if (proxy != null) {
                httpConf.setProxyEnabled(true);
                httpConf.setProxy(proxy);
            } else {
                httpConf.setProxyEnabled(false);
            }
            httpConf.save(padv);
            RelayConfigurator relayConf = new RelayConfigurator(false, true, null, relays);
            relayConf.save(padv);
            PSESecurityConfigurator securityConf = new PSESecurityConfigurator(user, password, null);
            securityConf.save(padv);
            EndpointConfigurator endpointConf = new EndpointConfigurator(100);
            endpointConf.save(padv);
            RdvConfigurator rdvConf = null;
            rdvConf = new RdvConfigurator();
            rdvConf.setIsRendezVous(false);
            rdvConf.setRendezVous(rdvs);
            rdvConf.save(padv);
            PlatformConfigurator.save(padv);
        }
        catch (Exception ez1) {
            return null;
        }
        return padv;
    }

    public static PlatformConfig createRdvAndRelay(String peerName, String peerDesc, String tcpIp, int tcpPort, String httpIp, int httpPort, Vector rdvs, String user, String password) {
        PlatformConfig padv = null;
        try {
            padv = PlatformConfiguration.createDefaultPlatformConfig();
            if (padv == null) {
                return null;
            }
            if (peerName != null) {
                padv.setName(peerName);
            }
            if (peerDesc != null) {
                padv.setDescription(peerDesc);
            } else {
                padv.setDescription("Created by JxtaConfigWizard - createTcpEdge profile");
            }
            TcpConfigurator tcpConf = new TcpConfigurator();
            tcpConf.setPort(tcpPort);
            tcpConf.setServerEnabled(true);
            tcpConf.setMulticastState(false);
            if (tcpIp != null) {
                tcpConf.setServer(tcpIp);
            }
            tcpConf.enable();
            tcpConf.save(padv);
            HttpConfigurator httpConf = new HttpConfigurator();
            httpConf.enable();
            httpConf.setPort(httpPort);
            if (httpIp != null) {
                httpConf.setServer(httpIp);
            }
            httpConf.setServerEnabled(true);
            httpConf.save(padv);
            RelayConfigurator relayConf = new RelayConfigurator(true, false, null, null);
            relayConf.save(padv);
            PSESecurityConfigurator securityConf = new PSESecurityConfigurator(user, password, null);
            securityConf.save(padv);
            EndpointConfigurator endpointConf = new EndpointConfigurator(100);
            endpointConf.save(padv);
            RdvConfigurator rdvConf = null;
            rdvConf = new RdvConfigurator();
            rdvConf.setRendezVous(rdvs);
            rdvConf.setIsRendezVous(true);
            rdvConf.save(padv);
            PlatformConfigurator.save(padv);
        }
        catch (Exception ez1) {
            return null;
        }
        return padv;
    }

    public static void save(PlatformConfig adv) throws IOException {
        PlatformConfiguration.save(PlatformConfigurator.getPlatformConfigFileName(), adv);
    }

    public static Vector loadBootStrap(String urlString) throws IOException {
        try {
            return PlatformConfigurator.loadBootStrap(new URL(urlString));
        }
        catch (MalformedURLException e) {
            throw new IOException(urlString + ": malformed URL.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Vector loadBootStrap(URL url) throws IOException {
        Vector<void> result = new Vector<void>();
        if (url == null) {
            return result;
        }
        InputStream is = null;
        try {
            String s;
            is = url.openStream();
            BufferedReader l = new BufferedReader(new InputStreamReader(is));
            while ((s = l.readLine()) != null) {
                void var4_4;
                result.add(var4_4);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable ignored) {}
        return result;
    }
}

