/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;

public class RdvConfigurator {
    private Vector rdvs = null;
    private boolean isRendezvous = false;
    private boolean isAutoStart = true;

    public RdvConfigurator(ConfigParams padv) throws RuntimeException {
        this.rdvs = new Vector();
        try {
            TextElement param = (TextElement)((Object)padv.getServiceParam(PeerGroup.rendezvousClassID));
            if (param != null) {
                Enumeration rdvEnum = param.getChildren("Addr");
                while (rdvEnum.hasMoreElements()) {
                    this.rdvs.addElement(((TextElement)rdvEnum.nextElement()).getTextValue());
                }
                Enumeration rdv = param.getChildren("Rdv");
                this.isRendezvous = rdv.hasMoreElements() && "true".equals(((TextElement)rdv.nextElement()).getTextValue());
                Enumeration enumeration = param.getChildren("AutoRdv");
                this.isAutoStart = enumeration.hasMoreElements() && "true".equals(((TextElement)enumeration.nextElement()).getTextValue());
            }
        }
        catch (Exception nobigdeal) {
            throw new RuntimeException("Cannot process advertisement");
        }
    }

    public RdvConfigurator() {
    }

    public void setIsRendezVous(boolean v) {
        this.isRendezvous = v;
    }

    public boolean isRendezVous() {
        return this.isRendezvous;
    }

    public Vector getRendezVous() {
        return this.rdvs;
    }

    public Vector setRendezVous(Vector newRdvs) {
        Vector old = this.rdvs;
        this.rdvs = newRdvs;
        return old;
    }

    public void save(ConfigParams padv) {
        StructuredTextDocument pdoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
        if (this.rdvs != null) {
            int i = 0;
            while (i < this.rdvs.size()) {
                try {
                    String addr = (String)this.rdvs.elementAt(i);
                    TextElement e = pdoc.createElement("Addr", addr);
                    pdoc.appendChild((Element)e);
                }
                catch (Exception ez1) {
                    Thread.dumpStack();
                }
                ++i;
            }
        }
        if (this.isRendezvous) {
            TextElement e = pdoc.createElement("Rdv", "true");
            pdoc.appendChild((Element)e);
        }
        if (this.isAutoStart) {
            TextElement e = pdoc.createElement("AutoRdv", "true");
            pdoc.appendChild((Element)e);
        }
        padv.putServiceParam(PeerGroup.rendezvousClassID, pdoc);
    }

    public boolean isAutoStart() {
        return this.isAutoStart;
    }

    public void setAutoStart(boolean auto) {
        this.isAutoStart = auto;
    }
}

