/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.jxta.impl.config.Config;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvProperties {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$util$config$RdvProperties == null ? (class$net$jxta$util$config$RdvProperties = RdvProperties.class$("net.jxta.util.config.RdvProperties")) : class$net$jxta$util$config$RdvProperties).getName());
    public static final String PROPERTIES_FILENAME = Config.JXTA_HOME + "jxta.properties";
    public static final String PROP_MAX_CLIENTS = "RdvManager.MaxClients";
    public static final String PROP_LEASE_MARGIN = "RdvMonitor.LeaseMargin";
    public static final String PROP_DEFAULT_LEASE = "RdvMonitor.DefaultLease";
    public static final String PROP_RDV_WATCHDOG = "Rdv.Rdv-Watchdog";
    public static final String SEEDINGRDV_CONN_DELAY_PROPERTY = "peerview.SeedingRdvConnDelay";
    public static final String PROBE_RELAYS = "peerview.ProbeRelays";
    private long leaseMargin = 300000L;
    private long defaultLease = 1200000L;
    private long rdvWatchdog = 300000L;
    private long seedingConnDelay = 0L;
    private int maxClients = 200;
    private boolean probeRelays = false;
    private String propFile = PROPERTIES_FILENAME;
    private Properties properties = new Properties();
    static /* synthetic */ Class class$net$jxta$util$config$RdvProperties;

    public RdvProperties() throws RuntimeException {
        this.initFromFile();
    }

    public RdvProperties(String propFile) throws RuntimeException {
        if (propFile != null) {
            this.propFile = propFile;
        }
        this.initFromFile();
    }

    public long setRdvMonitorLeaseMargin(long newVal) {
        long old = this.leaseMargin;
        this.leaseMargin = newVal;
        this.properties.setProperty(PROP_LEASE_MARGIN, Long.toString(newVal));
        return old;
    }

    public long getRdvMonitorLeaseMargin() {
        return this.leaseMargin;
    }

    public long setRdvMonitorDefaultLease(long newVal) {
        long old = this.defaultLease;
        this.defaultLease = newVal;
        this.properties.setProperty(PROP_DEFAULT_LEASE, Long.toString(newVal));
        return old;
    }

    public long getRdvMonitorDefaultLease() {
        return this.defaultLease;
    }

    public int setRdvManagerMaxClients(int newVal) {
        int old = this.maxClients;
        this.maxClients = newVal;
        this.properties.setProperty(PROP_MAX_CLIENTS, Integer.toString(newVal));
        return old;
    }

    public int getRdvManagerMaxClients() {
        return this.maxClients;
    }

    public void setPeerViewProbeRelays(boolean newVal) {
        this.probeRelays = newVal;
        this.properties.setProperty(PROBE_RELAYS, newVal ? "yes" : "no");
    }

    public boolean getPeerViewProbeRelays() {
        return this.probeRelays;
    }

    public long setRdvWatchdog(long newVal) {
        long old = this.rdvWatchdog;
        this.rdvWatchdog = newVal;
        this.properties.setProperty(PROP_RDV_WATCHDOG, Long.toString(newVal));
        return old;
    }

    public long getRdvWatchdog() {
        return this.rdvWatchdog;
    }

    public long setPeerViewSeedingConnDelay(long newVal) {
        long old = this.seedingConnDelay;
        this.seedingConnDelay = newVal;
        this.properties.setProperty(SEEDINGRDV_CONN_DELAY_PROPERTY, Long.toString(newVal));
        return old;
    }

    public long getPeerViewSeedingConnDelay() {
        return this.seedingConnDelay;
    }

    public void save() throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.propFile);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.toString());
        }
        if (out != null) {
            try {
                this.properties.store(out, "Created by net.jxta.util.config.RdvProperties");
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
        } else {
            throw new RuntimeException(this.propFile + " cannot be updated");
        }
    }

    private void initFromFile() throws RuntimeException {
        InputStream in;
        block31: {
            in = null;
            try {
                in = new FileInputStream(this.propFile);
            }
            catch (FileNotFoundException e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"no jxta.properties file");
                }
                if ((in = this.getClass().getResourceAsStream("/" + this.propFile)) == null || !LOG.isEnabledFor((Priority)Level.INFO)) break block31;
                LOG.info((Object)("Read " + this.propFile + " from classpath"));
            }
        }
        if (in != null) {
            try {
                this.properties.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties cannot be read");
                }
                return;
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"no jxta.properties file");
            }
            return;
        }
        String val = null;
        val = this.properties.getProperty(PROP_MAX_CLIENTS);
        if (val != null) {
            try {
                this.maxClients = Integer.parseInt(val);
            }
            catch (NumberFormatException ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties is corrupted");
                }
                return;
            }
        }
        if ((val = this.properties.getProperty(PROP_LEASE_MARGIN)) != null) {
            try {
                this.leaseMargin = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties is corrupted");
                }
                return;
            }
        }
        if ((val = this.properties.getProperty(PROP_DEFAULT_LEASE)) != null) {
            try {
                this.defaultLease = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties is corrupted");
                }
                return;
            }
        }
        if ((val = this.properties.getProperty(PROP_RDV_WATCHDOG)) != null) {
            try {
                this.rdvWatchdog = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties is corrupted");
                }
                return;
            }
        }
        if ((val = this.properties.getProperty(SEEDINGRDV_CONN_DELAY_PROPERTY)) != null) {
            try {
                this.seedingConnDelay = Long.parseLong(val);
            }
            catch (NumberFormatException ez) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"jxta.properties is corrupted");
                }
                return;
            }
        }
        if ((val = this.properties.getProperty(PROBE_RELAYS)) != null && val.equalsIgnoreCase("yes")) {
            this.probeRelays = true;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"RendezVous Service is using local jxta.properties");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

