/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;

public class RelayConfigurator {
    public static final long DEFAULT_LEASE = 7200L;
    public static final int DEFAULT_SERVER_MAX_CLIENTS = 100;
    public static final int DEFAULT_CLIENT_MAX_SERVERS = 1;
    public static final int DEFAULT_CLIENT_QUEUE_SIZE = 100;
    private static final String PROTOCOL_DELIMITER = "://";
    private Vector tcpRelays;
    private Vector httpRelays;
    private boolean isServer;
    private boolean isClient;
    private int clientMaximumServers;
    private long clientLease;
    private int clientQueueSize;
    private int serverMaximumClients;
    private long serverLease;

    public RelayConfigurator(ConfigParams padv) throws RuntimeException {
        block19: {
            this.tcpRelays = null;
            this.httpRelays = null;
            this.isServer = false;
            this.isClient = false;
            this.clientMaximumServers = 0;
            this.clientLease = 0L;
            this.clientQueueSize = 100;
            this.serverMaximumClients = 0;
            this.serverLease = 0L;
            this.tcpRelays = new Vector();
            this.httpRelays = new Vector();
            try {
                TextElement param = (TextElement)((Object)padv.getServiceParam(PeerGroup.relayProtoClassID));
                if (param == null) break block19;
                Enumeration relayTCPEnum = param.getChildren("tcpaddr");
                while (relayTCPEnum.hasMoreElements()) {
                    this.tcpRelays.addElement(((TextElement)relayTCPEnum.nextElement()).getTextValue());
                }
                Enumeration relayHTTPEnum = param.getChildren("httpaddr");
                while (relayHTTPEnum.hasMoreElements()) {
                    this.httpRelays.addElement(((TextElement)relayHTTPEnum.nextElement()).getTextValue());
                }
                Enumeration relayServer = param.getChildren("isServer");
                this.isServer = relayServer.hasMoreElements() && "true".equals(((TextElement)relayServer.nextElement()).getTextValue());
                Enumeration relayClient = param.getChildren("isClient");
                this.isClient = relayClient.hasMoreElements() && "true".equals(((TextElement)relayClient.nextElement()).getTextValue());
                Enumeration enumeration = param.getChildren("ServerMaximumClients");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        this.serverMaximumClients = Integer.parseInt(((TextElement)enumeration.nextElement()).getTextValue());
                    }
                    catch (Exception ez) {
                        this.serverMaximumClients = 100;
                    }
                }
                if ((enumeration = param.getChildren("ServerLeaseInSeconds")) != null && enumeration.hasMoreElements()) {
                    try {
                        this.serverLease = Integer.parseInt(((TextElement)enumeration.nextElement()).getTextValue());
                    }
                    catch (Exception ez) {
                        this.serverLease = 7200L;
                    }
                }
                if ((enumeration = param.getChildren("ClientMaximumServers")) != null && enumeration.hasMoreElements()) {
                    try {
                        this.clientMaximumServers = Integer.parseInt(((TextElement)enumeration.nextElement()).getTextValue());
                    }
                    catch (Exception ez) {
                        this.clientMaximumServers = 0;
                    }
                }
                if ((enumeration = param.getChildren("ClientQueueSize")) != null && enumeration.hasMoreElements()) {
                    try {
                        this.clientQueueSize = Integer.parseInt(((TextElement)enumeration.nextElement()).getTextValue());
                    }
                    catch (Exception ez) {
                        this.clientQueueSize = 100;
                    }
                }
                if ((enumeration = param.getChildren("ClientLeaseInSeconds")) != null && enumeration.hasMoreElements()) {
                    try {
                        this.clientLease = Integer.parseInt(((TextElement)enumeration.nextElement()).getTextValue());
                    }
                    catch (Exception ez) {
                        this.clientLease = 7200L;
                    }
                }
            }
            catch (Exception nobigdeal) {
                throw new RuntimeException("Cannot process advertisement");
            }
        }
    }

    public RelayConfigurator() {
        this(false, false, null, null);
    }

    public RelayConfigurator(boolean isServer, boolean isClient, Vector tcpRelays, Vector httpRelays) {
        this.tcpRelays = null;
        this.httpRelays = null;
        this.isServer = false;
        this.isClient = false;
        this.clientMaximumServers = 0;
        this.clientLease = 0L;
        this.clientQueueSize = 100;
        this.serverMaximumClients = 0;
        this.serverLease = 0L;
        this.isServer = isServer;
        this.isClient = isClient;
        this.tcpRelays = tcpRelays;
        this.httpRelays = httpRelays;
    }

    public void setServerEnabled(boolean v) {
        this.isServer = v;
    }

    public boolean isServerEnabled() {
        return this.isServer;
    }

    public void setClientEnabled(boolean v) {
        this.isClient = v;
    }

    public boolean isClientEnabled() {
        return this.isClient;
    }

    public Vector getTcpRelays() {
        return this.tcpRelays;
    }

    public Vector setTcpRelays(Vector newTcpRelays) {
        Vector old = this.tcpRelays;
        this.tcpRelays = newTcpRelays;
        return old;
    }

    public Vector getHttpRelays() {
        return this.httpRelays;
    }

    public Vector setHttpRelays(Vector newHttpRelays) {
        Vector old = this.httpRelays;
        this.httpRelays = newHttpRelays;
        return old;
    }

    public int getClientMaximumServers() {
        return this.clientMaximumServers;
    }

    public void setClientMaximumServers(int v) {
        this.clientMaximumServers = v;
    }

    public long getClientLeaseInSeconds() {
        return this.clientLease;
    }

    public void setClientLeaseInSeconds(long v) {
        this.clientLease = v;
    }

    public int getClientQueueSize() {
        return this.clientQueueSize;
    }

    public void setClientQueueSize(int v) {
        this.clientQueueSize = v;
    }

    public int getServerMaximumClients() {
        return this.serverMaximumClients;
    }

    public void setServerMaximumClients(int v) {
        this.serverMaximumClients = v;
    }

    public long getServerLeaseInSeconds() {
        return this.serverLease;
    }

    public void setServerLeaseInSeconds(long v) {
        this.serverLease = v;
    }

    public void save(ConfigParams padv) {
        try {
            String r;
            int i;
            StructuredTextDocument relay = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            TextElement e = relay.createElement("isServer", new Boolean(this.isServer).toString());
            relay.appendChild((Element)e);
            if (this.serverMaximumClients > 0) {
                relay.appendChild(relay.createElement("ServerMaximumClients", Integer.toString(this.serverMaximumClients)));
            } else {
                relay.appendChild(relay.createElement("ServerMaximumClients"));
            }
            if (this.serverLease > 0L) {
                relay.appendChild(relay.createElement("ServerLeaseInSeconds", Long.toString(this.serverLease)));
            } else {
                relay.appendChild(relay.createElement("ServerLeaseInSeconds"));
            }
            e = relay.createElement("isClient", new Boolean(this.isClient).toString());
            relay.appendChild((Element)e);
            if (this.clientMaximumServers > 0) {
                relay.appendChild(relay.createElement("ClientMaximumServers", Integer.toString(this.clientMaximumServers)));
            } else {
                relay.appendChild(relay.createElement("ClientMaximumServers"));
            }
            if (this.clientLease > 0L) {
                relay.appendChild(relay.createElement("ClientLeaseInSeconds", Long.toString(this.clientLease)));
            } else {
                relay.appendChild(relay.createElement("ClientLeaseInSeconds"));
            }
            relay.appendChild(relay.createElement("ClientQueueSize", Integer.toString(this.clientQueueSize)));
            if (this.httpRelays != null) {
                i = 0;
                while (i < this.httpRelays.size()) {
                    try {
                        r = (String)this.httpRelays.elementAt(i);
                        e = relay.createElement("httpaddr", this.trimProtocol(r));
                        relay.appendChild((Element)e);
                    }
                    catch (Exception ez) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (this.tcpRelays != null) {
                i = 0;
                while (i < this.tcpRelays.size()) {
                    try {
                        r = (String)this.tcpRelays.elementAt(i);
                        e = relay.createElement("tcpaddr", this.trimProtocol(r));
                        relay.appendChild((Element)e);
                    }
                    catch (Exception ez) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (!this.isServer && !this.isClient) {
                relay.appendChild(relay.createElement("isOff"));
            }
            padv.putServiceParam(PeerGroup.relayProtoClassID, relay);
        }
        catch (Exception ez) {
            Thread.dumpStack();
        }
    }

    private String trimProtocol(String s) {
        int i = s != null ? s.indexOf(PROTOCOL_DELIMITER) : -1;
        return i > -1 ? s.substring(i + PROTOCOL_DELIMITER.length()) : s;
    }
}

