/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.TransportAdvertisement;

public class TcpConfigurator {
    public static final int DEFAULT_PORT = 9701;
    public static final int DEFAULT_MULTICAST_PORT = 1234;
    public static final int DEFAULT_MULTICAST_SIZE = 16384;
    public static final String DEFAULT_MULTICAST_ADDR = "224.0.1.85";
    public boolean enabled = false;
    private TCPAdv tcpAdv = null;

    public TcpConfigurator(ConfigParams configAdv) throws RuntimeException {
        try {
            Element param = configAdv.getServiceParam(PeerGroup.tcpProtoClassID);
            if (param == null) {
                throw new RuntimeException("no advertisement");
            }
            this.enabled = !param.getChildren("isOff").hasMoreElements();
            Enumeration tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType());
            if (!tcpChilds.hasMoreElements()) {
                throw new RuntimeException("Missing TCP Advertisment");
            }
            param = (Element)tcpChilds.nextElement();
            this.tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
        }
        catch (Exception thatsbad2) {
            throw new RuntimeException("Broken ConfigParams. Cannot proceed.");
        }
    }

    public TcpConfigurator() throws RuntimeException {
        try {
            this.tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(TCPAdv.getAdvertisementType());
            this.tcpAdv.setProtocol("tcp");
            this.tcpAdv.setPort(9701);
            this.tcpAdv.setMulticastAddr(DEFAULT_MULTICAST_ADDR);
            this.tcpAdv.setMulticastPort(1234);
            this.tcpAdv.setMulticastSize(16384);
            this.tcpAdv.setMulticastState(true);
            this.tcpAdv.setServer(null);
            this.tcpAdv.setServerEnabled(false);
            this.tcpAdv.setInterfaceAddress(null);
            this.tcpAdv.setConfigMode("auto");
        }
        catch (Exception serious) {
            throw new RuntimeException(serious.getMessage());
        }
    }

    public void save(ConfigParams padv) {
        StructuredDocument param = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
        StructuredDocumentUtils.copyElements(param, param, (StructuredDocument)this.tcpAdv.getDocument(MimeMediaType.XMLUTF8));
        if (!this.enabled) {
            param.appendChild(param.createElement("isOff"));
        }
        padv.putServiceParam(PeerGroup.tcpProtoClassID, param);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.tcpAdv.setClientEnabled(enabled);
    }

    public boolean isClientEnabled() {
        return this.tcpAdv.isClientEnabled();
    }

    public int getPort() {
        return this.tcpAdv.getPort();
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Bad port: " + port);
        }
        this.tcpAdv.setPort(port);
    }

    public boolean getMulticastState() {
        return this.tcpAdv.getMulticastState();
    }

    public void setMulticastState(boolean multicastState) {
        this.tcpAdv.setMulticastState(multicastState);
    }

    public String getMulticastAddr() {
        return this.tcpAdv.getMulticastAddr();
    }

    public void setMulticastAddr(String multicastaddr) {
        try {
            InetAddress addr = InetAddress.getByName(multicastaddr);
            if (!addr.isMulticastAddress()) {
                throw new IllegalArgumentException("Not a multicast address: " + multicastaddr);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown multicast address: " + multicastaddr);
        }
        this.tcpAdv.setMulticastAddr(multicastaddr);
    }

    public int getMulticastPort() {
        return this.tcpAdv.getMulticastPort();
    }

    public void setMulticastPort(int multicastport) {
        if (multicastport < 0 || multicastport > 65535) {
            throw new IllegalArgumentException("Bad multicast port: " + multicastport);
        }
        this.tcpAdv.setMulticastPort(multicastport);
    }

    public int getMulticastSize() {
        return this.tcpAdv.getMulticastSize();
    }

    public void setMulticastSize(int multicastsize) {
        this.tcpAdv.setMulticastSize(multicastsize);
    }

    public String getServer() {
        return this.tcpAdv.getServer();
    }

    public void setServer(String a) {
        this.tcpAdv.setServer(a);
    }

    public boolean isServerEnabled() {
        return this.tcpAdv.isServerEnabled();
    }

    public String getInterfaceAddress() {
        return this.tcpAdv.getInterfaceAddress();
    }

    public void setInterfaceAddress(String ia) {
        this.tcpAdv.setInterfaceAddress(ia);
    }

    public String getConfigMode() {
        return this.tcpAdv.getConfigMode();
    }

    public void setConfigMode(String mode) {
        this.tcpAdv.setConfigMode(mode);
    }

    public void setServerEnabled(boolean enabled) {
        this.tcpAdv.setServerEnabled(enabled);
    }

    public String toString() {
        String res = "inet addr:" + this.tcpAdv.getInterfaceAddress() + ":" + this.tcpAdv.getPort() + "\n";
        res = this.tcpAdv.getMulticastState() ? res + "mcast addr:" + this.tcpAdv.getMulticastAddr() + ":" + this.tcpAdv.getMulticastPort() + " max size= " + this.tcpAdv.getMulticastSize() + "\n" : res + "mcast off\n";
        res = this.tcpAdv.isServerEnabled() ? res + "Server addr:" + this.tcpAdv.getServer() + "\n" : res + "server disabled\n";
        return res;
    }
}

