/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.endpoint;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Messenger;

public class WeakMessengerCache
extends WeakHashMap {
    public WeakMessengerCache() {
    }

    public WeakMessengerCache(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakMessengerCache(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WeakMessengerCache(Map t) {
        super(t);
    }

    public Messenger putMessenger(Messenger messenger) {
        if (messenger == null) {
            throw new RuntimeException("null Messenger");
        }
        WeakReference<Messenger> oldRef = this.put(messenger.getDestinationAddressObject(), new WeakReference<Messenger>(messenger));
        if (oldRef != null) {
            return (Messenger)oldRef.get();
        }
        return null;
    }

    public Messenger getMessenger(EndpointAddress addr) {
        WeakReference ref = (WeakReference)this.get(addr);
        if (ref == null) {
            return null;
        }
        return (Messenger)ref.get();
    }
}

