/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Timer;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.socket.SocketToPipe;

public class SocketProxyServer
implements PipeMsgListener {
    public static String CMD_NAMESPACE = "jxta";
    public static String CMD_TAG = "JxtaSocketProxyCmd";
    public static String PEERADV_TAG = "JxtaSocketProxyPeerAdv";
    public static String CMD_PIPEADV_TAG = "JxtaSocketProxyCmdPipeAdv";
    public static String DATAIN_PIPEADV_TAG = "JxtaSocketProxyDataInPipeAdv";
    public static String DATAOUT_PIPEADV_TAG = "JxtaSocketProxyDataOutPipeAdv";
    public static String CONNECT = "Connect";
    public static String CLOSE = "Close";
    public static String CONNECT_GRANTED = "ConnectGranted";
    public static String CONNECT_DENY = "ConnectDeny";
    public static String DEFAULT_NAMESPACE = "jxta";
    public static String DEFAULT_NAME = "JxtaSocketProxyData";
    public static MimeMediaType DEFAULT_MEDIATYPE = MimeMediaType.AOS;
    public static long DEFAULT_WATCHDOG_PERIOD = 60000L;
    public static long DEFAULT_BEAT_PERIOD = 900000L;
    private String tagNameSpace = DEFAULT_NAMESPACE;
    private String tagName = DEFAULT_NAME;
    private MimeMediaType mediaType = DEFAULT_MEDIATYPE;
    private PeerGroup group = null;
    private PipeAdvertisement proxyAdv = null;
    private InputPipe proxyInputPipe = null;
    private InetAddress serverAddr = null;
    private int serverPort = 0;
    private static long DEFAULT_TIMEOUT = 300000L;
    private Timer timer = new Timer();

    public SocketProxyServer(InetAddress serverAddr, int serverPort, PeerGroup group, PipeAdvertisement proxyAdv, String tagNameSpace, String tagName, MimeMediaType mediaType) throws IOException {
        if (tagNameSpace != null) {
            this.tagNameSpace = tagNameSpace;
        }
        if (tagName != null) {
            this.tagName = tagName;
        }
        if (mediaType != null) {
            this.mediaType = mediaType;
        }
        this.group = group;
        this.proxyAdv = proxyAdv;
        this.serverAddr = serverAddr;
        this.serverPort = serverPort;
        PipeService pipeService = group.getPipeService();
        this.proxyInputPipe = pipeService.createInputPipe(proxyAdv, this);
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void processMsg(Message msg) {
        String cmd = null;
        try {
            MessageElement el = msg.getMessageElement(CMD_NAMESPACE, CMD_TAG);
            if (el == null) {
                return;
            }
            cmd = el.toString();
        }
        catch (Exception ez1) {
            return;
        }
        if (cmd.equals(CONNECT)) {
            this.processConnectMsg(msg);
        }
    }

    private void processConnectMsg(Message msg) {
        PeerAdvertisement peerAdv = null;
        PipeAdvertisement cmdPipeAdv = null;
        PipeAdvertisement dataInPipeAdv = null;
        PipeAdvertisement dataOutPipeAdv = null;
        MessageElement el = null;
        try {
            el = msg.getMessageElement(CMD_NAMESPACE, PEERADV_TAG);
            if (el != null) {
                peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, el.getStream());
            }
        }
        catch (Exception ez1) {
            return;
        }
        try {
            el = msg.getMessageElement(CMD_NAMESPACE, CMD_PIPEADV_TAG);
            if (el != null) {
                cmdPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, el.getStream());
            }
        }
        catch (Exception ez1) {
            return;
        }
        try {
            el = msg.getMessageElement(CMD_NAMESPACE, DATAIN_PIPEADV_TAG);
            if (el != null) {
                dataInPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, el.getStream());
            }
        }
        catch (Exception ez1) {
            return;
        }
        try {
            el = msg.getMessageElement(CMD_NAMESPACE, DATAOUT_PIPEADV_TAG);
            if (el != null) {
                dataOutPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, el.getStream());
            }
        }
        catch (Exception ez1) {
            return;
        }
        try {
            DiscoveryService discovery = this.group.getDiscoveryService();
            discovery.publish(peerAdv, 0);
        }
        catch (Exception ez1) {
            // empty catch block
        }
        SocketToPipe socketPipe = null;
        try {
            socketPipe = new SocketToPipe(this.serverAddr, this.serverPort);
            socketPipe.connect(this.group, dataOutPipeAdv, dataInPipeAdv, peerAdv, null, this.tagNameSpace, this.tagName, this.mediaType, this.timer, DEFAULT_WATCHDOG_PERIOD, DEFAULT_BEAT_PERIOD, DEFAULT_BEAT_PERIOD);
            return;
        }
        catch (Exception ez1) {
            return;
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            msg = event.getMessage();
            if (msg != null) {
                this.processMsg(msg);
            }
        }
        catch (Exception e) {}
    }

    public static void connect(PeerGroup userGroup, PipeAdvertisement serverPipeAdv, PeerAdvertisement serverPeerAdv, PipeAdvertisement dataOutAdv, PipeAdvertisement dataInAdv, String userTagNameSpace, String userTagName, MimeMediaType userMediaType) throws IOException {
        PipeService pipeService = userGroup.getPipeService();
        PipeAdvertisement localCmdAdv = SocketProxyServer.createLocalCmdAdv(userGroup, serverPipeAdv.getType());
        if (localCmdAdv == null) {
            throw new IOException("Cannot create PipeAdvertisement");
        }
        OutputPipe outCmd = null;
        outCmd = serverPeerAdv != null ? pipeService.createOutputPipe(serverPipeAdv, serverPeerAdv.getPeerID(), DEFAULT_TIMEOUT) : pipeService.createOutputPipe(serverPipeAdv, DEFAULT_TIMEOUT);
        if (outCmd != null) {
            Message msg = new Message();
            msg.addMessageElement(CMD_NAMESPACE, new StringMessageElement(CMD_TAG, CONNECT, null));
            Document doc = null;
            InputStreamMessageElement el = null;
            try {
                PeerAdvertisement localPeerAdv = userGroup.getPeerAdvertisement();
                doc = localPeerAdv.getDocument(MimeMediaType.XMLUTF8);
                el = new InputStreamMessageElement(PEERADV_TAG, MimeMediaType.XMLUTF8, doc.getStream(), null);
                msg.addMessageElement(CMD_NAMESPACE, el);
            }
            catch (Exception ez1) {
                throw new IOException("Cannot create PeerAdv element");
            }
            try {
                doc = localCmdAdv.getDocument(MimeMediaType.XMLUTF8);
                el = new InputStreamMessageElement(CMD_PIPEADV_TAG, MimeMediaType.XMLUTF8, doc.getStream(), null);
                msg.addMessageElement(CMD_NAMESPACE, el);
            }
            catch (Exception ez1) {
                throw new IOException("Cannot create PeerAdv element");
            }
            try {
                doc = dataInAdv.getDocument(MimeMediaType.XMLUTF8);
                el = new InputStreamMessageElement(DATAIN_PIPEADV_TAG, MimeMediaType.XMLUTF8, doc.getStream(), null);
                msg.addMessageElement(CMD_NAMESPACE, el);
            }
            catch (Exception ez1) {
                throw new IOException("Cannot create PeerAdv element");
            }
            try {
                doc = dataOutAdv.getDocument(MimeMediaType.XMLUTF8);
                el = new InputStreamMessageElement(DATAOUT_PIPEADV_TAG, MimeMediaType.XMLUTF8, doc.getStream(), null);
                msg.addMessageElement(CMD_NAMESPACE, el);
            }
            catch (Exception ez1) {
                throw new IOException("Cannot create PeerAdv element");
            }
            outCmd.send(msg);
        }
    }

    private static PipeAdvertisement createLocalCmdAdv(PeerGroup userGroup, String type) {
        PipeAdvertisement adv = null;
        try {
            adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        }
        catch (Exception all) {
            return null;
        }
        adv.setPipeID(IDFactory.newPipeID(userGroup.getPeerGroupID()));
        adv.setName("Created by SocketProxyClient");
        adv.setType(type);
        return adv;
    }
}

