/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.cqlsearch;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import nl.mpi.annex.cqlsearch.CQLConfigConfigInfo;
import nl.mpi.annex.cqlsearch.CQLConfigCorpus;
import nl.mpi.annex.cqlsearch.CQLConfigDatabaseInformation;
import nl.mpi.annex.cqlsearch.CQLConfigSchemaInfo;
import org.apache.log4j.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Root
public class CQLConfig {
    @Element
    private String host;
    @Element
    private String port;
    @Element
    private String database;
    @Element
    private CQLConfigDatabaseInformation dbinfo;
    @ElementList
    private ArrayList<CQLConfigCorpus> corpora;
    @ElementList
    private ArrayList<CQLConfigSchemaInfo> resultschemas;
    @ElementList
    private ArrayList<CQLConfigConfigInfo> configinfo;
    private static Serializer serializer = new Persister();
    private static Logger logger = Logger.getLogger((String)"ANNEX.CQLServlet");

    private CQLConfig() {
    }

    public static CQLConfig createCQLConfig(String path) {
        if (path == null) {
            path = "";
        }
        if (!path.equals("")) {
            path = path + "/";
        }
        logger.info((Object)("Reading and processing: " + path + "config/CQLConfig.xml"));
        String file = path + "config/CQLConfig.xml";
        File source = new File(file);
        CQLConfig c = new CQLConfig();
        try {
            c = (CQLConfig)serializer.read(CQLConfig.class, source);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot read the XML configuration file: " + e), (Throwable)e);
        }
        logger.info((Object)"Processed the XML Configuration file and instantiated it into a CQLConfig.");
        return c;
    }

    public void write(OutputStream out) {
        try {
            serializer.write((Object)this, out);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public CQLConfigDatabaseInformation getDatabaseInfo() {
        return this.dbinfo;
    }

    public ArrayList<CQLConfigCorpus> getSearchableCorpora() {
        return this.corpora;
    }

    public ArrayList<CQLConfigSchemaInfo> getSupportedSchemas() {
        return this.resultschemas;
    }

    public ArrayList<CQLConfigConfigInfo> getConfiginfo() {
        return this.configinfo;
    }
}

