/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nl.mpi.annex.data.AnnexAnnotation;
import nl.mpi.annex.data.AnnexMediaDescriptor;
import nl.mpi.annex.data.AnnexParser;
import nl.mpi.annex.data.AnnexTier;
import nl.mpi.annex.data.AnnexTranscription;
import nl.mpi.annex.data.DataUtil;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnexChatParser {
    private static Logger _logger = Logger.getLogger((String)AnnexChatParser.class.getName());
    private static final char CTRL_U = '\u0015';

    public static void parse(File file, AnnexTranscription transcription) throws IOException {
        String[] fullLines = DataUtil.readLines(file, null);
        String encoding = AnnexChatParser.encodingFromHeader(fullLines, file.getCanonicalPath());
        if (encoding != null) {
            try {
                fullLines = DataUtil.readLines(file, encoding);
            }
            catch (MalformedInputException mie) {
                _logger.warn((Object)("File claims to be " + encoding + " but is not, reloading as ISO-8859-1: " + file));
                fullLines = DataUtil.readLines(file, "ISO-8859-1");
            }
        }
        AnnexChatParser.parse(file.getCanonicalPath(), fullLines, transcription);
    }

    public static void parse(URL url, AnnexTranscription transcription) throws IOException {
        InputSource inputSource = new InputSource(url.openStream());
        String[] fullLines = DataUtil.readLines(inputSource, null);
        String encoding = AnnexChatParser.encodingFromHeader(fullLines, "remote node at " + url);
        if (encoding != null) {
            inputSource = new InputSource(url.openStream());
            try {
                fullLines = DataUtil.readLines(inputSource, encoding);
            }
            catch (MalformedInputException mie) {
                _logger.warn((Object)("Remote file claims to be " + encoding + " but is not, reloading as ISO-8859-1: " + url));
                fullLines = DataUtil.readLines(inputSource, "ISO-8859-1");
            }
        }
        AnnexChatParser.parse("remote node at " + url, fullLines, transcription);
    }

    public static void parse(String fileName, String[] fullLines, AnnexTranscription transcription) throws IOException {
        String soundFileName = null;
        boolean aligned = false;
        for (int i = 0; i < fullLines.length; ++i) {
            if (fullLines[i].indexOf(21) == -1) continue;
            aligned = true;
            if (fullLines[i].indexOf("%snd") == -1 && fullLines[i].indexOf("%mov") == -1) continue;
            soundFileName = AnnexChatParser.parseSoundTimeTag(fullLines[i], "?", fileName)[0];
            if (soundFileName == null || "?".equals(soundFileName)) break;
            soundFileName = AnnexChatParser.addMediaFile(transcription.getMediaDescriptors(), soundFileName, fileName);
            break;
        }
        HashMap<String, String> participantHash = new HashMap<String, String>();
        transcription.setInfo(AnnexChatParser.parseHeaders(fullLines, participantHash, transcription.getMediaDescriptors(), fileName));
        long lastUsedTime = 0L;
        HashMap<String, AnnexTier> tierHash = new HashMap<String, AnnexTier>();
        ArrayList<ChatBlock> chatBlocks = new ArrayList<ChatBlock>();
        for (int i = 0; i < fullLines.length; ++i) {
            String fullLine;
            int j;
            if (!fullLines[i].startsWith("*")) {
                String trimmed = fullLines[i].trim();
                if (!trimmed.startsWith("*")) continue;
                if (trimmed.lastIndexOf(42) > 0) {
                    _logger.debug((Object)("Continuation line has initial * after whitespace: '" + fullLines[i].replace('\u0015', '|').trim() + "' in: " + fileName));
                    continue;
                }
                _logger.info((Object)("Continuation line starts with * after whitespace: '" + fullLines[i].replace('\u0015', '|').trim() + "' in: " + fileName));
                continue;
            }
            int firstLine = i;
            int lastLine = AnnexChatParser.findBlockEnd(fullLines, i, aligned);
            if (lastLine == -1) {
                --i;
                aligned = false;
                continue;
            }
            int nLines = lastLine - firstLine + 1;
            String lastMainTierName = "*";
            ChatBlock block = new ChatBlock(nLines);
            block.timeKnown = false;
            block.beginTime = lastUsedTime;
            block.endTime = block.beginTime + 1000L;
            for (j = 0; j < nLines; ++j) {
                fullLine = fullLines[firstLine + j];
                if (fullLine.startsWith("@")) {
                    if (fullLine.startsWith("@Begin")) {
                        _logger.error((Object)("Chat file contains second @Begin in line: " + (firstLine + j + 1) + " text: '" + fullLine.replace('\u0015', '|').trim() + "' in: " + fileName));
                        fullLines[firstLine + j] = null;
                        continue;
                    }
                    if (fullLine.startsWith("@Turn") || fullLine.startsWith("@turn") || fullLine.toLowerCase().startsWith("@end")) {
                        fullLines[firstLine + j] = null;
                        continue;
                    }
                    if (fullLine.indexOf(58) == -1) {
                        fullLine = fullLine + ":\t";
                    }
                    int firstSpace = fullLine.indexOf(32);
                    int firstColon = fullLine.indexOf(58);
                    if (firstSpace != -1 && firstSpace < firstColon) {
                        fullLine = fullLine.substring(0, firstColon).replace(' ', '_').replace('\t', '_') + fullLine.substring(firstColon);
                    }
                    if (fullLine.indexOf(9) == -1) {
                        fullLine = firstSpace == -1 ? fullLine + "\t" : fullLine.replaceFirst(" ", "\t");
                    }
                    fullLines[firstLine + j] = "%META_" + fullLine.substring(1);
                    continue;
                }
                if (!fullLine.matches("^\\s\u0015[^\u0015]*\u0015\\s$")) continue;
                fullLines[firstLine + j] = null;
                String[] soundTime = AnnexChatParser.parseSoundTimeTag(fullLine, "?", fileName);
                if (soundTime == null) {
                    if (fullLine.indexOf("\u0015%pic:") == -1) continue;
                    fullLines[firstLine + j] = fullLine;
                    continue;
                }
                if (soundTime[0] != null && !soundTime[0].equals(soundFileName) && !soundTime[0].equals("?")) {
                    soundFileName = AnnexChatParser.addMediaFile(transcription.getMediaDescriptors(), soundTime[0], fileName);
                }
                if (soundTime[1] == null || soundTime[2] == null) {
                    _logger.warn((Object)("Chat parser syntax error in snd line: " + (firstLine + j + 1) + " text: '" + fullLine.replace('\u0015', '|').trim() + "' in: " + fileName));
                    throw new IOException("AnnexChatParser: Incomplete snd line: " + fullLine.replace('\u0015', '|').trim());
                }
                try {
                    block.beginTime = (long)Float.parseFloat(soundTime[1]);
                    block.endTime = (long)Float.parseFloat(soundTime[2]);
                    block.timeKnown = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    _logger.warn((Object)("Chat parser number format error in snd line: " + (firstLine + j + 1) + " text: '" + fullLine.replace('\u0015', '|').trim() + "' in: " + fileName));
                    throw new IOException("AnnexChatParser: Malformed snd line: " + fullLine.replace('\u0015', '|').trim());
                }
            }
            for (j = 0; j < nLines; ++j) {
                fullLine = fullLines[firstLine + j];
                block.subAnnotations.set(j, null);
                block.annotationValues[j] = null;
                String[] tokens = null;
                if (fullLine != null) {
                    if (fullLine.startsWith("*")) {
                        tokens = AnnexChatParser.segmentLines(fullLines, firstLine + j, firstLine + nLines - 1, fileName);
                        tokens[0] = tokens[0].substring(1);
                        lastMainTierName = tokens[0];
                    } else if (fullLine.startsWith("%")) {
                        tokens = AnnexChatParser.segmentLines(fullLines, firstLine + j, firstLine + nLines - 1, fileName);
                        tokens[0] = lastMainTierName + "-" + tokens[0].substring(1);
                    } else {
                        if (fullLine.length() > 0 && fullLine.charAt(0) != '\u0015' && fullLine.charAt(0) != ' ' && fullLine.charAt(0) != '\t') {
                            if (fullLine.length() > 0 && fullLine.trim().length() == 0) {
                                _logger.info((Object)("Line contains only non-space, non-TAB control chars at line " + (firstLine + j + 1) + " in: " + fileName));
                            } else {
                                _logger.warn((Object)("Line is neither tier start nor continuation at line " + (firstLine + j + 1) + " text: '" + fullLine.replace('\u0015', '|').trim() + "' in: " + fileName));
                                throw new IOException("Unknown Chat line type, syntax error in line " + (firstLine + j + 1));
                            }
                        }
                        block.tierNames[j] = null;
                        block.annotationValues[j] = null;
                    }
                }
                if (tokens == null) continue;
                block.tierNames[j] = tokens[0];
                if (tokens[1].indexOf(21) == -1) {
                    block.annotationValues[j] = tokens[1];
                } else {
                    block.subAnnotations.set(j, AnnexChatParser.processMultiTagLine(tokens[1].split("\u0015"), soundFileName, transcription.getMediaDescriptors(), block.beginTime, block.endTime, fileName));
                    block.timeKnown = AnnexChatParser.adjustBlockTimespan(block.subAnnotations.get(j), block, block.timeKnown, fileName);
                }
                if (tierHash.containsKey(tokens[0])) continue;
                boolean mainTier = tokens[0].equals(lastMainTierName);
                AnnexTier tier = AnnexChatParser.makeTier(tokens[0], fileName, mainTier);
                tier.hasVirtualTime = !aligned;
                tier.participant = participantHash.get(tier.name.toLowerCase());
                String participantCode = tier.name;
                if (!mainTier) {
                    tier.parentTier = (AnnexTier)tierHash.get(lastMainTierName);
                    tier.participant = participantHash.get(lastMainTierName.toLowerCase());
                    participantCode = lastMainTierName;
                }
                if (tier.participant == null) {
                    if (participantHash.isEmpty()) {
                        tier.participant = "unknown";
                    } else {
                        _logger.info((Object)("Unknown participant: " + participantCode + " in line " + (firstLine + j + 1) + " of file: " + fileName));
                        tier.participant = "unknown";
                        participantHash.put(participantCode.toLowerCase(), tier.participant);
                    }
                }
                transcription.getTiers().add(tier);
                tierHash.put(tier.name, tier);
            }
            chatBlocks.add(block);
            lastUsedTime = block.endTime;
            i = lastLine;
        }
        HashMap done = new HashMap();
        for (int i = 0; i < chatBlocks.size(); ++i) {
            ChatBlock block = (ChatBlock)chatBlocks.get(i);
            AnnexAnnotation annotation = null;
            AnnexAnnotation depAnnotation = null;
            done.clear();
            for (int j = 0; j < block.tierNames.length; ++j) {
                if (block.tierNames[j] == null || done.containsKey(block.tierNames[j]) || block.tierNames[j].indexOf(45) != -1) continue;
                String mainTierName = block.tierNames[j];
                int nAnnotations = 0;
                for (int k = j; k < block.tierNames.length; ++k) {
                    if (!mainTierName.equals(block.tierNames[k])) continue;
                    ++nAnnotations;
                }
                long timeStep = (block.endTime - block.beginTime) / (long)nAnnotations;
                long lastEndTime = block.beginTime;
                block9: for (int k = j; k < block.tierNames.length; ++k) {
                    boolean isAligned;
                    if (!mainTierName.equals(block.tierNames[k])) continue;
                    boolean bl = isAligned = nAnnotations == 1;
                    if (block.subAnnotations.get(k) != null && block.subAnnotations.get(k).size() > 0) {
                        ((AnnexTier)tierHash.get((Object)mainTierName)).annotations.addAll((Collection<AnnexAnnotation>)block.subAnnotations.get(k));
                        annotation = ((AnnexTier)tierHash.get((Object)mainTierName)).annotations.get(((AnnexTier)tierHash.get((Object)mainTierName)).annotations.size() - 1);
                    } else {
                        annotation = new AnnexAnnotation(block.annotationValues[k], lastEndTime, lastEndTime + timeStep, isAligned && block.timeKnown, null);
                        annotation.interpolatedTime = nAnnotations > 1;
                        ((AnnexTier)tierHash.get((Object)mainTierName)).annotations.add(annotation);
                        lastEndTime = annotation.endTime;
                    }
                    for (int m = k + 1; m < block.tierNames.length; ++m) {
                        if (block.tierNames[m] == null) continue;
                        if (!block.tierNames[m].startsWith(mainTierName) || block.tierNames[m].indexOf(45) == -1) continue block9;
                        if (block.subAnnotations.get(m) != null && block.subAnnotations.get(m).size() > 0) {
                            for (AnnexAnnotation subAnno : block.subAnnotations.get(m)) {
                                subAnno.refAnnotation = annotation;
                                ((AnnexTier)tierHash.get((Object)block.tierNames[m])).annotations.add(subAnno);
                            }
                            continue;
                        }
                        depAnnotation = new AnnexAnnotation(block.annotationValues[m], annotation.beginTime, annotation.endTime, isAligned && block.timeKnown, null);
                        depAnnotation.refAnnotation = annotation;
                        ((AnnexTier)tierHash.get((Object)block.tierNames[m])).annotations.add(depAnnotation);
                    }
                }
                if (annotation != null) {
                    annotation.endTime = block.endTime;
                    if (depAnnotation != null) {
                        depAnnotation.endTime = annotation.endTime;
                    }
                }
                done.put(block.tierNames[j], null);
            }
        }
        AnnexChatParser.correctTimes(transcription.getTiers(), chatBlocks, fileName);
    }

    private static String encodingFromHeader(String[] lines, String name) {
        for (int i = 0; i < lines.length; ++i) {
            String trimmed = lines[i].trim().toLowerCase();
            if (trimmed.startsWith("*")) {
                return null;
            }
            if (!trimmed.startsWith("@")) continue;
            if (trimmed.indexOf("utf8") != -1) {
                return "UTF-8";
            }
            if (trimmed.indexOf("utf16") == -1) continue;
            return "UTF-16";
        }
        _logger.warn((Object)("Chat file without encoding headers has no body in " + lines.length + " lines: " + name));
        return null;
    }

    private static String addMediaFile(List<AnnexMediaDescriptor> media, String soundName, String fileName) {
        if (soundName.indexOf(46) == -1) {
            soundName = soundName + ".wav";
        }
        AnnexMediaDescriptor md = new AnnexMediaDescriptor();
        md.fileName = soundName;
        md.mimeType = DataUtil.getMediaTypeFromName(soundName);
        if (!media.contains(md)) {
            if (!media.isEmpty()) {
                _logger.warn((Object)("Extra media file found for Chat: " + soundName + " in: " + fileName));
            }
            media.add(md);
        }
        return soundName;
    }

    private static String parseHeaders(String[] fullLines, HashMap<String, String> participantHash, ArrayList<AnnexMediaDescriptor> mediaDescriptors, String fileName) {
        StringBuilder headers = new StringBuilder();
        for (int i = 0; i < fullLines.length; ++i) {
            String[] tokens;
            CharSequence part;
            String full = fullLines[i];
            String trimmed = full.trim();
            if (full.startsWith("*")) break;
            if (trimmed.startsWith("*")) {
                _logger.info((Object)("Header line " + i + " has * after leading whitespace: '" + full.replace('\u0015', '|').trim() + "' in: " + fileName));
            } else if (trimmed.startsWith("%") && !full.startsWith("%")) {
                _logger.info((Object)("Header line " + i + " has % after leading whitespace: '" + full.replace('\u0015', '|').trim() + "' in: " + fileName));
            } else if (trimmed.startsWith("@") && !full.startsWith("@")) {
                _logger.info((Object)("Header line " + i + " has @ after leading whitespace: '" + full.replace('\u0015', '|').trim() + "' in: " + fileName));
            }
            if (full.startsWith("%act") || full.startsWith("%com") || full.startsWith("%sit")) {
                headers.append("@InHeader:\t").append(full.replace('\u0015', '|').trim()).append("\n");
                if (!full.startsWith("%sit")) continue;
                _logger.debug((Object)("Found %sit in header: '" + full.replace('\u0015', '|').trim() + "' in: " + fileName));
                continue;
            }
            if (full.startsWith("%")) {
                _logger.info((Object)("Spurious % line before first annotation treated as header: '" + full.replace('\u0015', '|').trim() + "' in: " + fileName));
                headers.append("@BadHeader:\t").append(full.replace('\u0015', '|').trim()).append("\n");
                continue;
            }
            if (!full.startsWith("@")) {
                headers.append("\t").append(full.replace('\u0015', '|').trim()).append("\n");
                continue;
            }
            headers.append(full.replace('\u0015', '|').trim()).append("\n");
            if (full.toLowerCase().startsWith("@participants") && full.length() > 13) {
                part = new StringBuilder(full.substring(full.charAt(13) == ':' ? 14 : 13).trim());
                for (int j = i + 1; j < fullLines.length && (fullLines[j].startsWith(" ") || fullLines[j].startsWith("\t")); ++j) {
                    ((StringBuilder)part).append(' ').append(fullLines[j].trim());
                }
                tokens = ((StringBuilder)part).toString().split(",");
                String[] tokens2 = ((StringBuilder)part).toString().split(";");
                if (tokens2.length > tokens.length) {
                    tokens = tokens2;
                }
                for (int j = 0; j < tokens.length; ++j) {
                    String token = tokens[j].trim();
                    int firstSpace = token.indexOf(32);
                    if (firstSpace == -1) {
                        firstSpace = token.indexOf(9);
                    }
                    if (firstSpace == -1) continue;
                    String tierName = token.substring(0, firstSpace).trim();
                    String participant = token.substring(firstSpace).trim();
                    participantHash.put(tierName.toLowerCase(), participant);
                }
                continue;
            }
            if (!full.toLowerCase().startsWith("@mediafile")) continue;
            _logger.debug((Object)("Found @mediafile line: " + full.replace('\u0015', '|').trim() + " in: " + fileName));
            part = full.substring(10).trim();
            tokens = ((String)part).split(",");
            for (int j = 0; j < tokens.length; ++j) {
                String soundFileName = tokens[j].trim();
                soundFileName = AnnexChatParser.addMediaFile(mediaDescriptors, soundFileName, fileName);
            }
        }
        return headers.toString();
    }

    private static int findBlockEnd(String[] fullLines, int line, boolean aligned) {
        int lastLine = line;
        boolean foundSnd = false;
        if (fullLines[lastLine].indexOf(21) != -1) {
            foundSnd = true;
        }
        while (lastLine + 1 < fullLines.length && fullLines[lastLine + 1].indexOf(42) != 0) {
            if (aligned && !foundSnd && fullLines[++lastLine].indexOf("\u0015%snd") != -1) {
                foundSnd = true;
            }
            if (!aligned || foundSnd || fullLines[lastLine].indexOf("\u0015%mov") == -1) continue;
            foundSnd = true;
        }
        if (foundSnd || !aligned) {
            return lastLine;
        }
        return -1;
    }

    private static String[] parseSoundTimeTag(String content, String soundFileName, String fileName) {
        String[] parsed = new String[3];
        int posX = content.indexOf(21);
        if (posX == -1 || posX == content.length() - 1) {
            return null;
        }
        int posY = content.indexOf(21, posX + 1);
        if (posY == -1) {
            _logger.warn((Object)("Incomplete sound/time tag in line: '" + content.replace('\u0015', '|').trim() + "' in: " + fileName));
            return parsed;
        }
        String tag = content.substring(posX + 1, posY);
        if (tag.indexOf("%pic") != -1) {
            return parsed;
        }
        if (tag.indexOf("%mov") != -1) {
            if (AnnexParser.isTraceMode()) {
                _logger.debug((Object)("Treated mov tag as snd in line: '" + content.replace('\u0015', '|').trim() + "' in: " + fileName));
            }
            tag = tag.replaceFirst("mov", "snd");
        }
        if ((posX = tag.indexOf("%snd:")) != -1) {
            tag = tag.substring(posX + 5).trim();
        } else {
            StringBuilder newTag = new StringBuilder("\"");
            newTag.append(soundFileName);
            newTag.append("\" ");
            newTag.append(tag);
            tag = newTag.toString();
        }
        posY = tag.lastIndexOf(34);
        int posZ = tag.indexOf(34);
        if (posY != -1 && posZ == posY) {
            _logger.warn((Object)("Unbalanced quotes in sound/time tag in line: '" + content.replace('\u0015', '|').trim() + "' in: " + fileName));
            return parsed;
        }
        if (posY != -1 && posY == tag.length() - 1) {
            _logger.warn((Object)("Trailing quotes in sound/time tag, no times(?) in line: '" + content.replace('\u0015', '|').trim() + "' in: " + fileName));
            return parsed;
        }
        posX = tag.indexOf(32, posY + 1);
        if (posX == -1 && posY == -1) {
            tag = tag.replace('_', ' ');
        } else if (posX <= -1 || posY != -1) {
            StringBuilder newTag = new StringBuilder(tag.substring(0, posZ));
            newTag.append(tag.substring(posZ + 1, posY).replace(' ', '_'));
            newTag.append(tag.substring(posY + 1).replace('_', ' '));
            tag = newTag.toString();
        }
        parsed = tag.split("\\s+");
        if (parsed.length != 3) {
            _logger.warn((Object)("Syntax error in sound/time tag in line: '" + content.replace('\u0015', '|').trim() + "' in: " + fileName));
            return new String[3];
        }
        if (parsed[0].startsWith("\"") && parsed[0].endsWith("\"")) {
            parsed[0] = parsed[0].substring(1, parsed[0].length() - 1);
        }
        if (parsed[2] != null && parsed[2].endsWith("-")) {
            _logger.warn((Object)("Stripped trailing - after end time in: " + fileName));
            parsed[2] = parsed[2].substring(0, parsed[2].length() - 1);
        }
        return parsed;
    }

    private static List<AnnexAnnotation> processMultiTagLine(String[] parts, String soundFileName, List<AnnexMediaDescriptor> media, long initialTime, long finalTime, String fileName) throws IOException {
        ArrayList<AnnexAnnotation> items = new ArrayList<AnnexAnnotation>();
        long endTime = initialTime;
        for (int i = 0; i < parts.length; i += 2) {
            String value = parts[i].trim();
            if (i == 0 && value.length() > 1) {
                int colon = value.indexOf(58);
                if (value.charAt(0) != ' ' && value.charAt(0) != '\t' && colon != -1 && colon != value.length() - 1) {
                    value = value.substring(colon + 1).trim();
                }
            }
            String[] soundTime = null;
            if (i + 1 >= parts.length) {
                if (AnnexParser.isTraceMode()) {
                    _logger.warn((Object)("Last section of line has no CTRL_U info: '" + value + "' in: " + fileName));
                }
                if (finalTime < endTime) {
                    finalTime = endTime + 1L;
                }
                items.add(new AnnexAnnotation(value, endTime, finalTime, false, null));
                return items;
            }
            soundTime = AnnexChatParser.parseSoundTimeTag('\u0015' + parts[i + 1] + '\u0015', "?", fileName);
            if (soundTime == null || soundTime[1] == null || soundTime[2] == null) {
                if (parts[i + 1].startsWith("%pic:")) {
                    if (i + 2 < parts.length) {
                        _logger.warn((Object)("Pictures splitting multi-snd lines are not yet supported: '" + parts[i + 1] + "' in: " + fileName));
                        throw new IOException("CTRL_U picture tag splits line, must be final");
                    }
                    String picName = parts[i + 1].substring(5).replace('\"', '\u0000').trim();
                    value = (value + " [PICTURE: URL=\"" + picName.replaceAll("\u0000", "\\\\\"") + "\"]").trim();
                    items.add(new AnnexAnnotation(value, endTime, finalTime, false, null));
                    return items;
                }
                _logger.warn((Object)("Chat parser syntax error in multi-snd line part: '" + parts[i + 1] + "' in: " + fileName));
                throw new IOException("Expected CTRL_U escape but got something else");
            }
            if (!(soundTime[0] == null || "?".equals(soundTime[0]) || soundTime[0].equals(soundFileName) || (soundTime[0] + ".wav").equals(soundFileName))) {
                soundFileName = AnnexChatParser.addMediaFile(media, soundFileName, fileName);
            }
            try {
                long beginTime = (long)Float.parseFloat(soundTime[1]);
                endTime = (long)Float.parseFloat(soundTime[2]);
                items.add(new AnnexAnnotation(value, beginTime, endTime, true, null));
                continue;
            }
            catch (NumberFormatException nfe) {
                _logger.warn((Object)("Chat parser number format error in multi-snd line part: '" + parts[i + 1] + "' in: " + fileName));
                throw new IOException("AnnexChatParser: Malformed snd line part: " + parts[i + 1]);
            }
        }
        return items;
    }

    private static int findColon(String line, int lineNumber, String fileName) {
        int colon = line.indexOf(58);
        int semicolon = line.indexOf(59);
        boolean warn = false;
        if (colon == -1 && semicolon == -1) {
            return -1;
        }
        if (colon == -1) {
            colon = semicolon;
            warn = true;
        }
        int endSpace = line.indexOf(32);
        int endTab = line.indexOf(9);
        if (endSpace != -1 && endSpace < colon || endTab != -1 && endTab < colon) {
            return -1;
        }
        if (warn) {
            _logger.warn((Object)("Semicolon found where colon expected: '" + line.replace('\u0015', '|').trim() + "' at line " + lineNumber + " in: " + fileName));
        }
        return colon;
    }

    private static boolean adjustBlockTimespan(List<AnnexAnnotation> annotations, ChatBlock block, boolean timeKnown, String fileName) {
        if (annotations == null || annotations.size() == 0) {
            _logger.error((Object)("No annotations in multi-tag line in: " + fileName));
            return timeKnown;
        }
        if (!timeKnown) {
            block.beginTime = Long.MAX_VALUE;
            block.endTime = Long.MIN_VALUE;
        }
        long prevEndTime = Long.MIN_VALUE;
        for (AnnexAnnotation anno : annotations) {
            if (anno.beginTime < prevEndTime) {
                if (anno.endTime < prevEndTime) {
                    _logger.warn((Object)("Removed overlap extending past end of next annotation: " + anno.beginTime + " and " + anno.endTime + " would be both before " + prevEndTime + " in: " + fileName));
                    anno.beginTime = prevEndTime;
                    anno.endTime = prevEndTime + 1L;
                } else {
                    if (prevEndTime - anno.beginTime < 150L) {
                        if (AnnexParser.isTraceMode()) {
                            _logger.debug((Object)("Removed overlap below 150 msec: " + anno.beginTime + " would be before " + prevEndTime + " in: " + fileName));
                        }
                    } else {
                        _logger.warn((Object)("Removed overlap > 150 msec: " + anno.beginTime + " would be before " + prevEndTime + " in: " + fileName));
                    }
                    anno.beginTime = prevEndTime;
                }
            }
            if (anno.beginTime < block.beginTime) {
                if (timeKnown) {
                    _logger.warn((Object)("Pushed block start: " + block.beginTime + " .." + block.endTime + " to: " + anno.beginTime + "... in: " + fileName));
                }
                block.beginTime = anno.beginTime;
            }
            if (anno.endTime <= anno.beginTime) {
                if (anno.endTime == anno.beginTime) {
                    _logger.debug((Object)("Made zero duration annotation 1 msec longer at: " + anno.beginTime + " in: " + fileName));
                } else {
                    _logger.warn((Object)("Removed inversion: " + anno.endTime + " was not after " + anno.beginTime + " in: " + fileName));
                }
                anno.endTime = anno.beginTime + 1L;
            }
            if (anno.endTime > block.endTime) {
                block.endTime = anno.endTime;
            }
            prevEndTime = anno.endTime;
        }
        return true;
    }

    private static String[] segmentLines(String[] lines, int startLine, int blockEndLine, String fileName) throws IOException {
        String line = lines[startLine];
        String[] tokens = new String[2];
        int firstColon = AnnexChatParser.findColon(line, startLine, fileName);
        String context = "";
        if (line.length() > 0 && line.charAt(0) == '*') {
            context = "main ";
        }
        if (firstColon < 1) {
            _logger.error((Object)("Chat parser error, missing colon in " + context + "tier line: " + startLine + " text: '" + line.replace('\u0015', '|').trim() + "' in: " + fileName));
            throw new IOException("Chat parse error, missing colon in " + context + "tier line: " + startLine);
        }
        tokens[0] = line.substring(0, firstColon).trim();
        StringBuilder content = new StringBuilder(line.substring(firstColon + 1).replace('\u0015', '\ufffc').trim().replace('\ufffc', '\u0015'));
        for (int lineNumber = startLine + 1; lineNumber <= blockEndLine && lines[lineNumber] != null && lines[lineNumber].length() > 0 && (lines[lineNumber].charAt(0) == ' ' || lines[lineNumber].charAt(0) == '\t'); ++lineNumber) {
            line = lines[lineNumber];
            content.append(' ').append(line.replace('\u0015', '\ufffc').trim().replace('\ufffc', '\u0015'));
            if (!line.startsWith("*") && !line.startsWith("@") && !line.startsWith("%") || line.length() <= 1 || line.charAt(1) == ' ') continue;
            _logger.debug((Object)("Continuation content for " + context + "tier starts with *, @ or " + '%' + ": '" + line.replace('\u0015', '|').trim() + "' at line " + lineNumber + " in: " + fileName));
        }
        tokens[1] = content.toString();
        return tokens;
    }

    private static void correctTimes(ArrayList<AnnexTier> tiers, ArrayList<ChatBlock> chatBlocks, String fileName) {
        for (int i = 0; i < tiers.size(); ++i) {
            AnnexTier tier = tiers.get(i);
            if (tier.parentTier != null) continue;
            AnnexAnnotation prev = null;
            for (int j = 0; j < tier.annotations.size(); ++j) {
                AnnexAnnotation ann = tier.annotations.get(j);
                if (prev != null && prev.endTime > ann.beginTime && !prev.isTimeAligned && prev.beginTime < ann.beginTime) {
                    if (AnnexParser.isTraceMode()) {
                        _logger.debug((Object)("Replaced guessed end time by next known start time: " + prev.beginTime + ".." + ann.beginTime + " (was " + prev.endTime + ") in: " + fileName));
                    }
                    prev.endTime = ann.beginTime;
                }
                if (prev != null && prev.endTime > ann.beginTime) {
                    int updated = 0;
                    boolean anyUpdates = false;
                    for (int k = 0; k < chatBlocks.size(); ++k) {
                        ChatBlock block = chatBlocks.get(k);
                        if (ann.beginTime != block.beginTime || ann.endTime != block.endTime) continue;
                        String firstTierName = block.tierNames[0];
                        for (int x = 0; x < block.tierNames.length && firstTierName == null; ++x) {
                            firstTierName = block.tierNames[x];
                        }
                        if (firstTierName == null) {
                            _logger.warn((Object)("Block without tiers?? In: " + fileName));
                            firstTierName = "";
                        }
                        if (firstTierName.equals(tier.name)) {
                            prev.endTime = ann.beginTime;
                            updated += AnnexChatParser.updateReferencesTo(prev, tiers);
                            anyUpdates = true;
                            continue;
                        }
                        ann.beginTime = prev.endTime;
                        updated += AnnexChatParser.updateReferencesTo(ann, tiers);
                        anyUpdates = true;
                    }
                    if (updated > 3 && AnnexParser.isTraceMode()) {
                        _logger.debug((Object)("updateReferencesTo at " + tier.name + "[" + ann.beginTime + ".." + ann.endTime + "] re-aligned " + updated + " annotations in: " + fileName));
                    }
                    if (updated == 0 && !anyUpdates) {
                        _logger.warn((Object)("updateReferencesTo failed to correct overlap by " + (prev.endTime - ann.beginTime) + " msec: " + prev.endTime + " still after " + ann.beginTime + " in: " + fileName));
                    }
                }
                prev = ann;
            }
        }
    }

    private static AnnexTier makeTier(String name, String fileName, boolean mainTier) {
        int pos = name.lastIndexOf(45);
        String type = "unknown";
        if (pos != -1) {
            type = name.substring(pos + 1).trim();
        } else if (mainTier) {
            type = "text";
        } else {
            _logger.warn((Object)("Tier type neither text nor dependant: " + name + " in: " + fileName));
        }
        return new AnnexTier(name, type);
    }

    private static int updateReferencesTo(AnnexAnnotation annotation, ArrayList<AnnexTier> tiers) {
        ArrayList<AnnexAnnotation> referers = new ArrayList<AnnexAnnotation>();
        int nChanged = 0;
        for (int i = 0; i < tiers.size(); ++i) {
            AnnexTier tier = tiers.get(i);
            referers.clear();
            for (int j = 0; j < tier.annotations.size(); ++j) {
                AnnexAnnotation ann = tier.annotations.get(j);
                if (ann.refAnnotation != annotation) continue;
                referers.add(ann);
            }
            if (referers.size() == 0) continue;
            AnnexAnnotation referer = null;
            long step = (annotation.endTime - annotation.beginTime) / (long)referers.size();
            for (int j = 0; j < referers.size(); ++j) {
                ++nChanged;
                referer = (AnnexAnnotation)referers.get(j);
                referer.beginTime = annotation.beginTime + (long)j * step;
                referer.endTime = referer.beginTime + step;
                if (j == referers.size() - 1) {
                    referer.endTime = annotation.endTime;
                }
                nChanged += AnnexChatParser.updateReferencesTo(referer, tiers);
            }
        }
        return nChanged;
    }

    private static class ChatBlock {
        public final String[] tierNames;
        public final String[] annotationValues;
        public List<List<AnnexAnnotation>> subAnnotations;
        public long beginTime;
        public long endTime;
        public boolean timeKnown;

        public ChatBlock(int nLines) {
            this.tierNames = new String[nLines];
            this.annotationValues = new String[nLines];
            this.subAnnotations = new ArrayList<List<AnnexAnnotation>>();
            for (int i = 0; i < nLines; ++i) {
                this.subAnnotations.add(new ArrayList());
            }
        }
    }
}

