/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.data;

import java.util.ArrayList;
import java.util.HashMap;
import nl.mpi.annex.data.AnnexAnnotation;
import nl.mpi.annex.data.AnnexMediaDescriptor;
import nl.mpi.annex.data.AnnexTier;
import nl.mpi.annex.data.AnnexTranscription;
import nl.mpi.annex.data.DataUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnexEAFHandler
extends DefaultHandler {
    private ArrayList<AnnexTier> tiers;
    private AnnexTier tier;
    private AnnexAnnotation annotation;
    private HashMap<String, Long> timeSlots;
    private HashMap<String, String> beginTimeHash;
    private HashMap<String, String> endTimeHash;
    private HashMap<String, String> refHash;
    private HashMap<String, ArrayList<String>> refererHash;
    private HashMap<String, String> prevHash;
    private HashMap<String, AnnexAnnotation> idToAnn;
    private String id;
    private StringBuilder textBuffer;
    private boolean isAnnotationValue;
    private String beginTimeRef;
    private String endTimeRef;
    private long maxTime;
    private ArrayList<AnnexMediaDescriptor> mediaDescriptors;
    private HashMap<String, String> parentTierHash;

    public AnnexEAFHandler(AnnexTranscription transcription) {
        this.tiers = transcription.getTiers();
        this.mediaDescriptors = transcription.getMediaDescriptors();
        this.timeSlots = new HashMap(12000, 0.5f);
        this.beginTimeHash = new HashMap(6000, 0.5f);
        this.endTimeHash = new HashMap(6000, 0.5f);
        this.refHash = new HashMap(16000, 0.5f);
        this.refererHash = new HashMap(400, 0.75f);
        this.prevHash = new HashMap(10000, 0.5f);
        this.idToAnn = new HashMap(12000, 0.5f);
        this.maxTime = -1L;
        this.parentTierHash = new HashMap(30, 0.5f);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.isAnnotationValue = false;
        if (qName.equals("TIME_SLOT")) {
            String id = attrs.getValue("TIME_SLOT_ID");
            String valueString = attrs.getValue("TIME_VALUE");
            if (valueString != null && valueString.length() > 0) {
                try {
                    long value = Long.parseLong(valueString);
                    if (value > this.maxTime) {
                        this.maxTime = value;
                    }
                    this.timeSlots.put(id, value);
                }
                catch (NumberFormatException nfe) {
                    this.timeSlots.put(id, null);
                }
            } else {
                this.timeSlots.put(id, null);
            }
        } else {
            if (qName.equals("ANNOTATION")) {
                return;
            }
            if (qName.equals("ANNOTATION_VALUE")) {
                this.isAnnotationValue = true;
                this.textBuffer = new StringBuilder();
            } else if (qName.equals("ALIGNABLE_ANNOTATION")) {
                this.id = attrs.getValue("ANNOTATION_ID");
                this.annotation = new AnnexAnnotation(null, -42L, -42L, true, this.id);
                this.tier.annotations.add(this.annotation);
                this.beginTimeRef = attrs.getValue("TIME_SLOT_REF1");
                if (this.timeSlots.get(this.beginTimeRef) == null) {
                    this.annotation.interpolatedTime = true;
                }
                this.endTimeRef = attrs.getValue("TIME_SLOT_REF2");
                if (this.timeSlots.get(this.endTimeRef) == null) {
                    this.annotation.interpolatedTime = true;
                }
                this.beginTimeHash.put(this.id, this.beginTimeRef);
                this.endTimeHash.put(this.id, this.endTimeRef);
                this.refHash.put(this.id, null);
                this.idToAnn.put(this.id, this.annotation);
            } else if (qName.equals("REF_ANNOTATION")) {
                ArrayList<Object> referers;
                this.id = attrs.getValue("ANNOTATION_ID");
                this.annotation = new AnnexAnnotation(null, -42L, -42L, false, this.id);
                this.tier.annotations.add(this.annotation);
                String annotationRef = attrs.getValue("ANNOTATION_REF");
                this.refHash.put(this.id, annotationRef);
                if (!this.refererHash.containsKey(annotationRef)) {
                    referers = new ArrayList();
                    this.refererHash.put(annotationRef, referers);
                }
                referers = this.refererHash.get(annotationRef);
                referers.add(this.id);
                String previousRef = attrs.getValue("PREVIOUS_ANNOTATION");
                if (previousRef != null) {
                    this.prevHash.put(this.id, previousRef);
                }
                this.idToAnn.put(this.id, this.annotation);
            } else if (qName.equals("TIER")) {
                this.tier = new AnnexTier(attrs.getValue("TIER_ID"), attrs.getValue("LINGUISTIC_TYPE_REF"));
                this.tier.defaultLocale = attrs.getValue("DEFAULT_LOCALE");
                this.tier.annotator = attrs.getValue("ANNOTATOR");
                this.tier.participant = attrs.getValue("PARTICIPANT");
                if (this.tier.participant == null) {
                    this.tier.participant = "unknown";
                }
                this.tiers.add(this.tier);
                this.parentTierHash.put(this.tier.name, attrs.getValue("PARENT_REF"));
            } else if (qName.equals("HEADER")) {
                int lastLs;
                String mediaFileName = attrs.getValue("MEDIA_FILE");
                if (mediaFileName == null || mediaFileName.length() < 2) {
                    return;
                }
                int lastRs = mediaFileName.lastIndexOf(47);
                int pos = lastRs > (lastLs = mediaFileName.lastIndexOf(92)) ? lastRs : lastLs;
                mediaFileName = mediaFileName.substring(pos + 1);
                AnnexMediaDescriptor mediaDescriptor = new AnnexMediaDescriptor();
                mediaDescriptor.fileName = mediaFileName;
                mediaDescriptor.mimeType = DataUtil.getMediaTypeFromName(mediaFileName);
                this.mediaDescriptors.add(mediaDescriptor);
                if (mediaDescriptor.mimeType.indexOf("audio") < 0) {
                    pos = mediaFileName.lastIndexOf(46);
                    String wavFileName = mediaFileName.subSequence(0, pos + 1) + "wav";
                    mediaDescriptor = new AnnexMediaDescriptor();
                    mediaDescriptor.fileName = wavFileName;
                    mediaDescriptor.extractedFrom = mediaFileName;
                    mediaDescriptor.mimeType = "audio/x-wav";
                    this.mediaDescriptors.add(mediaDescriptor);
                }
            } else if (qName.equals("MEDIA_DESCRIPTOR")) {
                int lastLs;
                String mediaFileName = attrs.getValue("MEDIA_URL");
                String extractedFileName = attrs.getValue("EXTRACTED_FROM");
                String offset = attrs.getValue("TIME_ORIGIN");
                if (mediaFileName == null) {
                    return;
                }
                AnnexMediaDescriptor mediaDescriptor = new AnnexMediaDescriptor();
                int lastRs = mediaFileName.lastIndexOf(47);
                int pos = lastRs > (lastLs = mediaFileName.lastIndexOf(92)) ? lastRs : lastLs;
                mediaDescriptor.fileName = mediaFileName = mediaFileName.substring(pos + 1);
                mediaDescriptor.mimeType = DataUtil.getMediaTypeFromName(mediaFileName);
                if (extractedFileName != null) {
                    lastRs = extractedFileName.lastIndexOf(47);
                    pos = lastRs > (lastLs = extractedFileName.lastIndexOf(92)) ? lastRs : lastLs;
                    mediaDescriptor.extractedFrom = extractedFileName = extractedFileName.substring(pos + 1);
                }
                if (offset != null) {
                    mediaDescriptor.offset = Long.parseLong(offset);
                }
                this.mediaDescriptors.add(mediaDescriptor);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("ANNOTATION_VALUE")) {
            this.annotation.value = this.textBuffer.toString();
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.isAnnotationValue) {
            this.textBuffer.append(buf, offset, len);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ArrayList<String> tierTimeSlots = new ArrayList<String>();
        block0: for (int i = 0; i < this.tiers.size(); ++i) {
            String timeRef;
            AnnexAnnotation annotation;
            int j;
            AnnexTier tier = this.tiers.get(i);
            ArrayList<AnnexAnnotation> annotations = tier.annotations;
            tierTimeSlots.clear();
            boolean allAligned = true;
            for (j = 0; j < annotations.size(); ++j) {
                annotation = annotations.get(j);
                String id = this.getAlignedAnnotationID(annotation.id);
                timeRef = this.beginTimeHash.get(id);
                tierTimeSlots.add(timeRef);
                if (this.timeSlots.get(timeRef) == null) {
                    allAligned = false;
                    annotation.interpolatedTime = true;
                }
                timeRef = this.endTimeHash.get(id);
                tierTimeSlots.add(timeRef);
                if (this.timeSlots.get(timeRef) != null) continue;
                allAligned = false;
                annotation.interpolatedTime = true;
            }
            if (!allAligned) {
                long previousValidTime = 0L;
                for (int j2 = 0; j2 < tierTimeSlots.size(); ++j2) {
                    Long t = this.timeSlots.get(tierTimeSlots.get(j2));
                    if (t == null) {
                        int steps = 0;
                        Long nextT = null;
                        for (int k = j2 + 1; k < tierTimeSlots.size(); ++k) {
                            ++steps;
                            nextT = this.timeSlots.get(tierTimeSlots.get(k));
                            if (nextT != null) break;
                        }
                        long timeStep = ((nextT == null ? this.maxTime : nextT) - previousValidTime) / (long)steps;
                        this.timeSlots.put((String)tierTimeSlots.get(j2), previousValidTime += timeStep);
                        continue;
                    }
                    previousValidTime = t;
                }
            }
            for (j = 0; j < annotations.size(); ++j) {
                annotation = annotations.get(j);
                String id = this.getAlignedAnnotationID(annotation.id);
                timeRef = this.beginTimeHash.get(id);
                annotation.beginTime = this.timeSlots.get(timeRef);
                timeRef = this.endTimeHash.get(id);
                annotation.endTime = this.timeSlots.get(timeRef);
                String refId = this.refHash.get(annotation.id);
                annotation.refAnnotation = this.idToAnn.get(refId);
            }
            String parentName = this.parentTierHash.get(tier.name);
            for (int j3 = 0; j3 < this.tiers.size(); ++j3) {
                AnnexTier parent = this.tiers.get(j3);
                if (!parent.name.equals(parentName)) continue;
                tier.parentTier = parent;
                continue block0;
            }
        }
        for (String id : this.refererHash.keySet()) {
            AnnexAnnotation ann = this.idToAnn.get(id);
            ArrayList<String> referers = this.refererHash.get(id);
            if (!ann.isTimeAligned || referers == null || referers.size() <= 0) continue;
            this.alignReferersFor(id, this.refererHash);
        }
    }

    private void alignReferersFor(String id, HashMap<String, ArrayList<String>> refererHash) {
        ArrayList<String> referers = refererHash.get(id);
        AnnexAnnotation ann = this.idToAnn.get(id);
        long duration = ann.endTime - ann.beginTime;
        for (int i = 0; i < referers.size(); ++i) {
            int j;
            if (this.prevHash.get(referers.get(i)) != null) continue;
            for (j = i + 1; j < referers.size() && this.prevHash.get(referers.get(j)) != null; ++j) {
            }
            long step = duration / (long)(j - i);
            for (int k = i; k < j; ++k) {
                AnnexAnnotation refAnn = this.idToAnn.get(referers.get(k));
                refAnn.beginTime = ann.beginTime + (long)(k - i) * step;
                refAnn.endTime = refAnn.beginTime + step;
            }
            AnnexAnnotation refAnn = this.idToAnn.get(referers.get(j - 1));
            refAnn.endTime = ann.endTime;
            for (int k = i; k < j; ++k) {
                ArrayList<String> refReferers = refererHash.get(referers.get(k));
                if (refReferers == null || refReferers.size() <= 0) continue;
                this.alignReferersFor(referers.get(k), refererHash);
            }
            i = j - 1;
        }
    }

    private String getAlignedAnnotationID(String annotationID) {
        String id = annotationID;
        while (this.refHash.get(id) != null) {
            id = this.refHash.get(id);
        }
        return id;
    }
}

