/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.util.ArrayList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchLayer {
    private boolean isEmpty = true;
    private ArrayList<String> patterns = new ArrayList();
    private ArrayList<Boolean> patternsNOTMode = new ArrayList();
    private ArrayList<Pattern> regExpPatterns = new ArrayList();
    private ArrayList<String[]> modes = new ArrayList();
    private ArrayList<String> innerConstraints = new ArrayList();
    private ArrayList<String> outerConstraints;
    private ArrayList<String> tierConstraints = new ArrayList();
    private ArrayList<int[]> hitAnnIdsForPattern;
    private ArrayList<int[]> hitNumbersForPattern;
    private int[] hitFileIds;
    private String tierIdsInLayerDomain = "";

    public SearchLayer() {
        this.outerConstraints = new ArrayList();
        this.hitAnnIdsForPattern = new ArrayList();
        this.hitNumbersForPattern = new ArrayList();
    }

    public void addPattern(String pattern, String mode, String innerConstraint, String outerConstraint) {
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(pattern)) {
            notMode = !notMode;
            pattern = SearchLayer.stripNOTPattern(pattern);
        }
        this.patterns.add(pattern);
        this.patternsNOTMode.add(notMode);
        if (pattern.length() > 0) {
            this.isEmpty = false;
            String[] queryModes = mode.split("xxxMODE_SPLITTERxxx");
            this.modes.add(queryModes);
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[1].equals(" case sensitive")) {
                    this.regExpPatterns.add(Pattern.compile(pattern));
                } else {
                    this.regExpPatterns.add(Pattern.compile(pattern, 2));
                }
            } else {
                this.regExpPatterns.add(null);
            }
            this.hitAnnIdsForPattern.add(new int[100000]);
            this.hitNumbersForPattern.add(new int[100000]);
            if (this.hitFileIds == null) {
                this.hitFileIds = new int[100000];
            }
        } else {
            this.modes.add(null);
            this.regExpPatterns.add(null);
            this.hitAnnIdsForPattern.add(null);
            this.hitNumbersForPattern.add(null);
        }
        this.innerConstraints.add(innerConstraint);
        this.outerConstraints.add(outerConstraint);
    }

    public void addTierConstraint(String constraint) {
        this.tierConstraints.add(constraint);
    }

    public int getNumberOfPatterns() {
        return this.patterns.size();
    }

    public String getPattern(int i) {
        return this.patterns.get(i);
    }

    public boolean getPatternNOTMode(int i) {
        return this.patternsNOTMode.get(i);
    }

    public Pattern getRegExpPattern(int i) {
        return this.regExpPatterns.get(i);
    }

    public String[] getMode(int i) {
        return this.modes.get(i);
    }

    public String getInnerConstraint(int i) {
        return this.innerConstraints.get(i);
    }

    public ArrayList<String> getTierConstraints() {
        return this.tierConstraints;
    }

    public void setTierIdsInLayerDomain(String tierIds) {
        this.tierIdsInLayerDomain = tierIds;
    }

    public String getTierIdsInLayerDomain() {
        return this.tierIdsInLayerDomain;
    }

    public String getOuterConstraint(int i) {
        return this.outerConstraints.get(i);
    }

    public int[] getHitAnnIdsForPattern(int i) {
        return this.hitAnnIdsForPattern.get(i);
    }

    public int[] getHitNumberForPattern(int i) {
        return this.hitNumbersForPattern.get(i);
    }

    public int[] getHitFileIds() {
        return this.hitFileIds;
    }

    public int getIndexOfFirstNonEmptyPattern() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            if (this.patterns.get(i).length() <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public static boolean isNOTPattern(String pattern) {
        return pattern.trim().startsWith("NOT(") && pattern.trim().endsWith(")");
    }

    public static String stripNOTPattern(String pattern) {
        if (!SearchLayer.isNOTPattern(pattern)) {
            return pattern;
        }
        return pattern.trim().substring(4, pattern.length() - 1).trim();
    }

    public String display() {
        StringBuilder dump = new StringBuilder("\tPatterns and inner constraints: ");
        if (this.isEmpty()) {
            dump.append("[EMPTY LAYER]");
        } else {
            dump.append("First non-empty pattern: ").append(this.getIndexOfFirstNonEmptyPattern());
        }
        dump.append("\r\n");
        for (int j = 0; j < this.getNumberOfPatterns(); ++j) {
            if (this.patterns.get(j).length() > 0) {
                String mtarget = this.getMode(j)[0];
                String mcase = this.getMode(j)[1];
                String mmatch = this.getMode(j)[2];
                boolean not = this.getPatternNOTMode(j);
                dump.append("\t\t#").append(j).append(" |");
                dump.append(not ? " [NOT] " : "").append("" + this.patterns.get(j) + "| as ");
                dump.append(mtarget).append(" ").append(mcase).append(" ").append(mmatch);
                dump.append("\r\n");
                dump.append("\t\t\tinner: " + this.getInnerConstraint(j)).append("\r\n");
                dump.append("\t\t\touter: " + this.getOuterConstraint(j)).append("\r\n");
                continue;
            }
            dump.append("\t\t#").append(j).append(" |[EMPTY]|").append("\r\n");
        }
        ArrayList<String> tc = this.getTierConstraints();
        if (tc.size() > 0) {
            dump.append("\tTier constraints: ").append("\r\n");
        }
        for (int j = 0; j < tc.size(); ++j) {
            dump.append("\t\t").append(tc.get(j)).append("\r\n");
        }
        dump.append("\tTierIdsInLayerDomain: ").append(this.getTierIdsInLayerDomain()).append("\r\n");
        return dump.toString();
    }
}

