/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.mpi.annex.data.AnnexParser;
import nl.mpi.annex.search.SearchClient;
import nl.mpi.annex.util.AnnexUtil;
import nl.mpi.annex.util.CountHash;
import nl.mpi.corpusstructure.CorpusNode;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TierCollection
implements Serializable {
    private static Logger _logger = Logger.getLogger((String)"ANNEX.TierCollection");
    private String _sqlFilterClause = null;
    private ArrayList<String> _typeInfo = new ArrayList();
    private ArrayList<HashSet<String>> _typeNodes = new ArrayList();
    private ArrayList<CountHash<String>> _typeTypes = new ArrayList();
    private ArrayList<CountHash<String>> _typeNames = new ArrayList();
    private ArrayList<CountHash<String>> _typeParticipants = new ArrayList();
    private ArrayList<CountHash<String>> _typeAnnotators = new ArrayList();

    public TierCollection(SearchClient searchClient, String userId, ArrayList<String> topNodes) {
        this._sqlFilterClause = TierCollection.getDomainSQL(topNodes);
        _logger.debug((Object)("getDomainSQL(" + topNodes + ") = " + this._sqlFilterClause));
        HashSet<String> domainNodes = TierCollection.getUserDomain(topNodes, userId);
        if (domainNodes.isEmpty()) {
            this._sqlFilterClause = "( " + this._sqlFilterClause + " ) AND FALSE";
        }
        for (int i = 0; i < AnnexParser.getFileTypeCount(); ++i) {
            HashSet<String> oneTypeNodes = new HashSet<String>();
            CountHash<String> tierNames = new CountHash<String>();
            CountHash<String> tierTypes = new CountHash<String>();
            CountHash<String> participants = new CountHash<String>();
            CountHash<String> annotators = new CountHash<String>();
            int sumAnnotations = 0;
            try {
                PreparedStatement ps = searchClient.getPreparedStatement("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations FROM search.tiers WHERE transcription_type = " + i + " AND " + this._sqlFilterClause);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String annotator;
                    String participant;
                    String tierType;
                    String tierName;
                    String nodeId = rs.getString(1);
                    if (!domainNodes.contains(nodeId)) continue;
                    if (!oneTypeNodes.contains(nodeId)) {
                        oneTypeNodes.add(nodeId);
                    }
                    if ((tierName = rs.getString(2)) != null && tierName.length() > 0) {
                        tierNames.put(tierName, 1);
                    }
                    if ((tierType = rs.getString(3)) != null && tierType.length() > 0) {
                        tierTypes.put(tierType, 1);
                    }
                    if ((participant = rs.getString(4)) != null && participant.length() > 0) {
                        participants.put(participant, 1);
                    }
                    if ((annotator = rs.getString(5)) != null && annotator.length() > 0) {
                        annotators.put(annotator, 1);
                    }
                    sumAnnotations += rs.getInt(6);
                }
                ps.close();
                rs.close();
            }
            catch (RuntimeException re) {
                _logger.error((Object)("TierCollection: RuntimeException: " + re), (Throwable)re);
            }
            catch (SQLException sqle) {
                _logger.error((Object)("TierCollection: SQLException: " + sqle), (Throwable)sqle);
            }
            int nNames = tierNames.size();
            int nTypes = tierTypes.size();
            int nParticipants = participants.size();
            int nAnnotators = annotators.size();
            if (sumAnnotations + nNames + nTypes + nParticipants + nAnnotators > 0) {
                this._typeInfo.add("" + oneTypeNodes.size() + " nodes, " + sumAnnotations + " annotations, " + nParticipants + " participants, " + nNames + " tier names, " + nTypes + " tier types, " + nAnnotators + " tier annotators");
            } else {
                this._typeInfo.add("No data!");
            }
            if (nNames > 400) {
                tierNames.clear();
            }
            if (nTypes > 400) {
                tierTypes.clear();
            }
            if (nParticipants > 200) {
                participants.clear();
            }
            if (nAnnotators > 100) {
                annotators.clear();
            }
            this._typeNodes.add(oneTypeNodes);
            this._typeNames.add(tierNames);
            this._typeTypes.add(tierTypes);
            this._typeParticipants.add(participants);
            this._typeAnnotators.add(annotators);
        }
    }

    public String getRawSQLFilter(List<Integer> fileTypes) {
        if (fileTypes == null) {
            return this._sqlFilterClause;
        }
        if (fileTypes.size() == 1) {
            return this._sqlFilterClause + " AND transcription_type = " + fileTypes.get(0);
        }
        StringBuilder typeFilterClause = new StringBuilder(" AND transcription_type IN ( ");
        for (int i = 0; i < fileTypes.size(); ++i) {
            if (i > 0) {
                typeFilterClause.append(", ");
            }
            typeFilterClause.append("" + fileTypes.get(i));
        }
        typeFilterClause.append(" )");
        return this._sqlFilterClause + typeFilterClause.toString();
    }

    public String getInfoForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeInfo.get(type);
    }

    public HashSet<String> getNodesForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeNodes.get(type);
    }

    public int getNodeCountForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return 0;
        }
        return this._typeNodes.get(type).size();
    }

    public CountHash<String> getTierNamesForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeNames.get(type);
    }

    public CountHash<String> getTierTypesForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeTypes.get(type);
    }

    public CountHash<String> getParticipantsForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeParticipants.get(type);
    }

    public CountHash<String> getAnnotatorsForType(int type) {
        if (type < 0 || type >= AnnexParser.getFileTypeCount()) {
            return null;
        }
        return this._typeAnnotators.get(type);
    }

    public static HashSet<String> getUserDomain(ArrayList<String> topNodes, String userId) {
        if (userId == null || "anonymous".equals(userId) || userId.trim().length() == 0) {
            userId = "everybody";
        }
        HashSet<String> nodeIds = new HashSet<String>();
        CorpusStructureDB csdb = AnnexUtil.getCorpusStructureDB();
        for (int i = 0; i < topNodes.size(); ++i) {
            String nodeId = topNodes.get(i);
            try {
                if (csdb.getNode(nodeId).getNodeType() == 8) {
                    if (!AnnexUtil.hasAccessTo(userId, nodeId)) continue;
                    nodeIds.add(nodeId);
                    continue;
                }
                String[] types = SearchClient.getSearchableFormats();
                String[] desc = csdb.getDescendants(nodeId, 8, types, userId, false);
                nodeIds.addAll(Arrays.asList(desc));
                continue;
            }
            catch (UnknownNodeException une) {
                _logger.warn((Object)("Skipped bad (unlinked, nameless or non-existing) top node: " + nodeId));
                continue;
            }
            catch (RuntimeException re) {
                _logger.warn((Object)("Skipped top node with bad node ID: " + nodeId));
            }
        }
        return nodeIds;
    }

    protected static String getDomainSQL(ArrayList<String> topNodes) {
        StringBuilder sqlnodes = new StringBuilder();
        StringBuilder sqlpaths = new StringBuilder();
        CorpusStructureDB csdb = AnnexUtil.getCorpusStructureDB();
        for (int i = 0; i < topNodes.size(); ++i) {
            String nodeId = topNodes.get(i);
            int nodeType = -1;
            CorpusNode cn = null;
            try {
                cn = csdb.getCorpusNode(nodeId);
                nodeType = cn.getNodeType();
            }
            catch (UnknownNodeException une) {
                _logger.warn((Object)("Skipped unlinked top node: " + nodeId));
                continue;
            }
            catch (RuntimeException re) {
                _logger.warn((Object)("Skipped top node with invalid id: " + nodeId));
                continue;
            }
            if (nodeType == 8) {
                if (sqlnodes.length() == 0) {
                    sqlnodes.append("node_id IN ( ");
                } else {
                    sqlnodes.append(", ");
                }
                sqlnodes.append('\'').append(nodeId).append('\'');
                continue;
            }
            if (nodeType == 1) {
                if (sqlpaths.length() > 0) {
                    sqlpaths.append(" OR ");
                }
                sqlpaths.append("vpath = '");
                sqlpaths.append(cn.getCanonicalVPath());
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append('\'');
                continue;
            }
            if (nodeType == 2) {
                if (sqlpaths.length() > 0) {
                    sqlpaths.append(" OR ");
                }
                sqlpaths.append("vpath BETWEEN '");
                sqlpaths.append(cn.getCanonicalVPath());
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append("' AND '");
                sqlpaths.append(cn.getCanonicalVPath());
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append("/ZZZ'");
                continue;
            }
            _logger.warn((Object)("Ignored type " + nodeType + " element in top node list: " + nodeId));
        }
        String pathPart = null;
        if (sqlpaths.length() > 0) {
            pathPart = "node_id in ( SELECT node_id FROM search.vpaths WHERE " + sqlpaths.toString() + " )";
            if (sqlnodes.length() == 0) {
                return pathPart;
            }
        } else if (sqlnodes.length() == 0) {
            return "FALSE";
        }
        sqlnodes.append(" ) ");
        if (pathPart != null) {
            return sqlnodes.toString() + " OR " + pathPart;
        }
        return sqlnodes.toString();
    }
}

