/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.search;

import java.text.DecimalFormat;
import nl.mpi.annex.search.FrequencyInfo;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.search.SearchStatistics;
import nl.mpi.annex.util.AnnexUtil;
import nl.mpi.annex.util.CountHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlCsvHelpers {
    private static final String delimiter = ";";

    public static String getInfoAsTabDelimited(FrequencyInfo freqInfo, boolean includeHeader, SearchStatistics stats) {
        StringBuilder result = new StringBuilder("");
        if (includeHeader) {
            result.append("\"Annotation\"").append(delimiter).append("\"Percentage\"").append(delimiter).append("\"Count\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"\n");
        }
        float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)stats.nAnnotationsWithHit;
        String fmt = "##0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        String percentageString = df.format(percentage);
        result.append('\"').append(freqInfo.annotation.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
        result.append(percentageString).append(delimiter);
        result.append(freqInfo.numberOfHits).append(delimiter);
        result.append(freqInfo.hitPositionInAnnotation).append(delimiter);
        result.append(freqInfo.hitLength).append("\n");
        return result.toString();
    }

    public static String getFreqInfoAsXML(FrequencyInfo info) {
        StringBuilder xml = new StringBuilder("<hit>");
        xml.ensureCapacity(128);
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("annotation", info.annotation));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("occurences", info.nOccurences));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("numberOfHits", info.numberOfHits));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("hitPositionInAnnotation", info.hitPositionInAnnotation));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("hitLength", info.hitLength));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("annId", info.annId));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("fileIndex", info.fileIndex));
        return xml.append("</hit>\n").toString();
    }

    private static String getURLAsString(String nodeId) {
        return AnnexUtil.getURLFor(nodeId).toString();
    }

    public static String getHitAsTabDelimited(SearchHit hit, boolean includeHeader) {
        StringBuilder result = new StringBuilder("");
        if (hit.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
            String part;
            int n;
            int k;
            StringBuilder headerString = new StringBuilder("");
            String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            String[] layerParts = null;
            if (includeHeader) {
                for (k = 1; k < layerStrings.length; ++k) {
                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                    for (n = 1; n < layerParts.length; ++n) {
                        part = layerParts[n];
                        if (part.charAt(1) == '|') continue;
                        headerString.append("\"Annotation" + k + "-" + n + "\"").append(delimiter).append("\"Position\"").append(delimiter).append("\"Begin Time\"").append(delimiter).append("\"End Time\"").append(delimiter);
                    }
                }
                headerString.append("\"TranscriptionName\"").append(delimiter);
                headerString.append("\"TranscriptionURL\"").append("\n");
                result.append(headerString.toString());
            }
            layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            for (k = 1; k < layerStrings.length; ++k) {
                layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                for (n = 1; n < layerParts.length; ++n) {
                    part = layerParts[n];
                    if (part.charAt(1) == '|') continue;
                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                    int position = Integer.parseInt(patternParts[1]);
                    long beginTime = Long.parseLong(patternParts[2]);
                    long endTime = Long.parseLong(patternParts[3]);
                    result.append(annotation).append(delimiter);
                    result.append(position).append(delimiter);
                    result.append(beginTime).append(delimiter);
                    result.append(endTime).append(delimiter);
                }
            }
            result.append('\"').append(hit.transcriptionName.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            result.append('\"').append(XmlCsvHelpers.getURLAsString(hit.transcriptionNodeId).replaceAll("\"", "\"\"")).append('\"').append("\n");
        } else {
            int k;
            if (includeHeader) {
                result.append("\"Annotation\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"").append(delimiter).append("\"HitNumberInAnnotation\"").append(delimiter).append("\"AnnotationBeginTime\"").append(delimiter).append("\"AnnotationEndTime\"").append(delimiter).append("\"HitPositionInTier\"").append(delimiter).append("\"TierName\"").append(delimiter).append("\"TierType\"").append(delimiter).append("\"TierParticipant\"").append(delimiter).append("\"TierAnnotator\"").append(delimiter).append("\"LeftContext\"").append(delimiter).append("\"RightContext\"").append(delimiter).append("\"TranscriptionName\"").append(delimiter).append("\"TranscriptionURL\"").append("\n");
            }
            result.append('\"').append(hit.annotation.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            result.append(hit.hitPositionInAnnotation + 1).append(delimiter);
            result.append(hit.hitLength).append(delimiter);
            result.append(hit.hitNumberInAnnotation).append(delimiter);
            result.append(hit.beginTime).append(delimiter);
            result.append(hit.endTime).append(delimiter);
            result.append(hit.positionInTier).append(delimiter);
            result.append('\"').append(hit.tierName.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            result.append('\"').append(hit.tierType.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            if (hit.participant == null) {
                hit.participant = "";
            }
            result.append('\"').append(hit.participant.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            if (hit.annotator == null) {
                hit.annotator = "";
            }
            result.append('\"').append(hit.annotator.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            if (hit.leftContext.size() > 0) {
                String leftContext = hit.leftContext.get(0);
                for (k = 1; k < hit.leftContext.size(); ++k) {
                    leftContext = hit.leftContext.get(k) + "  " + leftContext;
                }
                result.append('\"').append(leftContext.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            } else {
                result.append("\"\"").append(delimiter);
            }
            if (hit.rightContext.size() > 0) {
                StringBuilder rightContext = new StringBuilder(hit.rightContext.get(0));
                for (k = 1; k < hit.rightContext.size(); ++k) {
                    rightContext.append("  ");
                    rightContext.append(hit.rightContext.get(k));
                }
                result.append('\"').append(rightContext.toString().replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            } else {
                result.append("\"\"").append(delimiter);
            }
            result.append('\"').append(hit.transcriptionName.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
            result.append('\"').append(XmlCsvHelpers.getURLAsString(hit.transcriptionNodeId)).append('\"').append("\n");
        }
        return result.toString();
    }

    public static String getHitAsXML(SearchHit hit) {
        int i;
        StringBuilder xml = new StringBuilder("\n<hit>");
        xml.ensureCapacity(256);
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("annotation", hit.annotation));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("aligned", hit.aligned));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("beginTime", hit.beginTime));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("endTime", hit.endTime));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("hitLength", hit.hitLength));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("hitNumberInAnnotation", hit.hitNumberInAnnotation));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("hitPositionInAnnotation", hit.hitPositionInAnnotation));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("positionInTier", hit.positionInTier));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("tierName", hit.tierName));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("tierType", hit.tierType));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("participant", hit.participant));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("annotator", hit.participant));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("transcriptionNodeId", hit.transcriptionNodeId));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("transcriptionName", hit.transcriptionName));
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("transcriptionURL", XmlCsvHelpers.getURLAsString(hit.transcriptionNodeId)));
        String beforeString = "";
        for (i = 0; i < hit.leftContext.size(); ++i) {
            beforeString = hit.leftContext.get(i) + "  " + beforeString;
        }
        xml.append(XmlCsvHelpers.xmlifyNameValuePair("leftContext", beforeString.trim()));
        xml.append("<rightContext>");
        for (i = 0; i < hit.rightContext.size(); ++i) {
            xml.append(XmlCsvHelpers.escapeXML(hit.rightContext.get(i))).append(" ");
        }
        xml.append("</rightContext>\n");
        xml.append("</hit>\n");
        return xml.toString();
    }

    public static String encodeXMLArray(String resultTag, String[] items) {
        StringBuilder result = new StringBuilder("<" + resultTag + ">\n");
        result.ensureCapacity(128);
        for (int i = 0; i < items.length; ++i) {
            result.append('\t');
            result.append(XmlCsvHelpers.xmlifyNameValuePair("item", items[i]));
        }
        result.append("</" + resultTag + ">\n");
        return result.toString();
    }

    public static String encodeXMLArray(String resultTag, CountHash<String> items) {
        StringBuilder result = new StringBuilder("<" + resultTag + ">\n");
        result.ensureCapacity(128);
        for (String item : items.keySet()) {
            result.append('\t');
            result.append("<item count=\"" + items.getCount(item));
            result.append("\">");
            result.append(XmlCsvHelpers.escapeXML(item).replaceAll(" ", "&#32;"));
            result.append("</item>\n");
        }
        result.append("</" + resultTag + ">\n");
        return result.toString();
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\n", "").replaceAll("\r", "").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String xmlifyNameValuePair(String name, String value) {
        StringBuilder result = new StringBuilder(2 * name.length() + value.length() + 16);
        result.append('<').append(name).append('>');
        result.append(XmlCsvHelpers.escapeXML(value).replaceAll(" ", "&#32;"));
        result.append('<').append('/').append(name).append('>').append('\n');
        return result.toString();
    }

    public static String xmlifyNameValuePair(String name, long value) {
        return XmlCsvHelpers.xmlifyNameValuePair(name, Long.toString(value, 10));
    }

    public static String xmlifyNameValuePair(String name, boolean value) {
        return XmlCsvHelpers.xmlifyNameValuePair(name, Boolean.toString(value));
    }
}

