/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import nl.mpi.annex.swingsearch.SearchMediator;

public class ExportResultStatsDialog
extends JDialog
implements ActionListener {
    protected ResourceBundle bundle = null;
    protected SearchMediator mediator = null;
    protected JPanel panel;
    protected JCheckBox distinguishHitsCB;
    protected JCheckBox includeFileNameCB;
    protected JCheckBox includeFilePathCB;
    protected JLabel timeFormatLabel;
    protected JRadioButton msFormatRB;
    protected JRadioButton secMsFormatRB;
    protected TitledBorder titleBorder;
    protected JButton okButton;
    protected JPanel buttonPanel;
    public boolean distinguishHits = false;
    public boolean includeFileName = true;
    public boolean includeFilePath = false;
    public boolean msFormat = true;

    public ExportResultStatsDialog(Dialog owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, true);
        this.bundle = bundle;
        this.mediator = mediator;
        this.initComponents();
        this.updateLocale();
        this.postInit();
    }

    public ExportResultStatsDialog(Frame owner, ResourceBundle bundle, SearchMediator mediator) throws HeadlessException {
        super(owner, true);
        this.bundle = bundle;
        this.mediator = mediator;
        this.initComponents();
        this.updateLocale();
        this.postInit();
    }

    protected void initComponents() {
        if (this.mediator != null) {
            String val = this.mediator.getPersistent("MFSearchResult.ExportSeparateHitCount");
            if (val != null) {
                this.distinguishHits = Boolean.valueOf(val);
            }
            if ((val = this.mediator.getPersistent("MFSearchResult.ExportIncludeFileName")) != null) {
                this.includeFileName = Boolean.valueOf(val);
            }
            if ((val = this.mediator.getPersistent("MFSearchResult.ExportIncludeFilePath")) != null) {
                this.includeFilePath = Boolean.valueOf(val);
            }
            if ((val = this.mediator.getPersistent("MFSearchResult.ExportTimeFormat")) != null) {
                this.msFormat = val.equals("ms");
            }
        }
        this.titleBorder = new TitledBorder("");
        this.getContentPane().setLayout(new GridBagLayout());
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(this.titleBorder);
        Insets insets = new Insets(2, 6, 2, 6);
        this.distinguishHitsCB = new JCheckBox();
        this.distinguishHitsCB.setSelected(this.distinguishHits);
        this.includeFileNameCB = new JCheckBox();
        this.includeFileNameCB.setSelected(this.includeFileName);
        this.includeFilePathCB = new JCheckBox();
        this.includeFilePathCB.setSelected(this.includeFilePath);
        this.timeFormatLabel = new JLabel();
        this.msFormatRB = new JRadioButton();
        this.msFormatRB.setSelected(this.msFormat);
        this.secMsFormatRB = new JRadioButton();
        this.secMsFormatRB.setSelected(!this.msFormat);
        ButtonGroup group = new ButtonGroup();
        group.add(this.msFormatRB);
        group.add(this.secMsFormatRB);
        this.okButton = new JButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)this.distinguishHitsCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.includeFileNameCB, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)this.includeFilePathCB, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 6, 2, 6);
        this.panel.add((Component)this.timeFormatLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 26, 0, 6);
        this.panel.add((Component)this.msFormatRB, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.panel.add((Component)this.secMsFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panel, gridBagConstraints);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    protected void postInit() {
        this.pack();
        int w = 350;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
    }

    public void setHitDistinguishable(boolean distinguish) {
        if (this.distinguishHitsCB != null) {
            this.distinguishHitsCB.setEnabled(distinguish);
        }
    }

    public void updateLocale() {
        this.distinguishHitsCB.setText("Separate hit count per hit value");
        this.includeFileNameCB.setText("Include file name column");
        this.includeFilePathCB.setText("Include file path column");
        this.timeFormatLabel.setText("Time format:");
        this.msFormatRB.setText("ms");
        this.secMsFormatRB.setText("sec.ms");
        this.okButton.setText("OK");
        this.setTitle("Export options");
        this.titleBorder.setTitle("Export options");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.distinguishHitsCB != null) {
            this.distinguishHits = this.distinguishHitsCB.isEnabled() ? this.distinguishHitsCB.isSelected() : false;
        }
        this.includeFileName = this.includeFileNameCB.isSelected();
        this.includeFilePath = this.includeFilePathCB.isSelected();
        this.msFormat = this.msFormatRB.isSelected();
        if (this.mediator != null) {
            this.mediator.putPersistent("MFSearchResult.ExportSeparateHitCount", String.valueOf(this.distinguishHits));
            this.mediator.putPersistent("MFSearchResult.ExportIncludeFileName", String.valueOf(this.includeFileName));
            this.mediator.putPersistent("MFSearchResult.ExportIncludeFilePath", String.valueOf(this.includeFilePath));
            if (this.msFormat) {
                this.mediator.putPersistent("MFSearchResult.ExportTimeFormat", "ms");
            } else {
                this.mediator.putPersistent("MFSearchResult.ExportTimeFormat", "sec.ms");
            }
        }
        this.setVisible(false);
    }
}

