/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nl.mpi.annex.search.FrequencyInfo;
import nl.mpi.annex.search.SearchStatistics;
import nl.mpi.annex.swingsearch.SaverBasics;
import nl.mpi.annex.swingsearch.SearchMediator;

public class SaverFrequencyInfo
extends SaverBasics {
    private final File _saveFile;
    private final int _nToBeSaved;
    private final boolean _sortByFreq;

    public SaverFrequencyInfo(File file, int itemCount, SearchMediator sm, String queryId, boolean sortByFrequency) {
        super(sm, queryId);
        this._saveFile = file;
        this._nToBeSaved = itemCount;
        this._sortByFreq = sortByFrequency;
    }

    public void run() {
        String delimiter = "\t";
        int stepSize = 100;
        SearchStatistics searchStatistics = this.getMediator().getSearchStatistics(this.getQueryId());
        try {
            BufferedWriter out = SaverFrequencyInfo.writeSaveFile(this._saveFile);
            out.write("\"Annotation\"\t\"Percentage\"\t\"Count\"");
            out.newLine();
            out.newLine();
            for (int i = 0; i < this._nToBeSaved && this.getSaving(); i += 100) {
                ArrayList<FrequencyInfo> info = this.getMediator().getFrequencyInfo(i, i + 100 - 1, this.getQueryId(), this._sortByFreq);
                DecimalFormat df = new DecimalFormat("##0.00");
                for (int j = 0; j < info.size(); ++j) {
                    this.setProgress((float)(i + j) / (float)this._nToBeSaved);
                    FrequencyInfo freqInfo = (FrequencyInfo)info.get(j);
                    float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)searchStatistics.nAnnotationsWithHit;
                    out.write("\"" + freqInfo.annotation.replaceAll("\"", "\"\"") + "\"" + "\t");
                    out.write(df.format(percentage) + "\t");
                    out.write("" + freqInfo.numberOfHits + "");
                    out.newLine();
                }
                out.flush();
            }
            out.close();
            if (this.getSaving()) {
                JOptionPane.showMessageDialog(null, "Ready saving frequency info", "Save Frequency Info", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Save Frequency Info", 0);
        }
        this.cancel();
        this.setProgress(-1.0f);
    }
}

