/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.swingsearch.HitStats;
import nl.mpi.annex.swingsearch.SaverBasics;
import nl.mpi.annex.swingsearch.SearchMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaverHitStatistics
extends SaverBasics {
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private final String _sep = "\t";
    private final int _stepSize = 10;
    private final boolean _distinguishHitValues;
    private final boolean _includeFileName;
    private final boolean _includeFilePath;
    private final boolean _msFormat;
    private final File _saveFile;
    private final int _nToBeSaved;

    public SaverHitStatistics(File file, int hitCount, SearchMediator mediator, String queryId, boolean distinguishHits, boolean inclFileName, boolean inclFilePath, boolean unitMsec) {
        super(mediator, queryId);
        this._distinguishHitValues = distinguishHits;
        this._includeFileName = inclFileName;
        this._includeFilePath = inclFilePath;
        this._msFormat = unitMsec;
        this._saveFile = file;
        this._nToBeSaved = hitCount < 100000 ? hitCount : 100000;
    }

    @Override
    public void run() {
        try {
            BufferedWriter out = SaverHitStatistics.writeSaveFile(this._saveFile);
            if (this._includeFileName) {
                out.write("\"TranscriptionName\"\t");
            }
            if (this._distinguishHitValues) {
                out.write("\"Hit\"\t");
            }
            out.write("\"Occurrences\"\t\"TotalDuration\"\t\"MinDuration\"\t\"MaxDuration\"\t\"AverageDuration\"\t\"MedianDuration\"");
            if (this._includeFilePath) {
                out.write("\t\"TranscriptionPath\"");
            }
            out.newLine();
            out.newLine();
            ArrayList<SearchHit> hitsPerFile = new ArrayList<SearchHit>();
            ArrayList<String> filesWithHits = new ArrayList<String>();
            String curFilePath = null;
            for (int i = 0; i < this._nToBeSaved && this.getSaving(); i += 10) {
                ArrayList<SearchHit> hits = this.getMediator().getHitsFromDatabase(i, i + 10, 0, this.getQueryId());
                for (int j = 0; j < hits.size(); ++j) {
                    this.setProgress((float)(i + j) / (float)this._nToBeSaved);
                    SearchHit hit = (SearchHit)hits.get(j);
                    if (!hit.transcriptionName.equals(curFilePath)) {
                        this.writeHits(hitsPerFile, out);
                        hitsPerFile.clear();
                        hitsPerFile.add(hit);
                        filesWithHits.add(hit.transcriptionName);
                        curFilePath = hit.transcriptionName;
                    } else {
                        hitsPerFile.add(hit);
                    }
                    if (j != hits.size() - 1 || i + j != this._nToBeSaved - 1) continue;
                    this.writeHits(hitsPerFile, out);
                }
            }
            ArrayList<Object> allFiles = new ArrayList();
            if (this.getMediator().getDomainInfo() != null && this.getMediator().getDomainInfo().size() > 0) {
                allFiles = this.getMediator().getDomainInfo().get(0);
            }
            for (int i = 0; i < allFiles.size(); ++i) {
                String filepath = ((File)allFiles.get(i)).getAbsolutePath();
                if (filesWithHits.contains(filepath)) continue;
                if (this._includeFileName) {
                    out.write(SaverHitStatistics.nameFromPath(filepath) + "\t");
                }
                if (this._distinguishHitValues) {
                    out.write("\t");
                }
                out.write("0\t0\t");
                out.write("0\t0\t");
                out.write("0\t0");
                if (this._includeFilePath) {
                    out.write("\t" + filepath);
                }
                out.newLine();
            }
            out.flush();
            out.close();
            if (this.getSaving()) {
                JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hit Statistics", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Save Hit Statistics", 0);
        }
        this.cancel();
        this.setProgress(-1.0f);
    }

    private void writeHits(List<SearchHit> hitsPerFile, BufferedWriter out) throws IOException {
        String hitRepres;
        if (hitsPerFile == null || hitsPerFile.size() == 0) {
            return;
        }
        HashMap<String, HitStats> hitMap = new HashMap<String, HitStats>();
        String transcriptionName = null;
        long divFactor = this._msFormat ? 1L : 1000L;
        for (int m = 0; m < hitsPerFile.size(); ++m) {
            HitStats stats;
            SearchHit hit2 = hitsPerFile.get(m);
            if (transcriptionName == null) {
                transcriptionName = hit2.transcriptionName;
            }
            hitRepres = this._distinguishHitValues ? hit2.annotation : "";
            long b = hit2.beginTime;
            long e = hit2.endTime;
            if (hit2.tierType.equals("xxxCOMPLEX_QUERY_INDICATORxxx")) {
                String[] layerStrings = hit2.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                boolean[][] cellsInUse = this.getMediator().getMatrixUsage(this.getQueryId());
                boolean firstNonEmptyFound = false;
                for (int k = 1; k < layerStrings.length; ++k) {
                    String[] layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                    for (int n = 1; n < layerParts.length; ++n) {
                        boolean doProcess;
                        String part = layerParts[n];
                        boolean bl = cellsInUse != null ? cellsInUse[k - 1][n - 1] : (doProcess = part.charAt(1) != '|');
                        if (!doProcess) continue;
                        String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                        if (this._distinguishHitValues) {
                            String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                            hitRepres = !firstNonEmptyFound ? annotation : hitRepres + "|" + annotation;
                        }
                        if (!firstNonEmptyFound && patternParts.length > 3) {
                            b = Long.parseLong(patternParts[2]);
                            e = Long.parseLong(patternParts[3]);
                        }
                        firstNonEmptyFound = true;
                    }
                }
            }
            if ((stats = (HitStats)hitMap.get(hitRepres)) == null) {
                stats = new HitStats();
                hitMap.put(hitRepres, stats);
            }
            long duration = e - b;
            ++stats.numOcc;
            stats.minDur = duration < stats.minDur ? duration : stats.minDur;
            stats.maxDur = duration > stats.maxDur ? duration : stats.maxDur;
            stats.totalDur += duration;
            stats.firstOcc = b < stats.firstOcc ? b : stats.firstOcc;
            stats.durList.add(duration);
        }
        for (Map.Entry me : hitMap.entrySet()) {
            hitRepres = (String)me.getKey();
            HitStats stats = (HitStats)me.getValue();
            double averageDur = 0.0;
            if (stats.numOcc > 0) {
                averageDur = (double)stats.totalDur / (double)stats.numOcc;
            }
            Collections.sort(stats.durList);
            int numDurs = stats.durList.size();
            if (numDurs % 2 != 0) {
                stats.medianDur = stats.durList.get(numDurs / 2);
            } else {
                stats.medianDur = stats.durList.get(numDurs / 2);
                stats.medianDur += stats.durList.get(numDurs / 2 - 1).longValue();
                stats.medianDur /= 2L;
            }
            if (this._includeFileName) {
                out.write(SaverHitStatistics.nameFromPath(transcriptionName) + "\t");
            }
            if (this._distinguishHitValues) {
                out.write(hitRepres + "\t");
            }
            out.write(String.valueOf(stats.numOcc) + "\t");
            out.write(this.format2.format((double)stats.totalDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.minDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.maxDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.totalDur / (double)stats.numOcc / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.medianDur / (double)divFactor).replace(',', '.'));
            if (this._includeFilePath) {
                out.write("\t" + transcriptionName);
            }
            out.newLine();
        }
    }
}

