/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import nl.mpi.annex.search.Constants;
import nl.mpi.annex.search.FrequencyInfo;
import nl.mpi.annex.search.HSQLDBQuery;
import nl.mpi.annex.search.SearchHit;
import nl.mpi.annex.search.SearchStatistics;
import nl.mpi.annex.swingsearch.SearchApplication;
import nl.mpi.annex.swingsearch.SearchDomainPanel;
import nl.mpi.annex.swingsearch.SearchMediator;
import nl.mpi.annex.swingsearch.SearchPane;
import nl.mpi.annex.swingsearch.SearchResultPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchApplicationMediator
implements SearchMediator {
    private static int queryIdCounter;
    private HSQLDBQuery lastCreatedQuery;
    private SearchApplication application;
    private SearchPane searchPane;
    private HashMap<String, HSQLDBQuery> queryForId;
    private HashMap<String, SearchDomainPanel> domainPanelForId;
    private HashMap<String, SearchResultPanel> resultPanelForId;
    private HashMap<String, ArrayList<SearchHit>> bufferedHitsForQuery;
    private HashMap<String, boolean[][]> matrixForId;
    private ArrayList<ArrayList<File>> domainInfo;
    private ArrayList<File> initialDomain;
    private JPanel dummyPanel;

    public SearchApplicationMediator(SearchApplication application, ArrayList<File> initialDomain) {
        this.application = application;
        this.initialDomain = initialDomain;
        new Constants();
        this.queryForId = new HashMap();
        this.domainPanelForId = new HashMap();
        this.resultPanelForId = new HashMap();
        this.bufferedHitsForQuery = new HashMap();
        this.matrixForId = new HashMap(6);
        this.dummyPanel = new JPanel();
        this.domainInfo = new ArrayList();
    }

    @Override
    public void init() {
    }

    @Override
    public JComponent getSearchComponent() {
        if (this.searchPane == null) {
            this.searchPane = new SearchPane(this);
        }
        return this.searchPane;
    }

    @Override
    public String createQuery() {
        int queryId = queryIdCounter++;
        HSQLDBQuery query = new HSQLDBQuery(queryId);
        if (this.lastCreatedQuery == null) {
            query.setDomain(this.initialDomain);
            this.domainInfo.clear();
            this.domainInfo.add(new ArrayList<File>(query.getDomain()));
        } else {
            query.setDomain(this.lastCreatedQuery);
        }
        this.lastCreatedQuery = query;
        this.queryForId.put("" + queryId, query);
        this.bufferedHitsForQuery.put("" + queryId, new ArrayList());
        return "" + queryId;
    }

    @Override
    public void doQuery(String encodedQuery, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "A new query can not start while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList<SearchHit> bufferedHits = this.bufferedHitsForQuery.get(queryId);
        bufferedHits.clear();
        HSQLDBQuery query = this.queryForId.get(queryId);
        query.doQuery(encodedQuery);
    }

    @Override
    public void cancelQuery(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        query.cancelQuery();
    }

    @Override
    public void showInViewer(Object hit, String queryId) {
        if (hit == null) {
            return;
        }
        if (hit instanceof SearchHit) {
            this.showSearchHitInViewer((SearchHit)hit);
        } else if (hit instanceof FrequencyInfo) {
            this.showFrequencyHitInViewer((FrequencyInfo)hit, queryId);
        }
    }

    public void showSearchHitInViewer(SearchHit hit) {
        String filePath = hit.transcriptionName;
        String tierName = hit.tierName;
        long beginTime = hit.beginTime;
        long endTime = hit.endTime;
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    public void showFrequencyHitInViewer(FrequencyInfo freqInfo, String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        ArrayList<Object> parameters = query.getViewerParametersFor(freqInfo.annId, freqInfo.fileIndex);
        String filePath = (String)parameters.get(0);
        String tierName = (String)parameters.get(1);
        long beginTime = (Long)parameters.get(2);
        long endTime = (Long)parameters.get(3);
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    @Override
    public void showInCorpusStructure(Object hit, String queryId) {
    }

    @Override
    public SearchStatistics getSearchStatistics(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getSearchStatistics();
    }

    @Override
    public ArrayList<SearchHit> getHitsFromDatabase(int from, int to, int contextSize, String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getHits(from, to, contextSize);
    }

    @Override
    public List<SearchHit> getHits(int from, int to, int contextSize, String queryId) {
        ArrayList<SearchHit> bufferedHits = this.bufferedHitsForQuery.get(queryId);
        if (this.getSearchStatistics((String)queryId).nHits <= from) {
            return bufferedHits.subList(0, 0);
        }
        int lastBufferedIndex = bufferedHits.size();
        if (to > lastBufferedIndex) {
            ArrayList<SearchHit> hits = this.getHitsFromDatabase(lastBufferedIndex, to, contextSize, queryId);
            for (int i = 0; i < hits.size(); ++i) {
                bufferedHits.add(hits.get(i));
            }
        }
        to = to < bufferedHits.size() ? to : bufferedHits.size();
        return bufferedHits.subList(from, to);
    }

    @Override
    public ArrayList<FrequencyInfo> getFrequencyInfo(int from, int to, String queryId, boolean sortByFreq) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getFrequencyInfo(from, to, sortByFreq);
    }

    private boolean queryRunning() {
        boolean running = false;
        for (HSQLDBQuery query : this.queryForId.values()) {
            if (!query.isRunning()) continue;
            return true;
        }
        return running;
    }

    @Override
    public void addDomainPanel(String queryId, SearchDomainPanel panel) {
        this.domainPanelForId.put(queryId, panel);
    }

    @Override
    public void addResultPanel(String queryId, SearchResultPanel panel) {
        this.resultPanelForId.put(queryId, panel);
    }

    @Override
    public void setQueryDomain(String domainTypes, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "The domain can not be changed while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList<File> newDomain = this.application.getDomain();
        if (newDomain != null) {
            HSQLDBQuery query = this.queryForId.get(queryId);
            query.setDomain(newDomain);
            for (String otherQueryId : this.queryForId.keySet()) {
                HSQLDBQuery otherQuery = this.queryForId.get(otherQueryId);
                if (otherQuery != query) {
                    otherQuery.setDomain(query);
                    SearchDomainPanel domainPanel = this.domainPanelForId.get(otherQueryId);
                    domainPanel.newDomainFromOtherPanel();
                }
                SearchResultPanel resultPanel = this.resultPanelForId.get(otherQueryId);
                resultPanel.clear();
            }
            this.domainInfo.clear();
            this.domainInfo.add(new ArrayList<File>(query.getDomain()));
        }
    }

    @Override
    public void checkForDomainErrors(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        ArrayList<File> problemFiles = query.getProblemFiles();
        if (problemFiles.size() > 0) {
            StringBuilder errorFilePaths = new StringBuilder("");
            for (int i = 0; i < problemFiles.size(); ++i) {
                errorFilePaths.append(problemFiles.get(i).getAbsolutePath());
                errorFilePaths.append("\n");
            }
            String explanation = "The following files could not be parsed and are therefore removed from the search domain:\n";
            JOptionPane.showMessageDialog(null, explanation + errorFilePaths.toString(), "Not Searchable Files", 0);
        }
    }

    @Override
    public float getDomainInitializationProgress(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getDomainInitializationProgress();
    }

    @Override
    public int getDomainSize(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getDomain().size();
    }

    @Override
    public ArrayList<String> getSearchModes(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getSearchModes();
    }

    @Override
    public ArrayList<String> getParticipants(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getParticipants();
    }

    @Override
    public ArrayList<String> getAnnotators(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getAnnotators();
    }

    @Override
    public ArrayList<String> getTierNames(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getTierNames();
    }

    @Override
    public ArrayList<String> getTierTypes(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getTierTypes();
    }

    @Override
    public Color getBackgroundColor() {
        return this.dummyPanel.getBackground();
    }

    @Override
    public ArrayList<ArrayList<File>> getDomainInfo() {
        return this.domainInfo;
    }

    @Override
    public void putPersistent(String key, String value) {
        this.application.putPersistent(key, value);
    }

    @Override
    public String getPersistent(String key) {
        return this.application.getPersistent(key);
    }

    @Override
    public void deletePersistent(String key) {
        this.application.deletePersistent(key);
    }

    @Override
    public void setMatrixUsage(boolean[][] matrix, String queryId) {
        this.matrixForId.put(queryId, matrix);
    }

    @Override
    public boolean[][] getMatrixUsage(String queryId) {
        return this.matrixForId.get(queryId);
    }
}

