/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annex.swingsearch;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.mpi.annex.search.Constants;
import nl.mpi.annex.swingsearch.SearchListener;

public class SearchHistoryPanel
extends JPanel
implements ActionListener {
    private static final String SPLITTER = "qzbxv";
    private SearchListener searchListener;
    private ArrayList<String> history;
    private int currentItem;
    private JButton historyPrevious;
    private JLabel historyStatus;
    private JButton historyNext;
    private boolean persistentHistoryLoaded;

    public SearchHistoryPanel(SearchListener searchListener, Color backgroundColor) {
        this.searchListener = searchListener;
        this.history = new ArrayList();
        this.currentItem = 0;
        this.setBackground(backgroundColor);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        JLabel historyLabel = new JLabel("Query History:");
        historyLabel.setFont(Constants.bigBoldFont);
        this.add(historyLabel);
        this.add(Box.createHorizontalStrut(10));
        this.historyPrevious = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyPrevious.setBackground(backgroundColor);
        }
        this.historyPrevious.addActionListener(this);
        this.add(this.historyPrevious);
        this.add(Box.createHorizontalStrut(15));
        this.historyNext = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
            this.historyNext.setBackground(backgroundColor);
        }
        this.historyNext.addActionListener(this);
        this.add(this.historyNext);
        this.add(Box.createHorizontalStrut(15));
        this.historyStatus = new JLabel();
        this.historyStatus.setFont(Constants.normalFont);
        this.historyStatus.setText("Empty History");
        this.add(this.historyStatus);
        this.add(Box.createHorizontalGlue());
        this.setButtonsEnabled();
    }

    public void setHistory(String hist) {
        if (hist != null) {
            String[] his = hist.split(SPLITTER);
            this.history.clear();
            for (int i = 0; i < his.length; ++i) {
                this.history.add(his[i]);
            }
            this.currentItem = -1;
        }
        this.persistentHistoryLoaded = true;
        this.historyStatus.setText("Loaded " + this.history.size() + " Queries");
        this.setButtonsEnabled();
    }

    public void reset() {
        this.currentItem = -1;
        this.setButtonsEnabled();
    }

    public String getHistory() {
        if (this.history.size() == 0) {
            return "xxxNULL_STRINGxxx";
        }
        StringBuilder his = new StringBuilder("");
        for (int i = 0; i < this.history.size(); ++i) {
            if (i > 0) {
                his.append(SPLITTER);
            }
            his.append(this.history.get(i));
        }
        return his.toString();
    }

    public void remember(String item) {
        if (item.indexOf(SPLITTER) != -1) {
            return;
        }
        if (this.history.size() == 0 || !item.equals(this.history.get(0))) {
            this.history.add(0, item);
            this.currentItem = 0;
            if (this.history.size() >= 20) {
                this.history.remove(this.history.size() - 1);
            }
            this.historyStatus.setText("New Query");
            this.setButtonsEnabled();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.historyPrevious) {
            if (this.currentItem + 1 < this.history.size()) {
                ++this.currentItem;
                this.setButtonsEnabled();
                this.searchListener.setQuery(this.history.get(this.currentItem));
                this.historyStatus.setText("Query " + (this.history.size() - this.currentItem) + " / " + this.history.size());
            }
        } else if (source == this.historyNext && this.currentItem > 0) {
            --this.currentItem;
            this.setButtonsEnabled();
            this.searchListener.setQuery(this.history.get(this.currentItem));
            this.historyStatus.setText("Query " + (this.history.size() - this.currentItem) + " / " + this.history.size());
        }
    }

    private void setButtonsEnabled() {
        if (this.history.size() < 2) {
            this.historyPrevious.setEnabled(false);
            this.historyNext.setEnabled(false);
            return;
        }
        this.historyNext.setEnabled(this.currentItem > 0);
        this.historyPrevious.setEnabled(this.currentItem + 1 < this.history.size());
    }
}

