/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractMidiDevice;
import com.sun.jmfsound.imp.MidiOutDeviceProvider;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.midi.MidiMessage;
import com.sun.jmfsound.midi.MidiUnavailableException;
import com.sun.jmfsound.midi.Receiver;
import com.sun.jmfsound.midi.ShortMessage;
import com.sun.jmfsound.midi.SysexMessage;
import java.util.Vector;

class MidiOutDevice
extends AbstractMidiDevice {
    private Vector receivers = new Vector();

    MidiOutDevice(MidiOutDeviceProvider.MidiOutDeviceInfo info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MidiOutDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiOutDevice CONSTRUCTOR completed");
        }
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiOutDeviceProvider.MidiOutDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    synchronized void implClose() {
        int i = 0;
        while (i < this.receivers.size()) {
            ((Receiver)this.receivers.elementAt(i)).close();
            ++i;
        }
        this.receivers.removeAllElements();
        int oldId = this.id;
        this.id = 0;
        this.nClose(oldId);
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        MidiOutReceiver receiver = new MidiOutReceiver();
        this.receivers.addElement(receiver);
        return receiver;
    }

    private native int nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(int var1);

    private native void nSendShortMessage(int var1, int var2, int var3, int var4, long var5);

    class MidiOutReceiver
    implements Receiver {
        private boolean open = true;

        MidiOutReceiver() {
        }

        public void send(ShortMessage message, long timeStamp) {
            if (this.open) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, message.getStatus(), message.getData1(), message.getData2(), timeStamp);
            }
        }

        public void send(SysexMessage message, long timeStamp) {
        }

        public void send(MidiMessage message, long timeStamp) {
        }

        public void close() {
            MidiOutDevice.this.receivers.removeElement(this);
            this.open = false;
        }
    }
}

