/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractDataLine;
import com.sun.jmfsound.imp.AbstractLine;
import com.sun.jmfsound.imp.AbstractMixer;
import com.sun.jmfsound.imp.CircularBuffer;
import com.sun.jmfsound.imp.JSSecurity;
import com.sun.jmfsound.imp.JSSecurityManager;
import com.sun.jmfsound.imp.Platform;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.imp.SimpleInputDeviceProvider;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.Control;
import com.sun.jmfsound.sampled.DataLine;
import com.sun.jmfsound.sampled.Line;
import com.sun.jmfsound.sampled.LineUnavailableException;
import com.sun.jmfsound.sampled.Port;
import com.sun.jmfsound.sampled.TargetDataLine;
import java.util.Vector;

class SimpleInputDevice
extends AbstractMixer {
    private JSSecurity jsSecurity;
    private Port[] ports;
    private boolean implStarted = false;
    static /* synthetic */ Class class$com$sun$jmfsound$sampled$DataLine;
    static /* synthetic */ Class class$com$sun$jmfsound$sampled$TargetDataLine;
    static /* synthetic */ Class class$com$sun$jmfsound$imp$SimpleInputDevice$InputDeviceDataLine;

    SimpleInputDevice(SimpleInputDeviceProvider.InputDeviceInfo inputDeviceInfo) {
        super(null, new Control[0], null, -1, inputDeviceInfo, null, null);
        AudioFormat[] formatArray;
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: constructor");
        }
        this.jsSecurity = JSSecurityManager.getJSSecurity();
        Platform.initialize();
        this.nGetFormats(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), this.formats, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW, AudioFormat.Encoding.ALAW);
        Vector vector = this.formats;
        synchronized (vector) {
            formatArray = new AudioFormat[this.formats.size()];
            int i = 0;
            while (i < formatArray.length) {
                formatArray[i] = (AudioFormat)this.formats.elementAt(i);
                ++i;
            }
        }
        this.info = new DataLine.Info(class$com$sun$jmfsound$sampled$DataLine == null ? (class$com$sun$jmfsound$sampled$DataLine = SimpleInputDevice.class$("com.sun.jmfsound.sampled.DataLine")) : class$com$sun$jmfsound$sampled$DataLine, formatArray, 0, -1);
        int numPorts = this.nGetNumPorts();
        this.sourceLineInfo = new Port.Info[numPorts];
        this.ports = new Port[numPorts];
        int i = 0;
        while (i < numPorts) {
            String name = this.nGetPortName(i);
            this.sourceLineInfo[i] = this.getPortInfo(name);
            this.ports[i] = new InputDevicePort((Port.Info)this.sourceLineInfo[i], this, new Control[0]);
            ++i;
        }
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = new DataLine.Info(class$com$sun$jmfsound$sampled$TargetDataLine == null ? (class$com$sun$jmfsound$sampled$TargetDataLine = SimpleInputDevice.class$("com.sun.jmfsound.sampled.TargetDataLine")) : class$com$sun$jmfsound$sampled$TargetDataLine, formatArray, 0, -1);
        this.format = this.formats.size() > 0 ? (AudioFormat)this.formats.lastElement() : null;
        this.defaultFormat = this.format;
        this.defaultBufferSize = this.bufferSize;
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: constructor completed");
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine.Info dataLineInfo;
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (fullInfo instanceof Port.Info) {
            int i = 0;
            while (i < this.ports.length) {
                if (fullInfo.equals(this.ports[i].getLineInfo())) {
                    return this.ports[i];
                }
                ++i;
            }
        }
        if (fullInfo instanceof DataLine.Info && (dataLineInfo = (DataLine.Info)fullInfo).getLineClass().isAssignableFrom(class$com$sun$jmfsound$imp$SimpleInputDevice$InputDeviceDataLine == null ? (class$com$sun$jmfsound$imp$SimpleInputDevice$InputDeviceDataLine = SimpleInputDevice.class$("com.sun.jmfsound.imp.SimpleInputDevice$InputDeviceDataLine")) : class$com$sun$jmfsound$imp$SimpleInputDevice$InputDeviceDataLine)) {
            AudioFormat[] sFormats;
            int reqBufferSize = -1;
            AudioFormat reqFormat = null;
            if (info instanceof DataLine.Info) {
                sFormats = ((DataLine.Info)info).getFormats();
                if (sFormats != null && sFormats.length > 0) {
                    reqFormat = sFormats[sFormats.length - 1];
                }
                if ((reqBufferSize = ((DataLine.Info)info).getMaxBufferSize()) == -1) {
                    reqBufferSize = ((DataLine.Info)info).getMinBufferSize();
                }
                if (reqBufferSize <= 0) {
                    reqBufferSize = -1;
                }
            }
            if (reqFormat == null) {
                sFormats = dataLineInfo.getFormats();
                reqFormat = sFormats[sFormats.length - 1];
            }
            if (reqBufferSize == -1) {
                reqBufferSize = (int)(reqFormat.getFrameRate() * (float)reqFormat.getFrameSize() / 2.0f);
            }
            return new InputDeviceDataLine(dataLineInfo, this, reqFormat, reqBufferSize);
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            return 0;
        }
        if (fullInfo instanceof Port.Info) {
            return 1;
        }
        if (fullInfo instanceof DataLine.Info) {
            return -1;
        }
        return 0;
    }

    public void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implOpen");
        }
        if (bufferSize < 0) {
            bufferSize = 0;
        }
        int bufferSizeDivisor = 8;
        int encoding = 0;
        if (format.getEncoding() == AudioFormat.Encoding.ULAW) {
            encoding = 1;
        } else if (format.getEncoding() == AudioFormat.Encoding.ALAW) {
            encoding = 2;
        }
        this.nOpen(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), encoding, (int)format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), bufferSize / (format.getFrameSize() * bufferSizeDivisor));
        this.format = format;
        this.bufferSize = this.nGetBufferSizeInFrames() * format.getFrameSize() * bufferSizeDivisor;
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implOpen succeeded");
        }
    }

    public void implClose() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implClose");
        }
        this.nClose();
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implClose succeeded");
        }
    }

    void implStart() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStart");
        }
        if (!this.implStarted) {
            if (Printer.debug) {
                Printer.debug("SimpleInputDevice: implStart: starting the device");
            }
            this.nStart();
            this.implStarted = true;
        } else {
            if (Printer.debug) {
                Printer.debug("SimpleInputDevice: implStart: resuming the device");
            }
            this.nResume();
        }
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implStart succeeded");
        }
    }

    void implStop() {
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStop");
        }
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (Printer.trace) {
            Printer.trace(">> SimpleInputDevice: implStop");
        }
        this.nPause();
        this.setActive(false);
        this.setStarted(false);
        if (Printer.trace) {
            Printer.trace("<< SimpleInputDevice: implStop succeeded");
        }
    }

    protected void open(DataLine line, AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractMixer: open(line = " + line + ")");
        }
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(format, bufferSize);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo())) {
            if (!this.targetLines.contains(line)) {
                this.open(format, bufferSize);
                this.targetLines.addElement(line);
            }
        } else if (Printer.err) {
            Printer.err("Unknown line received for AbstractMixer.open(Line): " + line);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractMixer: open(line, format, bufferSize) completed");
        }
    }

    private Port.Info getPortInfo(String name) {
        if (name.equals(Port.Info.MICROPHONE.toString())) {
            return Port.Info.MICROPHONE;
        }
        if (name.equals(Port.Info.LINE_IN.toString())) {
            return Port.Info.LINE_IN;
        }
        if (name.equals(Port.Info.COMPACT_DISC.toString())) {
            return Port.Info.COMPACT_DISC;
        }
        return new InputDevicePortInfo(name);
    }

    private void callbackCaptureStreamDestroy() {
        if (Printer.debug) {
            Printer.debug("SimpleInputDevice: callbackCaptureStreamDestroy");
        }
    }

    private void callbackStreamPutData(byte[] data, int lengthInFrames) {
        if (Printer.verbose) {
            Printer.verbose(">> SimpleInputDevice: callbackStreamPutData: data: " + data + " data.length: " + data.length + " lengthInFrames: " + lengthInFrames);
        }
        this.setActive(true);
        this.setStarted(true);
        int lengthInBytes = lengthInFrames * this.format.getFrameSize();
        Vector localTargetLines = (Vector)this.targetLines.clone();
        int i = 0;
        while (i < localTargetLines.size()) {
            InputDeviceDataLine targetLine = (InputDeviceDataLine)localTargetLines.elementAt(i);
            if (targetLine.isOpen() && targetLine.isStartedRunning()) {
                targetLine.setActive(true);
                targetLine.setStarted(true);
                int bytesDumped = targetLine.getCircularBuffer().writeover(data, 0, lengthInBytes);
                InputDeviceDataLine inputDeviceDataLine = targetLine;
                synchronized (inputDeviceDataLine) {
                    targetLine.notifyAll();
                }
                if (bytesDumped > 0 && Printer.debug) {
                    Printer.debug("callbackStreamPutData: buffer overflow for line " + targetLine + "!  received " + lengthInBytes + " bytes, dumped " + bytesDumped);
                }
            }
            ++i;
        }
        if (Printer.verbose) {
            Printer.verbose("<< SimpleInputDevice: callbackStreamPutData completed");
        }
    }

    private native void nGetFormats(int var1, Vector var2, AudioFormat.Encoding var3, AudioFormat.Encoding var4, AudioFormat.Encoding var5, AudioFormat.Encoding var6);

    private native void nOpen(int var1, int var2, float var3, int var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose();

    private native void nStart();

    private native void nPause();

    private native void nResume();

    private native void nDrain();

    private native void nFlush();

    private native long nGetPosition();

    private native int nGetBufferSizeInFrames();

    private native int nGetNumPorts();

    private native String nGetPortName(int var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InputDevicePortInfo
    extends Port.Info {
        static /* synthetic */ Class class$com$sun$jmfsound$sampled$Port;

        private InputDevicePortInfo(String name) {
            super(class$com$sun$jmfsound$sampled$Port == null ? (class$com$sun$jmfsound$sampled$Port = InputDevicePortInfo.class$("com.sun.jmfsound.sampled.Port")) : class$com$sun$jmfsound$sampled$Port, name, true);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class InputDevicePort
    extends AbstractLine
    implements Port {
        private InputDevicePort(Port.Info info, AbstractMixer mixer, Control[] controls) {
            super(info, mixer, controls);
        }

        public synchronized void open() throws LineUnavailableException {
            if (!this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.mixer.open(this);
                this.setOpen(true);
            }
        }

        public synchronized void close() {
            if (this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.setOpen(false);
                this.mixer.close(this);
            }
        }
    }

    private class InputDeviceDataLine
    extends AbstractDataLine
    implements TargetDataLine {
        private CircularBuffer circularBuffer = null;

        private InputDeviceDataLine(DataLine.Info info, SimpleInputDevice mixer, AudioFormat initialFormat, int initialBufferSize) {
            super(info, mixer, null, initialFormat, initialBufferSize);
            if (Printer.trace) {
                Printer.trace("InputDeviceDataLine CONSTRUCTOR: info: " + info + " initialFormat: " + initialFormat + " initialBufferSize: " + initialBufferSize);
            }
        }

        public int read(byte[] b, int off, int len) {
            if (Printer.verbose) {
                Printer.verbose("> InputDeviceDataLine.read(b.length: " + b.length + " off: " + off + " len: " + len);
            }
            int totalBytesToRead = len;
            if (len % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + len + " bytes )");
            }
            int totalBytesRead = 0;
            int currentBytesRead = 0;
            while (this.isOpen() && this.isStartedRunning() && totalBytesRead < totalBytesToRead) {
                currentBytesRead = this.circularBuffer.read(b, off, totalBytesToRead - totalBytesRead);
                off += currentBytesRead;
                if ((totalBytesRead += currentBytesRead) >= totalBytesToRead) continue;
                try {
                    InputDeviceDataLine inputDeviceDataLine = this;
                    synchronized (inputDeviceDataLine) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (Printer.verbose) {
                Printer.verbose("< InputDeviceDataLine.read returning: " + totalBytesRead);
            }
            return totalBytesRead;
        }

        public int available() {
            return this.circularBuffer.bytesAvailableToRead();
        }

        void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implOpen");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            bufferSize = this.mixer.getBufferSize();
            boolean convertSign = false;
            boolean convertByteOrder = false;
            if (format.getSampleSizeInBits() <= 8 && format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !Platform.isSigned8()) {
                convertSign = true;
            } else if (format.getSampleSizeInBits() <= 8 && format.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && Platform.isSigned8()) {
                convertSign = true;
            }
            if (format.getSampleSizeInBits() > 8 && format.isBigEndian() != Platform.isBigEndian()) {
                convertByteOrder = true;
            }
            this.circularBuffer = new CircularBuffer(bufferSize, convertSign, convertByteOrder);
            this.bufferSize = bufferSize;
            this.format = format;
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implOpen succeeded");
            }
        }

        void implClose() {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implClose()");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            SimpleInputDevice.this.implStarted = false;
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implClose() succeeded");
            }
        }

        public synchronized void open() throws LineUnavailableException {
            try {
                super.open();
            }
            catch (LineUnavailableException e) {
                AudioFormat systemFormat = AbstractMixer.getSystemFormat();
                if (systemFormat != null) {
                    this.open(systemFormat);
                }
                throw e;
            }
        }

        void implStart() {
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implStart");
            }
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implStart succeeded");
            }
        }

        void implStop() {
            if (SimpleInputDevice.this.jsSecurity != null) {
                SimpleInputDevice.this.jsSecurity.checkRecordPermission();
            }
            if (Printer.trace) {
                Printer.trace(">> InputDeviceDataLine: implStop");
            }
            this.setActive(false);
            this.setStarted(false);
            if (Printer.trace) {
                Printer.trace("<< InputDeviceDataLine: implStop succeeded");
            }
        }

        public void drain() {
            if (this.isOpen()) {
                this.circularBuffer.drain();
                SimpleInputDevice.this.nDrain();
            }
        }

        public void flush() {
            if (this.isOpen()) {
                this.circularBuffer.flush();
                SimpleInputDevice.this.nFlush();
            }
        }

        public int getFramePosition() {
            return this.isOpen() ? (int)SimpleInputDevice.this.nGetPosition() : super.getFramePosition();
        }

        private CircularBuffer getCircularBuffer() {
            return this.circularBuffer;
        }
    }
}

