/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.spi.FormatConversionProvider;

abstract class SunCodec
extends FormatConversionProvider {
    private static SunCodec[] codecs;
    AudioFormat.Encoding[] inputEncodings;
    AudioFormat.Encoding[] outputEncodings;
    private static final String[] codecClassNames;

    protected SunCodec(AudioFormat.Encoding[] inputEncodings, AudioFormat.Encoding[] outputEncodings) {
        this.inputEncodings = inputEncodings;
        this.outputEncodings = outputEncodings;
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[this.inputEncodings.length];
        System.arraycopy(this.inputEncodings, 0, encodings, 0, this.inputEncodings.length);
        return encodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[this.outputEncodings.length];
        System.arraycopy(this.outputEncodings, 0, encodings, 0, this.outputEncodings.length);
        return encodings;
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);

    static int getNumCodecs() {
        return codecs.length;
    }

    static SunCodec getCodec(int index) {
        SunCodec[] sunCodecArray = codecs;
        synchronized (sunCodecArray) {
            block10: {
                try {
                    if (codecs[index] == null) {
                        Class<?> codecClass = Class.forName(codecClassNames[index]);
                        SunCodec.codecs[index] = (SunCodec)codecClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Printer.err) {
                        Printer.err("ClassNotFoundException: " + e);
                    }
                }
                catch (InstantiationException e2) {
                    if (Printer.err) {
                        Printer.err("InstantiationException: " + e2);
                    }
                }
                catch (IllegalAccessException e3) {
                    if (!Printer.err) break block10;
                    Printer.err("IllegalAccessException: " + e3);
                }
            }
        }
        return codecs[index];
    }

    static {
        codecClassNames = new String[]{"com.sun.jmfsound.imp.UlawCodec", "com.sun.jmfsound.imp.AlawCodec"};
        codecs = new SunCodec[codecClassNames.length];
    }
}

