/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.midi;

import com.sun.jmfsound.midi.InvalidMidiDataException;
import com.sun.jmfsound.midi.MetaMessage;
import com.sun.jmfsound.midi.MidiEvent;
import java.util.Vector;

public class Track {
    protected Vector events = new Vector();

    Track() {
        MetaMessage eot = new MetaMessage();
        try {
            eot.setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException e) {
            // empty catch block
        }
        MidiEvent eotevent = new MidiEvent(eot, 0L);
        this.events.addElement(eotevent);
    }

    public boolean add(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            if (!this.events.contains(event)) {
                MetaMessage mm;
                if (event.getMessage().getStatus() == 255 && (mm = (MetaMessage)event.getMessage()).getType() == 47) {
                    MidiEvent eot = (MidiEvent)this.events.elementAt(this.events.size() - 1);
                    if (event.getTick() > eot.getTick()) {
                        eot.setTick(event.getTick());
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this.events.size() == 0) {
                    this.events.addElement(event);
                    boolean bl = true;
                    return bl;
                }
                int i = this.events.size();
                while (i > 0) {
                    if (event.getTick() >= ((MidiEvent)this.events.elementAt(i - 1)).getTick()) break;
                    --i;
                }
                if (i == this.events.size()) {
                    ((MidiEvent)this.events.elementAt(i - 1)).setTick(event.getTick());
                    this.events.insertElementAt(event, i - 1);
                } else {
                    this.events.insertElementAt(event, i);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean remove(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            boolean bl = this.events.removeElement(event);
            return bl;
        }
    }

    public MidiEvent get(int index) throws ArrayIndexOutOfBoundsException {
        return (MidiEvent)this.events.elementAt(index);
    }

    public int size() {
        return this.events.size();
    }

    public long ticks() {
        return ((MidiEvent)this.events.lastElement()).getTick();
    }
}

