/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DateInputPanel
extends JPanel
implements ItemListener {
    public static boolean twoDigitYears;
    public static int startYear;
    private static final String[] years;
    private static final String[] months;
    private static final String[] days_of_month;
    private final Calendar calendar = Calendar.getInstance();
    private final JComboBox dayComboBox;
    private final JComboBox monthComboBox;
    private final JComboBox yearComboBox;

    public DateInputPanel() {
        this(new Date());
    }

    public DateInputPanel(Date date) {
        this.setLayout(new GridBagLayout());
        this.calendar.setTime(date);
        this.calendar.setLenient(false);
        this.yearComboBox = new JComboBox<String>(years);
        this.monthComboBox = new JComboBox<String>(months);
        this.dayComboBox = new JComboBox<String>(days_of_month);
        this.calendar.set(13, 0);
        this.calendar.set(12, 0);
        this.calendar.set(11, 0);
        this.dayComboBox.setSelectedIndex(this.calendar.get(5) - 1);
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.yearComboBox.setSelectedIndex(this.calendar.get(1) - startYear);
        this.updateDayComboBox();
        this.dayComboBox.addItemListener(this);
        this.monthComboBox.addItemListener(this);
        this.yearComboBox.addItemListener(this);
        this.add(this.dayComboBox);
        this.add(this.monthComboBox);
        this.add(this.yearComboBox);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.yearComboBox) {
                this.calendar.set(1, this.yearComboBox.getSelectedIndex() + startYear);
                this.updateDayComboBox();
            }
            if (e.getSource() == this.monthComboBox) {
                this.calendar.set(2, this.monthComboBox.getSelectedIndex());
                this.updateDayComboBox();
            }
            if (e.getSource() == this.dayComboBox) {
                this.calendar.set(5, this.dayComboBox.getSelectedIndex() + 1);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new DateInputPanel());
        frame.pack();
        frame.setVisible(true);
    }

    private void updateDayComboBox() {
        this.calendar.set(5, 1);
        int max_day_of_month = this.calendar.getActualMaximum(5);
        if (max_day_of_month < this.dayComboBox.getItemCount()) {
            if (this.dayComboBox.getSelectedIndex() > max_day_of_month - 1) {
                this.dayComboBox.setSelectedIndex(max_day_of_month - 1);
            }
            for (int i = this.dayComboBox.getItemCount() - 1; i >= max_day_of_month; --i) {
                this.dayComboBox.removeItem(days_of_month[i]);
            }
        } else if (max_day_of_month > this.dayComboBox.getItemCount()) {
            for (int i = this.dayComboBox.getItemCount(); i < max_day_of_month; ++i) {
                this.dayComboBox.addItem(days_of_month[i]);
            }
        }
        this.calendar.set(5, this.dayComboBox.getSelectedIndex() + 1);
    }

    static {
        int i;
        twoDigitYears = true;
        startYear = 1975;
        Calendar calendar = Calendar.getInstance();
        years = new String[calendar.get(1) - startYear + 1];
        for (i = calendar.get(1); i >= startYear; --i) {
            int year = twoDigitYears ? i % 100 : i;
            DateInputPanel.years[i - DateInputPanel.startYear] = "" + (year < 10 ? "0" : "") + year;
        }
        months = new String[12];
        for (i = 0; i < 12; ++i) {
            DateInputPanel.months[i] = "" + (i < 9 ? "0" : "") + (i + 1);
        }
        days_of_month = new String[31];
        for (i = 0; i < 31; ++i) {
            DateInputPanel.days_of_month[i] = "" + (i < 9 ? "0" : "") + (i + 1);
        }
    }
}

