/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import nl.mpi.util.Xml2Tree;

public class TreeFrame
extends JFrame {
    private final JTree tree;
    private final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    public TreeFrame(TreeNode treeNode) {
        this(treeNode, false);
    }

    public TreeFrame(String schemaFileName) throws Exception {
        this(new URL("file://" + schemaFileName));
    }

    public TreeFrame(URL schemaURL) throws Exception {
        if (schemaURL == null) {
            throw new Exception("URL is null.");
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)Xml2Tree.getTree(schemaURL);
        TreeNode sessionNode = root.getChildAt(0).getChildAt(0);
        this.tree = new JTree(sessionNode);
        this.makeTreeLayout();
        this.setTitle(schemaURL.getFile());
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public TreeFrame(TreeNode treeNode, boolean bDefaultCloseOperation) {
        this.tree = new JTree(treeNode);
        this.makeTreeLayout();
        this.pack();
        this.setDefaultCloseOperation(bDefaultCloseOperation ? 0 : 2);
    }

    public void setTreeBackground(Color color) {
        this.tree.setBackground(color);
        this.renderer.setBackgroundNonSelectionColor(color);
    }

    private void makeTreeLayout() {
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.renderer.setLeafIcon(null);
        this.renderer.setOpenIcon(null);
        this.renderer.setClosedIcon(null);
        this.tree.setCellRenderer(this.renderer);
        this.getContentPane().add(new JScrollPane(this.tree));
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setUI(new BasicTreeUI(){
            Icon emptyIcon = new Icon(){

                public void paintIcon(Component c, Graphics g, int x, int y) {
                }

                public int getIconWidth() {
                    return 16;
                }

                public int getIconHeight() {
                    return 16;
                }
            };

            public Icon getExpandedIcon() {
                return this.emptyIcon;
            }

            public Icon getCollapsedIcon() {
                return this.emptyIcon;
            }
        });
    }

    public static void main(String[] a) {
        String fileName = "MPI/src/java/mpi/metadata/profiles/SESSION.Profile.xml";
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)Xml2Tree.getTree(new URL("file://" + fileName));
            TreeNode sessionNode = root.getChildAt(0).getChildAt(0);
            TreeFrame frame = new TreeFrame(sessionNode);
            frame.setSize(400, 400);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JTree getTree() {
        return this.tree;
    }
}

