package mpi.dcr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * Class that can create a tree based on the broader concept generic attribute
 * of a data category.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class DCTree {
    /**
     * Creates a new DCTree instance
     */
    public DCTree() {
        super();
    }

    /**
     * Creates a tree based on the broader concept generic attributes of
     * categories  and returns the root node.
     *
     * @param datcats the list of data categories!
     *
     * @return the root node of the tree
     */
    public DefaultMutableTreeNode getBroaderGenericConceptTree(List datcats) {
        if (datcats == null) {
            return null;
        }

        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        List nodes = new ArrayList(datcats.size());
        DefaultMutableTreeNode node = null;
        DCSmall dcm = null;

        for (int i = 0; i < datcats.size(); i++) {
            dcm = (DCSmall) datcats.get(i);
            node = new DefaultMutableTreeNode(dcm);

            if (dcm.getBroaderDCId() == null) {
                rootNode.add(node);
            } else {
                nodes.add(new DefaultMutableTreeNode(datcats.get(i)));
            }
        }

        Enumeration en;
        DefaultMutableTreeNode nextNode;
        DCSmall nextdcm;
nodeloop: 
        for (int i = 0; i < nodes.size(); i++) {
            node = (DefaultMutableTreeNode) nodes.get(i);
            dcm = (DCSmall) node.getUserObject();
            // first check the nodes in the tree
            en = rootNode.children();

            while (en.hasMoreElements()) {
                nextNode = (DefaultMutableTreeNode) en.nextElement();
                nextdcm = (DCSmall) nextNode.getUserObject();

                if (nextdcm.getIdentifier().equals(dcm.getBroaderDCId())) {
                    nextNode.add(node);

                    continue nodeloop;
                }
            }

            // not added yet
            for (int j = 0; j < nodes.size(); j++) {
                nextNode = (DefaultMutableTreeNode) nodes.get(j);
                nextdcm = (DCSmall) nextNode.getUserObject();

                if (nextdcm.getIdentifier().equals(dcm.getBroaderDCId())) {
                    nextNode.add(node);

                    continue nodeloop;
                }
            }

            // still not added, the node object has a broader concept, but that one is not in the list
            rootNode.add(node);
        }

        return rootNode;
    }
}
