package mpi.dcr;

import mpi.dcr.isocat.DCSelection;
import mpi.dcr.isocat.Profile;

import java.util.ArrayList;
import java.util.List;


/**
 * A connector to a locally stored Data Category Registry or Selection.
 *
 * @author Han Sloetjes
 */
public class LocalDCRConnector implements ILATDCRConnector {
    /** the name of the local dcs connector */
    protected String name = "Local DCR Connector";

    /** the list of data categories! */
    protected List<DCSmall> catList = null;

    /**
     * Creates a new LocalDCRConnector instance
     */
    public LocalDCRConnector() {
        super();
        catList = new ArrayList<DCSmall>();
    }

    /**
     * Returns the name of the connector
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Returns a list of dat categories in the form of DCSmall objects,
     * containing only a selection  of the information of each category.
     *
     * @param a_profile the profile
     * @param a_registrationStatus the registration status, ignored
     *
     * @return a list with DCSmall objects
     *
     * @throws DCRConnectorException a connector exception
     */
    public List getDCSmallList(String a_profile, String a_registrationStatus)
        throws DCRConnectorException {
        if (a_profile == null) {
            // return all
            return catList;
        }

        List<DCSmall> profCats = new ArrayList<DCSmall>();
        DCSmall dc = null;

        for (int i = 0; i < catList.size(); i++) {
            dc = (DCSmall) catList.get(i);

            if ((dc.getProfiles() != null) && (dc.getProfiles().length > 0)) {
                for (int j = 0; j < dc.getProfiles().length; j++) {
                    if (dc.getProfiles()[j].getId().equals(a_profile)) {// hier... of getName?
                        profCats.add(dc);

                        break;
                    }
                }
            }
        }

        return profCats;
    }

    /**
     * Saves the current dc selection to a local xml/rng file. To be
     * implemented by subclasses.
     */
    protected void saveDCS() {
        /*
           if (catList == null) {
               return;
           }
           //DCR dcr = new DCR();
           // hier... maybe don't need summaries and selection??
           // or don't use data categories?
           DataCategorySelection sel = new DataCategorySelection();
           DataCategorySummary sum = null;
           //DataCategory dc = null;
           Identifier identifier = null;
           Description desc = null;
           Definition def = null;
           Profile[] profs = null;
           BroaderConceptGeneric bcg = null;
           DCSmall small = null;
        
           for (int i = 0; i < catList.size(); i++) {
               small = (DCSmall) catList.get(i);
               sum = new DataCategorySummary();
               identifier = new Identifier();
               identifier.setContentByString(small.getIdentifier());
               sum.setIdentifier(identifier);
               sum.setIdByString(small.getId());
               //dc = new DataCategory();//??
               //dc.setIdByString(small.getId());
               def = new Definition();
               if (small.getDesc() != null) {
                   def.setContentByString(small.getDesc());
               }
               desc = new Description();
               desc.addDefinition(def);
               if (small.getBroaderDCId() != null) {
                   bcg = new BroaderConceptGeneric();
                   bcg.setContentByString(small.getBroaderDCId());
                   desc.setBroaderConceptGeneric(bcg);
               }
               if (small.getProfiles() != null && small.getProfiles().length > 0) {
                   profs = new Profile[small.getProfiles().length];
        
                   for (int j = 0; j < small.getProfiles().length; j++) {
                       profs[j] = new Profile();
                       profs[j].setContentByString(small.getProfiles()[j]);
                   }
                   desc.setProfiles(profs);
               }
               sel.addDataCategorySummaries(sum);
           }
           try {
               Document doc = sel.makeDocument();
        
               // write document
           } catch (ParserConfigurationException pce) {
               // log error
           }
         */
    }

    /**
     * Reads the current dc selection from a local xml/rng file. To be
     * implemented by subclasses.
     */
    protected void readDCS() {
    }

    // *** Local connector specific methods *** //
    /**
     * Adds the data categories from the specified list to the local cache.
     *
     * @param datCats the DC's to add to the list and local dc selection
     *
     * @throws DCRConnectorException a connector exception
     */
    public void addDataCategories(List datCats) throws DCRConnectorException {
        DCSmall small1 = null;
        DCSmall small2 = null;
dcloop: 
        for (int i = 0; i < datCats.size(); i++) {
            small1 = (DCSmall) datCats.get(i);

            for (int j = 0; j < catList.size(); j++) {
                small2 = (DCSmall) catList.get(j);

                if (small1.getId().equals(small2.getId())) {
                    // already in the list
                    continue dcloop;
                }
            }

            // not in the list
            catList.add(small1);
        }

        saveDCS();
    }

    /**
     * Removes the data categories from the specified list from the local
     * cache.
     *
     * @param datCats the list of data categories to remove
     *
     * @throws DCRConnectorException a connector exception
     */
    public void removeCategories(List datCats) throws DCRConnectorException {
        DCSmall small1 = null;
        DCSmall small2 = null;
dcloop: 
        for (int i = 0; i < datCats.size(); i++) {
            small1 = (DCSmall) datCats.get(i);

            for (int j = 0; j < catList.size(); j++) {
                small2 = (DCSmall) catList.get(j);

                if (small1.getId().equals(small2.getId())) {
                    // in the list
                    catList.remove(j);

                    continue dcloop;
                }
            }
        }

        saveDCS();
    }

    /**
     * Returns the dc summary object for the given id.
     *
     * @param dcId the id as a string
     *
     * @return a DCSmall object
     */
    public DCSmall getDCSmall(String dcId) {
        if (dcId == null) {
            return null;
        }

        DCSmall small = null;

        for (int i = 0; i < catList.size(); i++) {
            small = (DCSmall) catList.get(i);

            if (small.getId().equals(dcId)) {
                return small;
            }
        }

        return null;
    }

	public DCSelection getDataCategories(String profileId) throws DCRConnectorException {
		// TODO Auto-generated method stub
		return null;
	}

	public DCSmall getDataCategory(String a_urid) throws DCRConnectorException {
		// TODO Auto-generated method stub
		return null;
	}

	public List<Profile> getProfiles() throws DCRConnectorException {
		// TODO Auto-generated method stub
		return null;
	}
}
