package mpi.dcr;

import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;

import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;


/**
 * A panel with 2 or 3 sub panels, one with a list of (pre) selected profiles,
 * one with the data categories of the selected profile and a description
 * panel for the selected data category.
 *
 * @author Han Sloetjes
 * @version 1.0
 * @version 2.0 change from old Syntax server GMT webservice to ISOcat REST webservice
 */
public class RemoteDCSelectPanel extends AbstractDCSelectPanel
    implements ActionListener, ItemListener, ListSelectionListener,
        TreeSelectionListener {
    /** a constant for all profiles */
    public static final int ALL_PROFILES = 0;

    /** a constant for a selection of profiles */
    public static final int PROFILE_SELECTION = 1;

    /** the add profiles button */
    protected JButton addProfButton;

    /** the remove profiles button */
    protected JButton removeProfButton;
    private int mode = ALL_PROFILES;

    //protected JButton refreshButton;
    /**
     * Creates a new RemoteDCSelectPanel instance
     *
     * @param connector the connector
     */
    public RemoteDCSelectPanel(ILATDCRConnector connector) {
        super(connector);

        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector) connector;
        }

        initComponents();
    }

    /**
     * Creates a new RemoteDCSelectPanel instance
     *
     * @param connector the connector
     * @param resBundle a resource bundle
     */
    public RemoteDCSelectPanel(ILATDCRConnector connector,
        ResourceBundle resBundle) {
        super(connector, resBundle);

        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector) connector;
        }

        initComponents();
    }

    /**
     * Creates a new RemoteDCSelectPanel instance
     *
     * @param connector the connector
     * @param mode all profiles or profile selection mode
     */
    public RemoteDCSelectPanel(ILATDCRConnector connector, int mode) {
        super(connector);

        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector) connector;
        }

        if (mode == PROFILE_SELECTION) {
            this.mode = PROFILE_SELECTION; //otherwise all profiles 
        }

        initComponents();
    }

    /**
     * Creates a new RemoteDCSelectPanel instance
     *
     * @param connector the connector
     * @param resBundle the resource bundle
     * @param mode all profiles or profile selection mode
     */
    public RemoteDCSelectPanel(ILATDCRConnector connector,
        ResourceBundle resBundle, int mode) {
        super(connector, resBundle);

        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector) connector;
        }

        if (mode == PROFILE_SELECTION) {
            this.mode = PROFILE_SELECTION; //otherwise all profiles 
        }

        initComponents();
    }

    /**
     * Creates a new RemoteDCSelectPanel instance
     */
    public RemoteDCSelectPanel() {
        super();
        initComponents();
    }

    /**
     * Initializes the ui components.
     */
    protected void initComponents() {
        super.initComponents();

        // profile panel
        if (mode == PROFILE_SELECTION) {
            addProfButton = new JButton();
            removeProfButton = new JButton();

            Insets insets = new Insets(2, 6, 2, 6);

            addProfButton.addActionListener(this);
            removeProfButton.addActionListener(this);

            JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 6, 2));
            buttonPanel.add(addProfButton);
            buttonPanel.add(removeProfButton);

            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.NORTHWEST;
            gbc.insets = insets;
            gbc.gridy = 1;
            gbc.fill = GridBagConstraints.NONE;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            profPanel.add(buttonPanel, gbc);
        } else {
            // load all profiles, better do this asynchroniously
            if (connector != null) {
                try {
                	ArrayList<Profile> profiles = (ArrayList<Profile>) connector.getProfiles();
                    //ProfileList profileList = connector.getProfiles();
                    //Profile[] profs = profileList.getProfiles();
                    //List<String> ap = new ArrayList<String>(16);
                    //ap.addAll(profiles.values());
//                    for (int i = 0; i < profs.length; i++) {
//                        ap.add(profs[i].getContentAsString());
//                    }

                    addProfiles(profiles);
                } catch (DCRConnectorException dce) {
                    // log
                    dce.printStackTrace();
                }
            }
        }

        updateLocale();
    }

    /**
     * Applies localized texts to the elements, if provided.
     */
    protected void updateLocale() {
        super.updateLocale();

        String addProf = "Add Profile";
        String remProf = "Remove Profile";
        String selCats = "Select Categories";

        if (resBundle != null) {
            try {
                addProf = resBundle.getString("DCR.Label.AddProfile");
            } catch (Exception ex) {
            }

            try {
                remProf = resBundle.getString("DCR.Label.RemoveProfile");
            } catch (Exception ex) {
            }

            try {
                selCats = resBundle.getString("DCR.Label.SelectCategories");
            } catch (Exception ex) {
            }
        }

        if (mode == PROFILE_SELECTION) {
            addProfButton.setText(addProf);
            removeProfButton.setText(remProf);
        }

        catPanel.setBorder(new TitledBorder(selCats));
        /*
           sortModeCombo.removeItemListener(this);
           sortModeCombo.removeAllItems();
           for (int i = 0; i < sortModes.length; i++) {
               sortModeCombo.addItem(sortModes[i]);
           }
         */
        sortModeCombo.addItemListener(this);
    }

    /**
     * Adds the profiles in the specified list to the current list.
     *
     * @param profiles profiles to add
     */
    public void addProfiles(List<Profile> profiles) {
        if (profiles != null) {
        	Profile profile;

profilesloop: 
            for (int i = 0; i < profiles.size(); i++) {
            	profile = profiles.get(i);

                if (profile == null) {
                    continue;
                }

                for (int j = 0; j < profList.getModel().getSize(); j++) {
                    if (profile.getId().equals(((Profile)profList.getModel().getElementAt(j)).getId())) {
                        continue profilesloop;
                    }
                }

                // not in the list already
                ((DefaultListModel) profList.getModel()).addElement(profile);
            }

            if (profList.getModel().getSize() == 1) {
                profList.setSelectedIndex(0);
            }
        }
    }

    private void addProfiles() {
        ProfileSelectPanel pp = new ProfileSelectPanel(connector);

        int ret = JOptionPane.showConfirmDialog(this, pp, "",
                JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);

        if (ret == JOptionPane.OK_OPTION) {
            addProfiles(pp.getSelectedProfiles());
        }
    }

    private void removeProfile() {
        if (profList.getSelectedIndex() > -1) {
            profModel.remove(profList.getSelectedIndex());
        }
    }

    /**
     * Returns a list of selected profiles.
     *
     * @return a list of selected profiles
     */
    public List<Profile> getSelectedProfiles() {
        List<Profile> selProfs = new ArrayList<Profile>();

        for (int j = 0; j < profList.getModel().getSize(); j++) {
            selProfs.add((Profile)profList.getModel().getElementAt(j));
        }

        return selProfs;
    }

    /**
     * @version 2.0 with the new ISOCat web interface the categories are always
     * "fully loaded", i.e. all information necessary for the non-editing
     * client is there
     * 
     * @see org.mpi.DCR.AbstractDCSelectPanel#getSelectedCategories()
     */
    public List getSelectedCategories() {
    	/*
        List selList = super.getSelectedCategories();

        // check if all DCSmall objects are fully loaded
        DCSmall dcSmall;

        for (int i = 0; i < selList.size(); i++) {
            dcSmall = (DCSmall) selList.get(i);

            if ((dcSmall != null) && !dcSmall.isLoaded()) {
                if (connector instanceof LATDCRConnector) {
                    ((LATDCRConnector) connector).getMoreInfo(dcSmall);
                }
            }
        }
		
        return selList;
        */
    	return super.getSelectedCategories();
    }

    /**
     * Returns a list of data categories for the given profile.
     *
     * @param profile the ID of the profile
     *
     * @return a list of data categories
     */
    protected List getDataCategories(Profile profile) {
    	/*
        List datCats = null;

        try {
            datCats = connector.getDCSmallList(profile.getId(), null);

            if (sortMode == BY_ALPHA) {
                Collections.sort(datCats, new DCIdentifierComparator());
            } else if (sortMode == BY_ID) {
                Collections.sort(datCats, new DCIdComparator());
            }
        } catch (DCRConnectorException dce) {
            // show message
        } catch (IllegalArgumentException iae) {
            // show message
        }

        currentProfile = profile;

        return datCats;
        */
    	return super.getDataCategories(profile);
    }

    /**
     * If the sorting is by broader concept, first check if all objects are
     * fully  loaded.
     * 
     * @version 2.0 with the new ISOCat web interface the categories are always
     * "fully loaded", i.e. all information necessary for the non-editing
     * client is there
     * 
     * @see org.mpi.DCR.AbstractDCSelectPanel#updateCategories(java.util.List)
     */
    protected void updateCategories(List datcats) {
        if (datcats == null) {
            //return; // or clear the list??
        	datcats = new ArrayList(0);
        }
        /*
        if (sortMode == BY_CONCEPT) {
            DCSmall nextDC = null;

            for (int i = 0; i < datcats.size(); i++) {
                nextDC = (DCSmall) datcats.get(i);

                if (!nextDC.isLoaded()) {
                    if (connector instanceof LATDCRConnector) {
                        ((LATDCRConnector) connector).getMoreInfo(nextDC);
                    }
                }
            }
        }
		*/
        super.updateCategories(datcats);
    }

    /**
     * First checks whether the object is fully loaded, then calls super
     * implmentation.
     * 
     * @version 2.0 with the new ISOCat web interface the categories are always
     * "fully loaded", i.e. all information necessary for the non-editing
     * client is there
     * @see org.mpi.DCR.AbstractDCSelectPanel#updateDescription(org.mpi.DCR.DCSmall)
     */
    protected void updateDescription(DCSmall dc) {
    	/*
        if ((dc != null) && !dc.isLoaded()) {
            if (connector instanceof LATDCRConnector) {
                ((LATDCRConnector) connector).getMoreInfo(dc);
            }
        }
		*/
        super.updateDescription(dc);
    }

    /**
     * The action event handling
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == addProfButton) {
            addProfiles();
        } else if (e.getSource() == removeProfButton) {
            removeProfile();
        }
    }
}
