package mpi.dcr.isocat;

import mpi.dcr.DCSmall;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;


/**
 * Minimal parser handler for ISOCat's single Data Category DCIF stream.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class DCIF_DC_Handler implements ContentHandler {
    private DCSmall curDC;
    private boolean inLanguage = false;
    private boolean inEng = false;
    private boolean recordContent = false;
    private String curContent;
    private List<Profile> curProfs = new ArrayList<Profile>();

    /**
     * The content of an element.
     *
     * @param ch chars
     * @param start
     * @param length
     *
     * @throws SAXException ex
     */
    public void characters(char[] ch, int start, int length)
        throws SAXException {
        if (recordContent) {
            curContent = new String(ch, start, length);
        }
    }

    /**
     * Returns the resulting (small) Data Category object. Note: might be
     * extended in the future if more information is needed
     *
     * @return the DCSmall object
     */
    public DCSmall getDC() {
        return curDC;
    }

    /**
     * End of document
     *
     * @throws SAXException ex
     */
    public void endDocument() throws SAXException {
        curDC.setLoaded(true);
        curProfs.clear();
    }

    /**
     * Sets selected members of the DCSmall object.
     *
     * @param uri
     * @param localName
     * @param qName
     *
     * @throws SAXException ex
     */
    public void endElement(String uri, String localName, String qName)
        throws SAXException {
        if (qName.equals(ISOCatConstants.DC)) {
            if (curProfs.size() > 0) {
                curDC.setProfiles(curProfs.toArray(new Profile[] {  }));
            }
        } else if (qName.equals(ISOCatConstants.ID)) {
            if (curDC != null) {
                curDC.setIdentifier(curContent);
            }
        } else if (qName.equals(ISOCatConstants.LANG)) {
            if (inLanguage && (curContent != null) && curContent.equals("en")) {
                inEng = true;
            }
        } else if (qName.equals(ISOCatConstants.LANG_SEC)) {
            inLanguage = false;
            inEng = false;
        } else if (qName.equals(ISOCatConstants.DEF)) {
            if (inLanguage && inEng) {
                if (curDC != null) {
                    curDC.setDesc(curContent);
                }
            }
        } else if (qName.equals(ISOCatConstants.NAME)) {
            if (inLanguage && inEng) {
                if (curDC != null) {
                    curDC.setName(curContent);
                }
            }
        } else if (qName.equals(ISOCatConstants.PROF)) {
        	Profile pf = new Profile(null, curContent);
            if (!curProfs.contains(pf)) {
                curProfs.add(pf);
            }
        }

        recordContent = false;
    }

    /**
     * Stub
     *
     * @param prefix
     *
     * @throws SAXException
     */
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    /**
     * Stub
     *
     * @param ch
     * @param start
     * @param length
     *
     * @throws SAXException ex!
     */
    public void ignorableWhitespace(char[] ch, int start, int length)
        throws SAXException {
    }

    /**
     * Stub
     *
     * @param target !
     * @param data
     *
     * @throws SAXException ex
     */
    public void processingInstruction(String target, String data)
        throws SAXException {
    }

    /**
     * Stub
     *
     * @param locator 
     */
    public void setDocumentLocator(Locator locator) {
    }

    /**
     * Stub
     *
     * @param name
     *
     * @throws SAXException
     */
    public void skippedEntity(String name) throws SAXException {
    }

    /**
     * Stub
     *
     * @throws SAXException
     */
    public void startDocument() throws SAXException {
        curDC = null;
    }

    /**
     * Extracts selected attibutes and sets some flags.
     *
     * @param uri
     * @param localName
     * @param qName
     * @param atts
     *
     * @throws SAXException ex
     */
    public void startElement(String uri, String localName, String qName,
        Attributes atts) throws SAXException {
        if (qName.equals(ISOCatConstants.DC)) {
            curDC = new DCSmall(atts.getValue(ISOCatConstants.PID), null);
        } else if (qName.equals(ISOCatConstants.PROF)) {
            recordContent = true;
        } else if (qName.equals(ISOCatConstants.LANG_SEC)) {
            inLanguage = true;
        } else if (qName.equals(ISOCatConstants.LANG)) {
            if (inLanguage) {
                recordContent = true;
            }
        } else if (qName.equals(ISOCatConstants.DEF)) {
            recordContent = true;
        } else if (qName.equals(ISOCatConstants.NAME)) {
            if (inEng) {
                recordContent = true;
            }
        } else if (qName.equals(ISOCatConstants.ID)) {
            recordContent = true;
        }

        // do something more with conceptual domain?
    }

    /**
     * Stub
     *
     * @param prefix
     * @param uri
     *
     * @throws SAXException
     */
    public void startPrefixMapping(String prefix, String uri)
        throws SAXException {
    }
}
