package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.swing.tree.DefaultMutableTreeNode;

import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AddParticipantCommand implements UndoableCommand{
	private String commandName;
	private TranscriptionImpl transcription;
	private List names;		
	private String participantName;
	private ArrayList<TierImpl> newTiers;
	private HashMap oldNameToNewName;
	private String oldValue;
	private String newValue;
	private boolean changePrefix;	
	
	 /** A command to delete a tier (and depending tiers) from a transcription.
	  *
	  * @param name the name of the command
	  */
	 public AddParticipantCommand(String name) {
	        commandName = name;	       
	 }
	 
	 /**
	   * <b>Note: </b>it is assumed the types and order of the arguments are correct.<br>
	   * If arg[2] is null it is assumed that there is no number part.
	   *
	   * @param receiver the TranscriptionImpl
	   * @param arguments the arguments: <ul>
	   * 		  	<li>arg[0] = the selected tiers/participants (ArrayList)</li> 
	   * 			<li>arg[1] = participantName (String)</li> 
	   * 			<li>arg[2] = oldValue (String)</li> 
	   * 			<li>arg[3] = newValue (String)</li> 
	   * 			<li>arg[4] = changePrefix (Boolean)</li> 
	   *            <li>arg[5] = tierStrucSelected (Boolean)</li> 
	   *      </ul>
	   */
	 public void execute(Object receiver, Object[] arguments) {
		 transcription = (TranscriptionImpl) receiver;
	     names = (List) arguments[0];  
	     participantName = (String) arguments[1];
	     oldValue = (String) arguments[2];
	     newValue = (String) arguments[3];
	     changePrefix = (Boolean) arguments[4];
	     boolean tierStrucSelected = (Boolean) arguments[5];
	        
	     newValue = newValue.trim();
	 	              
	     if ((names == null) || (names.size() == 0)) {
	    	 ClientLogger.LOG.warning("No tier/participant selected.");
	         transcription.setNotifying(true);
	        return;
	     } 
	     
	     setWaitCursor(true);
	     
	     newTiers = new ArrayList();
         oldNameToNewName = new HashMap();
	     
	     TierImpl parentTier = null;
	     
	     if(tierStrucSelected){	     
	    	 for(int i= 0; i< names.size();i++){
	    		 parentTier = (TierImpl) transcription.getTierWithId((String)names.get(i));
	    		 if(parentTier != null){
	    			 addTiers(parentTier);
	    		 }
	    	}
	     }else {
	    	 List tiers = transcription.getTiers();	    	
	    	 for(int i= 0; i< tiers.size();i++){
	    		 parentTier = (TierImpl) tiers.get(i);
	    		 if(parentTier != null && !parentTier.hasParentTier()){
	    			if(names.contains(parentTier.getParticipant())) {
	    				 addTiers(parentTier);
	    			}
	    		 }
	    	 }	
	     }
	     
	     setWaitCursor(false);
	 }

     private void addTiers(TierImpl parentTier) {    	
         Vector depTiers = parentTier.getDependentTiers();

         DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(parentTier);
         DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[depTiers.size()];
         HashMap nodeMap = new HashMap();

         for (int i = 0; i < depTiers.size(); i++) {
             TierImpl ti = (TierImpl) depTiers.get(i);
             nodes[i] = new DefaultMutableTreeNode(ti);
             nodeMap.put(ti, nodes[i]);
         }

         for (int i = 0; i < depTiers.size(); i++) {
             TierImpl ti = (TierImpl) depTiers.get(i);

             if (ti.getParentTier() == parentTier) {
                 rootNode.add(nodes[i]);
             } else {
                 DefaultMutableTreeNode dn = (DefaultMutableTreeNode) nodeMap.get(ti.getParentTier());

                 if (dn != null) {
                     dn.add(nodes[i]);
                 }
             }
         }            
         
         DefaultMutableTreeNode dn;
         TierImpl refTier;
         TierImpl newTier;
         TierImpl newParentTier;
         LinguisticType type;
         String newName;
         Enumeration en = rootNode.breadthFirstEnumeration();

         while (en.hasMoreElements()) {
             dn = (DefaultMutableTreeNode) en.nextElement();
             refTier = (TierImpl) dn.getUserObject();

             newName = getNewTierName(refTier.getName());
             oldNameToNewName.put(refTier.getName(), newName);
             type = refTier.getLinguisticType();

             if (dn.getParent() != null) {
                 String oldParentName = ((TierImpl) ((DefaultMutableTreeNode) dn.getParent()).getUserObject()).getName();
                 String newPName = (String) oldNameToNewName.get(oldParentName);
                 newParentTier = (TierImpl) transcription.getTierWithId(newPName);
             } else {
                	 newParentTier = null;            
             }

             if (newParentTier != null) {
            	 newTier = new TierImpl(newParentTier, newName, participantName, transcription, type);
             } else {
            	 newTier = new TierImpl(newName, participantName, transcription, type);
             }

             newTier.setDefaultLocale(refTier.getDefaultLocale());
             newTier.setAnnotator(refTier.getAnnotator());

             newTiers.add(newTier);
             transcription.addTier(newTier);
         }
     }
	 
 
	 private String getNewTierName(String tierName){
         if(oldValue != null && oldValue.trim().length() > 0){        	
     	    if(changePrefix){
     	    	if(tierName.startsWith(oldValue)){
     	    		tierName= tierName.replaceFirst(oldValue, newValue);
     	    	} else {
     	    		tierName = newValue +"-" +tierName;
     	    	}
     	    } else {
     	    	if(tierName.endsWith(oldValue)){
     	    		tierName= tierName.substring(0, tierName.lastIndexOf(oldValue)) + newValue;
     	    	} else {
     	    		tierName = tierName +"-" +newValue;
     	    	}
     	    }        	 
   	        
          } else {
            	if(changePrefix){
            		tierName = newValue +"-" +tierName;
            	} else {
            		tierName = tierName +"-" +newValue;
            	}
     	 }
         
         return tierName;
	 }
	 
	 /**
	  * Changes the cursor to either a 'busy' cursor or the default cursor.
	  *
	  * @param showWaitCursor when <code>true</code> show the 'busy' cursor
	  */
	 private void setWaitCursor(boolean showWaitCursor) {
		 if (showWaitCursor) {
			 ELANCommandFactory.getRootFrame(transcription).getRootPane()
	         	.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	        } else {
	            ELANCommandFactory.getRootFrame(transcription).getRootPane()
	                              .setCursor(Cursor.getDefaultCursor());
	        }
	    }
	 
	 /**
	   * Returns the name of the command.
	   *
	   * @return the name of the command
	   */
	 public String getName() {
		 return commandName;
	 }

	 public void undo() {
		 if ((transcription != null) && (newTiers != null)) {
			 for (int i = 0; i < newTiers.size(); i++) {
				 TierImpl t = (TierImpl) newTiers.get(i);	               
	             transcription.removeTier(t);
	         }
	     }
	 }	        		 

	 public void redo() { 
		 if ((transcription != null) && (newTiers != null)) {		
			 int curPropMode = transcription.getTimeChangePropagationMode();

			 if (curPropMode != Transcription.NORMAL) {
				 transcription.setTimeChangePropagationMode(Transcription.NORMAL);
			 }
			 setWaitCursor(true);
			
			 TierImpl tier = null;

			 for (int i = 0; i < newTiers.size(); i++) {
				tier = (TierImpl) newTiers.get(i);

				 if (transcription.getTierWithId(tier.getName()) == null) {
					 transcription.addTier(tier);
				 }
			 }
			 
			 setWaitCursor(false);			 
			 // restore the time propagation mode
			 transcription.setTimeChangePropagationMode(curPropMode);
     }
		
	 }
}
