package mpi.eudico.client.annotator.gui.multistep;

/**
 * Step. Defines methods for a single step in a multiple step process.
 *
 * @author Han Sloetjes
 */
public interface Step {
    /**
     * Returns the step title, which can be used for a short description.
     *
     * @return the tile of the step
     */
    public String getStepTitle();

    /**
     * Notification that this step is activated while stepping forward.
     * Some initilization could be done here.
     */
    public void enterStepForward();

    /**
     * Notification that this step is activated while stepping backward.
     */
    public void enterStepBackward();

    /**
     * Notification that this step is de-activated while stepping forward.
     *
     * @return true if this step's condition for stepping forward have been met,
     * false otherwise
     */
    public boolean leaveStepForward();

    /**
     * Notification that this step is de-activated while stepping backward.
     *
     * @return true if this step's condition for stepping backward have been met,
     * false otherwise
     */
    public boolean leaveStepBackward();

    /**
     * Notification that the whole process has been cancelled. 
     * Clean up.
     */
    public void cancelled();

    /**
     * Notification that the whole process has been finished. 
     * Clean up.
     */
    public void finished();

    /**
     * Perform the final action(s) that end(s) this process.  
     *
     * @return true when the action has been finished successfullly
     */
    public boolean doFinish();
    
    /**
     * Invitation to show help information about this step or the whole process,
     * if available.
     */
    public void showHelp();
        
}
