package mpi.eudico.client.annotator.imports.multiplefiles;

import java.io.File;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;

public class MFToolboxImportStep4 extends AbstractMFImportStep4{		
	ToolboxDecoderInfo2 decoderInfo;
	
	public MFToolboxImportStep4(MultiStepPane multiPane) {
		super(multiPane);		
	}
	
	public void enterStepForward() {  
		decoderInfo = (ToolboxDecoderInfo2) multiPane.getStepProperty("ToolboxDecoderInfo");		 
	    super.enterStepForward();
    }
	
	protected boolean doImport(File sourceFile, TranscriptionImpl trans) {		
        final File impFile = sourceFile;
        boolean imported = false;
        

        if ((impFile == null) || !impFile.exists()) {
        	progressInterrupted(null, ElanLocale.getString("MultiFileImport.Report.NoFile"));   
 			report(ElanLocale.getString("MultiFileImport.Report.NoFile"));	            
        	return false;
        }
        
        if(decoderInfo == null){
        	return true;
        }

        decoderInfo.setSourceFilePath(trans.getName());  				
        trans = new TranscriptionImpl(trans.getName(), decoderInfo);
       
		return true;
	}
}
