package mpi.eudico.client.annotator.recognizer.data;

/**
 * Lightweight base class for recognizer parameter. 
 * All members are public.
 * 
 * @author Han Sloetjes
 */
public abstract class Param {
	/** the identifier of the parameter */
	public String id;
	/** Information string for ui etc. */
	public String info;
	
	/**
	 * Constructor
	 */
	public Param() {
		super();
	}
	
	/**
	 * Constructor.
	 * @param id the id
	 * @param info the information string
	 */
	public Param(String id, String info) {
		super();
		this.id = id;
		this.info = info;
	}

	@Override
	public abstract Object clone() throws CloneNotSupportedException;	
	
}
