package mpi.eudico.client.annotator.recognizer.gui;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;

import mpi.eudico.client.annotator.recognizer.api.AvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;

import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.client.util.WAVHeader;
import mpi.eudico.client.annotator.ElanLocaleListener;


public class AudioRecognizerPanel extends AbstractRecognizerPanel implements ActionListener, Runnable, RecognizerHost, 
ElanLocaleListener {
	private String visibleAudioFilePath;

	/**
	 * Calls the super constructor and check the "visible audio" file, updates the selection panel if needed
	 */
	public AudioRecognizerPanel(ViewerManager2 viewerManager, ArrayList<String> audioFilePaths) {
		super(viewerManager, audioFilePaths);	
	}

	
	@Override
	protected void initComponents() {
		mode = Recognizer.AUDIO_TYPE;
		
		if (viewerManager.getSignalViewer() != null) {
			visibleAudioFilePath = viewerManager.getSignalViewer().getMediaPath();
			
			try {
				WAVSampler wavSampler = new WAVSampler(visibleAudioFilePath);
				WAVHeader wavHeader = wavSampler.getWavHeader();
				notMono = wavHeader.getNumberOfChannels() > 1;
			} catch (Exception e) {
				System.out.println("Cannot handle file: " + e.getMessage());	// log	
			}
		}
		
		super.initComponents();
	}
	
	
	@Override
	protected HashMap<String, Recognizer> getAvailableRecognizers() {
		return AvailabilityDetector.getAudioRecognizers(mediaFilePaths);
	}


	@Override
	protected void setRecognizer(String name) {
		super.setRecognizer(name);
		if (selectionPanel.isEnabled()) {
			selectionPanel.setStereoMode(notMono);
		}
	}


	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();
		
		if (source.equals(startStopButton)) {
			if (currentRecognizer != null && !isRunning) {
				if ( !(currentRecognizer.getExamplesSupport() == Recognizer.EXAMPLE_SEGMENTS_REQUIRED && 
						getSelections().size() < 1)) {
					// remove possible segmentation boundaries (or later?)
					if (viewerManager.getSignalViewer() != null) {
						viewerManager.getSignalViewer().setSegmentationChannel1(null);
						viewerManager.getSignalViewer().setSegmentationChannel2(null);
					}
				}
			}
		}
		super.actionPerformed(e);
	}
	

	/**
	 * @return the audioFilePath
	 */
	public ArrayList<String> getAudioFilePaths() {
		return mediaFilePaths;
	}
	
	/**
	 * Use of this method is unclear. Unfinished.
	 * 
	 * @param audioFilePath the audioFilePath to set
	 */
	public void setAudioFilePaths(ArrayList<String> audioFilePaths) {
				
		mediaFilePaths.clear();
		for(int i= 0; i < audioFilePaths.size(); i++){
			String path = audioFilePaths.get(i);
			if (path.startsWith("file:")) {
    			path = path.substring(5);
    		}	
			if(!mediaFilePaths.contains(path)){
				mediaFilePaths.add(path);
			}
		}
		
		// check the SignalViewer for the visible audio file
		if(mediaFilePaths.size() > 0){
			visibleAudioFilePath = (String) mediaFilePaths.get(0);
		}
		
		try {
			if(viewerManager.getSignalViewer() != null){
			WAVSampler wavSampler = new WAVSampler(visibleAudioFilePath);
			WAVHeader wavHeader = wavSampler.getWavHeader();
			notMono = wavHeader.getNumberOfChannels() > 1;
			}
		} catch (Exception e) {
			e.printStackTrace();	
		}
		segmentations = new HashMap();
		// update the selections panel
		
		// update the files list
		updateFileList();
	}
	
	
	//
	// RecognizerHost interface implementation
	//
	
	/**
	 * Add a segmentation to the 
	 */
	public void addSegmentation(Segmentation segmentation) {
		super.addSegmentation(segmentation);
		
		// make sure the SignalViewer knows about the new segmentation
		if (viewerManager.getSignalViewer() != null) {
			int channel = 0;
			ArrayList<MediaDescriptor> mediaDescriptors = segmentation.getMediaDescriptors();
			for (int i = 0; i < mediaDescriptors.size(); i++) {
				MediaDescriptor descriptor = (MediaDescriptor) mediaDescriptors.get(i);
				// CHECK IF THE MEDIA FILE IS THE VISIBLE ONE!!! ???
				channel += descriptor.channel;
			}
			if (channel == 0 && mediaDescriptors.size() <= 1) {
				viewerManager.getSignalViewer().setSegmentation(new BoundarySegmentation(segmentation));
			} else
			if (channel == 1) {
				if (notMono) {
					viewerManager.getSignalViewer().setSegmentationChannel1(new BoundarySegmentation(segmentation));
				} else {
					viewerManager.getSignalViewer().setSegmentation(new BoundarySegmentation(segmentation));
				}
			} else if (channel == 2) {
				viewerManager.getSignalViewer().setSegmentationChannel2(new BoundarySegmentation(segmentation));
			} else if (channel == 3) { // something for combined channel result?
				
			}
		}
	}
}
