package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

import mpi.eudico.client.annotator.ElanLocale;

/**
 * Temporary dialog for recognizer parameters.
 * @author Han Sloetjes
 *
 */
public class ParamDialog extends JDialog implements ActionListener {
	private AbstractRecognizerPanel panel;
	private JComponent paramComp;
	private JButton closeButton;
	
	public ParamDialog(JFrame owner, AbstractRecognizerPanel panel, JComponent paramComp) {
		super(owner, true);
		this.panel = panel;
		this.paramComp = paramComp;
		setTitle(ElanLocale.getString("Recognizer.RecognizerPanel.Parameters"));
		initComponents();
	}
	
	private void initComponents() {
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.insets = new Insets(2, 2, 2, 2);
		gbc.anchor = GridBagConstraints.NORTHWEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		getContentPane().add(paramComp, gbc);
		gbc.gridy = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.weighty = 0.0;
		closeButton = new JButton(ElanLocale.getString("Button.Close"));
		closeButton.addActionListener(this);
		getContentPane().add(closeButton, gbc);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == closeButton) {
			if (panel != null) {
				getRootPane().remove(paramComp);
				panel.attachParamPanel(paramComp);
				setVisible(false);
				dispose();
			}
		}		
	}
}
