package mpi.eudico.client.annotator.recognizer.impl;

import java.util.HashMap;
import java.util.Map;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;


public class DemoRecognizerPanel extends JPanel implements ChangeListener, ParamPreferences {
	private JLabel stepDurationLabel;
	private JSlider stepSlider;
	
	/**
	 * 
	 *
	 */
	public DemoRecognizerPanel() {
		int initialStepDuration = 5;
		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		add(Box.createVerticalStrut(10));
		stepDurationLabel = new JLabel("Step Duration: " + initialStepDuration + " seconds");
		add(stepDurationLabel);
		stepSlider = new JSlider(JSlider.HORIZONTAL, 1, 10, initialStepDuration);
		stepSlider.setMajorTickSpacing(1);

		stepSlider.setPaintTicks(true);
		stepSlider.setPaintLabels(true);
		stepSlider.addChangeListener(this);
		add(stepSlider);
	}
	
	public void stateChanged(ChangeEvent e) {
        
        if (e.getSource() == stepSlider) {
        	stepDurationLabel.setText("Step Duration: " + stepSlider.getValue() + " seconds");
        }
    }

	public int getStepDuration() {
		return stepSlider.getValue();
	}
	
	public void setStepDuration(int stepDur) {
		if (stepDur >= stepSlider.getMinimum() && stepDur <= stepSlider.getMaximum()) {
			stepSlider.setValue(stepDur);
		}
	}

	public Map<String, Object> getParamPreferences() {
		Map<String, Object> prefs = new HashMap<String, Object>(1);
		prefs.put("StepDuration", stepSlider.getValue());
		
		return prefs;
	}

	public void setParamPreferences(Map<String, Object> storedPrefs) {
		if (storedPrefs != null) {
			Object val = storedPrefs.get("StepDuration");
			if (val instanceof Integer) {
				int step = ((Integer) val).intValue();
				
				if (step >= stepSlider.getMinimum() && step <= stepSlider.getMaximum()) {
					stepSlider.setValue(step);
				}
			}
		}
		
	}
}
