package mpi.eudico.client.annotator.recognizer.silence;


import java.util.HashMap;
import java.util.Map;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;

/**
 * A panel for setting the minimal silence and non-silence durations.
 * Optionally the noise levels for left and right channels can be set, instead of using selections.
 * 
 * @author albertr
 */
public class SilenceRecognizerPanel extends JPanel implements ChangeListener, ParamPreferences {
	private JLabel minimalSilenceDurationLabel;
	private JSlider minimalSilenceDuration;
	private JLabel minimalNonSilenceDurationLabel;
	private JSlider minimalNonSilenceDuration;
	
	/**
	 * Constructor. Initializes the components.
	 */
	public SilenceRecognizerPanel() {
		int initialSilenceDuration = SilenceRecognizer.DEFAULT_SILENCE_DURATION;
		int initialNonSilenceDuration = SilenceRecognizer.DEFAULT_NON_SILENCE_DURATION;
		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		add(Box.createVerticalStrut(4));
		minimalSilenceDurationLabel = new JLabel(
				ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + 
				" " + initialSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
		add(minimalSilenceDurationLabel);
		minimalSilenceDuration = new JSlider(JSlider.HORIZONTAL, 0, 1000, initialSilenceDuration);
		minimalSilenceDuration.setMajorTickSpacing(200);
		minimalSilenceDuration.setMinorTickSpacing(25);
		minimalSilenceDuration.setPaintTicks(true);
		minimalSilenceDuration.setPaintLabels(true);
		minimalSilenceDuration.addChangeListener(this);
		add(minimalSilenceDuration);
		add(Box.createVerticalStrut(4));
		minimalNonSilenceDurationLabel = new JLabel(
				ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + 
				" " + initialNonSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
		add(minimalNonSilenceDurationLabel);
		minimalNonSilenceDuration = new JSlider(JSlider.HORIZONTAL, 0, 1000, initialNonSilenceDuration);
		minimalNonSilenceDuration.setMajorTickSpacing(200);
		minimalNonSilenceDuration.setMinorTickSpacing(25);
		minimalNonSilenceDuration.setPaintTicks(true);
		minimalNonSilenceDuration.setPaintLabels(true);
		minimalNonSilenceDuration.addChangeListener(this);
		add(minimalNonSilenceDuration);
	}
	
	/**
	 * Change event handling.
	 * 
	 * @param e the change event
	 */
	public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider) e.getSource();
    	int duration = (int)source.getValue();
        
        if (source == minimalSilenceDuration) {
        	minimalSilenceDurationLabel.setText(
        			ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + 
        			" " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        } else if (source == minimalNonSilenceDuration) {
        	minimalNonSilenceDurationLabel.setText(
        			ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") +
        			" " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        }
    }

	/**
	 * Returns the current minimal silence duration slider value.
	 * 
	 * @return the current minimal silence duration value
	 */
	public int getMinimalSilenceDuration() {
		return minimalSilenceDuration.getValue();
	}
	
	/**
	 * Returns the current minimal non-silence duration slider value.
	 * 
	 * @return the current minimal non-silence duration value
	 */
	public int getMinimalNonSilenceDuration() {
		return minimalNonSilenceDuration.getValue();
	}
	
	/**
	 * Updates the user interface elements.
	 */
	public void updateLocale() {
		int duration = minimalSilenceDuration.getValue();
    	minimalSilenceDurationLabel.setText(
    			ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + 
    			" " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
    	duration = minimalNonSilenceDuration.getValue();
    	minimalNonSilenceDurationLabel.setText(
    			ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") +
    			" " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
	}

	/**
	 * Returns the current settings.
	 */
	public Map<String, Object> getParamPreferences() {
		Map <String, Object> sps = new HashMap<String, Object>(4);
		sps.put("MinimalSilenceDuration", new Integer(minimalSilenceDuration.getValue()));
		sps.put("MinimalNonSilenceDuration", new Integer(minimalNonSilenceDuration.getValue()));
		
		return sps;
	}

	/**
	 * Restores the last used settings.
	 */
	public void setParamPreferences(Map<String, Object> storedPrefs) {
		if (storedPrefs != null) {
			Object val;
			val = storedPrefs.get("MinimalSilenceDuration");
			if (val instanceof Integer) {
				minimalSilenceDuration.setValue((Integer) val);
			}
			val = storedPrefs.get("MinimalNonSilenceDuration");
			if (val instanceof Integer) {
				minimalNonSilenceDuration.setValue((Integer) val);
			}
		}		
	}
}