package mpi.eudico.client.annotator.webserviceclient;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingConstants;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

/**
 * Dialog to select and access webservices. Access and interactie is done by
 * invoking a wizard
 * 
 * example: ActivityMonitoringDialog, ImportPraatGridDlgCommand
 * 
 * @author kj
 * 
 */

public class WebServicesDialog extends ClosableDialog implements
	ActionListener, TreeSelectionListener{
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;
    private JPanel prefCatPanel;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JTree catTree;
    private HashMap<String, String> catKeyMap;
    private HashMap<String, JComponent> activatedPanels;
    private CardLayout cardLayout;
    private JComponent currentEditPanel = null;
    private TranscriptionImpl trans;
    
    /**
     * Creates a new EditPrefsDialog instance
     * 
     */
    public WebServicesDialog() throws HeadlessException {
	initComponents();

	// Still need to bridge the gap between this and the other constructors

    }
       
    private static WebServicesDialog dialog;
    
    /**
     * To get a singleton instance of the dialog
     * 
     * @return WebServicesDialog
     */
    public static WebServicesDialog getInstance() {
	dialog = new WebServicesDialog();

	/*
	 * Different from the activity monitor in ActivityMonitoringDialog, the
	 * web services dialog is recreated every time. This is what getInstance
	 * refers to. If the webservices dialog is not stateful, this
	 * constructor can be removed. The dialog itself is not an instantiation
	 * of an object of this class.
	 */
	
	return dialog;
    }
    

    /**
     * Creates a new EditPrefsDialog instance
     * 
     * @param owner
     *            the parent
     * @param modal
     *            modal flag
     * 
     * @throws HeadlessException
     */
    public WebServicesDialog(Frame owner, boolean modal) throws HeadlessException {
	this(owner, "", modal);
    }

    /**
     * Creates a new EditPrefsDialog instance
     * 
     * @param owner
     *            the parent
     * @param title
     *            the dialog title
     * @param modal
     *            modal flag
     * 
     * @throws HeadlessException
     */
    public WebServicesDialog(Frame owner, String title, boolean modal)
	    throws HeadlessException {
	super(owner, title, modal);
	initComponents();
    }
    

    /**
     * Creates a new EditPrefsDialog instance
     * 
     * @param owner
     *            the parent!
     * @param modal
     *            modal flag
     * 
     * @throws HeadlessException
     */
    public WebServicesDialog(Dialog owner, boolean modal)
	    throws HeadlessException {
	this(owner, "", modal);
    }

    /**
     * Creates a new EditPrefsDialog instance
     * 
     * @param owner
     *            the parent!
     * @param title
     *            the dialog title
     * @param modal
     *            modal flag
     * 
     * @throws HeadlessException
     */
    public WebServicesDialog(Dialog owner, String title, boolean modal)
	    throws HeadlessException {
	super(owner, title, modal);
	initComponents();
    }

    private void postInit() {
	pack();

	int w = 720;
	int h = 450;
	setSize((getSize().width < w) ? w : getSize().width,
		(getSize().height < h) ? h : getSize().height);
	setLocationRelativeTo(getParent());
    }
    
    public void setTranscription(TranscriptionImpl trans) {
    	this.trans = trans;
    }
    

    /**
     * Adds a title panel, a preferences category tree panel, a placeholder
     * panel for category specific panels and a buton panel to the layout.
     */
    private void initComponents() {
	
	// initialize the tree as in editingPanel
	
	catKeyMap = new HashMap<String, String>();
	activatedPanels = new HashMap<String, JComponent>();
	getContentPane().setLayout(new GridBagLayout());

	Insets insets = new Insets(2, 6, 2, 6);

	titleLabel = new JLabel();
	titleLabel.setFont(titleLabel.getFont().deriveFont((float) 16));
	titleLabel.setHorizontalAlignment(SwingConstants.CENTER);

	GridBagConstraints gbc = new GridBagConstraints();
	gbc.fill = GridBagConstraints.HORIZONTAL;
	gbc.anchor = GridBagConstraints.NORTH;
	gbc.insets = new Insets(6, 6, 10, 6);
	gbc.weightx = 1.0;
	gbc.gridwidth = 2;
	getContentPane().add(titleLabel, gbc);

	catTree = new JTree(new DefaultMutableTreeNode(""));
	catTree.getSelectionModel().setSelectionMode(
		TreeSelectionModel.SINGLE_TREE_SELECTION);

	((DefaultTreeCellRenderer) catTree.getCellRenderer()).setLeafIcon(null);
	((DefaultTreeCellRenderer) catTree.getCellRenderer()).setOpenIcon(null);
	((DefaultTreeCellRenderer) catTree.getCellRenderer())
		.setClosedIcon(null);

	treeScrollPane = new JScrollPane(catTree);

	Dimension dim = new Dimension(180, 300);
	treeScrollPane.setPreferredSize(dim);
	treeScrollPane.setMinimumSize(dim);
	treeScrollPane.setBackground(Color.WHITE);

	gbc = new GridBagConstraints();
	gbc.fill = GridBagConstraints.VERTICAL;
	gbc.anchor = GridBagConstraints.NORTHWEST;
	gbc.insets = insets;
	gbc.weighty = 1.0;
	gbc.gridy = 1;
	getContentPane().add(treeScrollPane, gbc);

	cardLayout = new CardLayout();
	prefCatPanel = new JPanel(cardLayout);
	prefCatPanel.add(
		new JLabel(ElanLocale
			.getString("WebServicesDialog.SelectService")),
		"Intro_xxx");
	cardLayout.show(prefCatPanel, "Intro_xxx");

	gbc = new GridBagConstraints();
	gbc.anchor = GridBagConstraints.NORTHWEST;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.weightx = 1.0;
	gbc.weighty = 1.0;
	gbc.insets = insets;
	gbc.gridy = 1;
	gbc.gridx = 1;
	getContentPane().add(prefCatPanel, gbc);

	// tree initialization has completed
	
	// add cancel button to panel

	buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
	cancelButton = new JButton();
	cancelButton.addActionListener(this);
	buttonPanel.add(cancelButton);

	gbc = new GridBagConstraints();
	gbc.fill = GridBagConstraints.NONE;
	gbc.anchor = GridBagConstraints.SOUTH;
	gbc.insets = insets;
	gbc.gridy = 2;
	gbc.weightx = 0.0;
	gbc.gridwidth = 2;
	getContentPane().add(buttonPanel, gbc);

	updateLocale();
	postInit();
	catTree.addTreeSelectionListener(this);
    }

    private void updateLocale() {
	setTitle(ElanLocale.getString("WebServicesDialog.Title"));
	titleLabel.setText(ElanLocale.getString("WebServicesDialog.Title"));
	cancelButton.setText(ElanLocale.getString("Button.Cancel"));

	// two rows, add web service names
	
	String val = ElanLocale.getString("WebServicesDialog.WebService.TypeCraft");
	catKeyMap.put(val, "WebServicesDialog.WebService.TypeCraft");
	((DefaultMutableTreeNode) catTree.getModel().getRoot())
		.add(new DefaultMutableTreeNode(val));
	val = ElanLocale.getString("WebServicesDialog.WebService.WebLicht");
	catKeyMap.put(val, "WebServicesDialog.WebService.WebLicht");
	((DefaultMutableTreeNode) catTree.getModel().getRoot())
		.add(new DefaultMutableTreeNode(val));

	catTree.setEditable(false);
	catTree.expandRow(0);
    }

    /**
     * Creates the panel corresponding to the specified key.
     * 
     * @param key
     *            the key, as specified in the language properties files
     * 
     * @return the edit panel
     */
    
    // Invoke wizard dialog here, see ImportPraatGridDlgCommand and ImportPraatGridDlgCommand for an example.
    
    private JComponent getPanelForKey(String key) {
	if (key == null) {
	    return null;
	}

	if (key.equals("WebServicesDialog.WebService.TypeCraft")) {
	    
	    /*
	     * Create wizard dialog pane. The wizard is a dialog, not a Panel.
	     * So we can't use prefCatPanel. Consquently, after the wizard has
	     * been closed the selection in the tree has to be changed in order
	     * to be able to start the wizard again. Sorry, maybe there is a
	     * way around this.
	     */

	    MultiStepPane pane = new MultiStepPane(
		    ElanLocale.getResourceBundle());
	    
	    // add the first step of the wizard dialog
    	    
	    StepPane stepOne = new WebServicesDialogTCStepOne(pane);
	    pane.addStep(stepOne);
	    
	    // add the second step of the wizard dialog
    	    
	    StepPane stepTwo = new WebServicesDialogTCStepTwo(pane);
	    pane.addStep(stepTwo);
	    
	    // create wizard dialog

	    //JDialog dialog = pane.createDialog(this, "TypeCraft web service wizard" , true);

	   // dialog.setVisible(true);
	    pane.setButtonVisible(MultiStepPane.ALL_BUTTONS, false);
	    //pane.setButtonVisible(MultiStepPane.FINISH_BUTTON, false);
	    pane.putStepProperty("transcription", trans);
	    
	    return pane;
	    
	// } else if (key.equals("WebServicesDialog.WebService.WebLicht")) {
	   
	} else if (key.equals("WebServicesDialog.WebService.WebLicht")) {
		MultiStepPane pane = new MultiStepPane(
			    ElanLocale.getResourceBundle());
		StepPane step1 = new WebLichtStep1(pane);
		pane.addStep(step1);
		pane.setButtonVisible(MultiStepPane.ALL_BUTTONS, false);
		
		return pane;
	}

	return null;
    }
    
    private void closeDialog() {
	dispose();
    }

    /**
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent event) {
	if (event.getSource() == cancelButton) {
	    setVisible(false);
	    closeDialog();
	}
    }

    /**
     * Handles selection changes in the category tree.
     * 
     * @param e
     *            the event
     */
    public void valueChanged(TreeSelectionEvent e) {
	
	/*
	 * This is the treeselection listener. At the moment, it doesn't do
	 * much.
	 */

	Object selNode = e.getPath().getLastPathComponent();

	if (selNode instanceof DefaultMutableTreeNode) {
	    String key = (String) ((DefaultMutableTreeNode) selNode)
		    .getUserObject();
	    String val = (String) catKeyMap.get(key);

	    if ((currentEditPanel != null)
		    && (activatedPanels.get(val) == currentEditPanel)) {
	    	return;
	    } else if (activatedPanels.get(val) != null) {
	    	cardLayout.show(prefCatPanel, val);

	    	currentEditPanel = (JComponent) activatedPanels.get(val);
	    } else {
	    	JComponent nextPanel = getPanelForKey(val);

			if (nextPanel != null) {
	
			    prefCatPanel.add(nextPanel, val);
			    cardLayout.show(prefCatPanel, val);
			    currentEditPanel = nextPanel;
			    activatedPanels.put(val, nextPanel);
			}
	    }
	}
    }
       
}


