package mpi.eudico.client.annotator.webserviceclient;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.AnnotationRecreator;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import javax.swing.border.EmptyBorder; 
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;

import org.xml.sax.SAXException;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.webserviceclient.typecraft.TCParser;
import mpi.eudico.webserviceclient.typecraft.TCTextId;
import mpi.eudico.webserviceclient.typecraft.TCWsClient;
import mpi.eudico.webserviceclient.typecraft.TCtoTranscription;

/* 
 * ElanLocale is not used at the moment. Still to be implemented. 
 * 
 */

/**
 * Dialog for entering username and password. This dialog is the first step in
 * the TypeCraft (TC) web services wizzard dialog. Still to be done: enable
 * password entry only when something has entered. Also, show some kind of a
 * login status in the panel: not logged in, login failure, logged in.
 * 
 * example: ImportPraatTGStep1 / ImportPraatTGStep2
 */
public class WebServicesDialogTCStepTwo extends StepPane implements ActionListener{
    
    private JButton listTextButton;
    private JButton importTextButton;
    private JList textList;
    private DefaultListModel model;
    
    /**
     * Create a new instance of the first step of the wizard.
     *
     * @param multiPane the parent pane
     */
    public WebServicesDialogTCStepTwo(MultiStepPane multiPane) {
        super(multiPane);
        initComponents();
    }

    /**
     * Initialize userName, passWord and other components in the first step of
     * the wizzard dialog.
     * 
     * @see mpi.eudico.client.annotator.gui.multistep.StepPane#initComponents()
     */
    public void initComponents() {
	
	// First, create the text import button
	
        listTextButton = new JButton("List my texts");

        // Next, create text a list box.
        model = new DefaultListModel();
        textList = new JList(model);
        textList.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        
        // Finally, create a button for text import.
        
        importTextButton = new JButton("Import selected text");
        importTextButton.setEnabled(false);
        // Put the components in a new panel by means of a gridbaglayout.
        
        setLayout(new GridBagLayout());
        setBorder(new EmptyBorder(12, 12, 12, 12));

        Insets insets = new Insets(2, 0, 2, 0);

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.NONE;
        gbc.weightx = 0.0;
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        
        // Position the components on the grid.
        
        // Still to be done: evaluate button sizes and change when necessary

        add(listTextButton,gbc);
        listTextButton.addActionListener(this);

        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        add(new JScrollPane(textList),gbc);
        
        // Still to be done: fill textList
     
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.NONE;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        add(importTextButton,gbc);
        importTextButton.addActionListener(this);
    }
    
    /**
     * Should listen for entry of text and click on login button. Enable the login
     * button once a valid username has been entered.
     * 
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {

    	Object source;
    	source = e.getSource();
	
		if (source == listTextButton) {
			Object sid = multiPane.getStepProperty("SessionId");
			Object wsclObj = multiPane.getStepProperty("TCWsClient");
			if (sid instanceof String && wsclObj instanceof TCWsClient) {
				String sessionId = (String) sid;
				TCWsClient tcws = (TCWsClient) wsclObj;
				List<TCTextId> texts = tcws.listTexts(sessionId);
				if (texts == null) {
					showMessage("Failed to list the texts.");
				} else if (texts.size() == 0) {
					showMessage("There are no texts of this user.");
				} else {
					model.clear();
					for (int i = 0; i < texts.size(); i++) {
						model.addElement(texts.get(i));
					}
					textList.setSelectedIndex(0);
					importTextButton.setEnabled(true);
				}
			} else {
				// show message and go to login
				showMessage("Not logged in or the session timed out.");
				multiPane.previousStep();
			}
		}
		else if (source == importTextButton) {
			Object sid = multiPane.getStepProperty("SessionId");
			Object wsclObj = multiPane.getStepProperty("TCWsClient");
			if (sid instanceof String && wsclObj instanceof TCWsClient) {
			   String sessionId = (String) sid;
			   TCWsClient tcws = (TCWsClient) wsclObj;
				TCTextId selText = (TCTextId) textList.getSelectedValue();
				if (selText != null) {
					String textId = selText.id;
					String result = tcws.downloadText(textId, sessionId);
					if (result == null) {
						showMessage("Failed to download the specified text");
						return;
					} else {
						parseText(result);
					}
				}
		   }
//	    multiPane.setButtonEnabled(MultiStepPane.FINISH_BUTTON, true);
		}   
	 
    }
    
    /**
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#getStepTitle()
     */
    public String getStepTitle() {
        return "TypeCraft text processing";
    }
    
    /**
     *
     * @see mpi.eudico.client.annotator.gui.multistep.Step#enterStepForward()
     */
    public void enterStepForward() {
        
	// none for the moment 
    }
    
    /**
     *
     * @see mpi.eudico.client.annotator.gui.multistep.Step#leaveStepForward()
     */
    public boolean leaveStepForward() {

        return true;
    }

    /**
     *
     * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
     */
    public void valueChanged(ListSelectionEvent lse) {

    }
    
    private void showMessage(String message) {
    	JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 
    			JOptionPane.WARNING_MESSAGE);
    }

    /**
     * Parses the xml and adds the annotations to the existing transcription.
     * 
     * @param result
     */
    private void parseText(String result) {
    	TCParser parser = new TCParser(result);
    	try {
    		parser.parse();
    	} catch (SAXException se) {
    		showMessage("A parsing error occurred: " + se.getMessage());
    		return;
    	} catch (IOException ioe) {
    		showMessage("An input error occurred: " + ioe.getMessage());
    		return;
    	}
    	TCtoTranscription tc2t = new TCtoTranscription();
    	TranscriptionImpl trans = tc2t.createTranscription(parser.getPhraseRecords(), parser.getTextRecord());
    	if (trans == null) {
    		showMessage("Could not extract tiers and annotations from the returned content.");
    		return;
    	}
    	// get the transcription to add to
    	TranscriptionImpl oldTrans = null;
    	Object oldTransObj = multiPane.getStepProperty("transcription");
    	if (oldTransObj instanceof TranscriptionImpl) {
    		oldTrans = (TranscriptionImpl) oldTransObj;
    	}
    	
    	if (oldTrans != null) { //add to existing transcription
    		TierImpl oldPhraseTier = (TierImpl) oldTrans.getTierWithId(TCtoTranscription.PHRASE);
    		
    		if (oldPhraseTier != null) {
    			// add to existing tiers or rename the new tiers before adding?
    			// currently simply adds without checks
    			DefaultMutableTreeNode node = null;
    			AbstractAnnotation aa = null;
    			TierImpl phraseTier = (TierImpl) trans.getTierWithId(TCtoTranscription.PHRASE);
    			List annos = phraseTier.getAnnotations();
    			
    			oldTrans.setNotifying(false);
    			
    			for (int i = 0; i < annos.size(); i++) {
    				aa = (AbstractAnnotation) annos.get(i);
    				node = AnnotationRecreator.createNodeForAnnotation(aa);
    				AnnotationRecreator.createAnnotationFromTree(oldTrans, node);
    			}
    			
    			oldTrans.setNotifying(true);
    			
    			showMessage("The text has been imported.");
    		} else {
    			// add all tiers
    			MergeUtil merger = new MergeUtil();
    			ArrayList addTiers = merger.getAddableTiers(trans, oldTrans, null);
    			
    			merger.addTiersTypesAndCVs(trans, oldTrans, addTiers);
    			// hier there must already be utility method for this
    			DefaultMutableTreeNode node = null;
    			AbstractAnnotation aa = null;
    			TierImpl phraseTier = (TierImpl) trans.getTierWithId(TCtoTranscription.PHRASE);
    			List annos = phraseTier.getAnnotations();
    			
    			oldTrans.setNotifying(false);
    			
    			for (int i = 0; i < annos.size(); i++) {
    				aa = (AbstractAnnotation) annos.get(i);
    				node = AnnotationRecreator.createTreeForAnnotation(aa);
    				AnnotationRecreator.createAnnotationFromTree(oldTrans, node, true);
    			}
    			
    			oldTrans.setNotifying(true);
    			
    			showMessage("The text has been imported.");
    		}
    	} else {
    		// do something with the new transcription
    		multiPane.putStepProperty("transcription", trans);
    		FrameManager.getInstance().createFrame(trans);
    	}

    }
}
