package mpi.eudico.client.util;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class RadioButtonCellEditor  extends  DefaultCellEditor
		implements ItemListener {
	
	private JRadioButton button;
	 
	  public RadioButtonCellEditor(JCheckBox checkBox) {
	    super(checkBox);
	  }
	 
	  public Component getTableCellEditorComponent(JTable table, Object value,
	                   boolean isSelected, int row, int column) {
	    
	    if (value instanceof SelectEnableObject) {
	    	button = new JRadioButton(value.toString());
            button.setSelected(((SelectEnableObject)value).isSelected());
            button.setEnabled(((SelectEnableObject)value).isEnabled());
            button.addItemListener(this);
        }
        
        return button;
	  }
	  
	  public Object getCellEditorValue() {
		 // button.removeItemListener(this);
		  SelectEnableObject seo = new SelectEnableObject(button.getText(), button.isSelected(), button.isEnabled());	
	      return seo;
	    }
 

	  public void itemStateChanged(ItemEvent e) {		  
		  super.fireEditingStopped();
	  }
	}