package mpi.eudico.server.corpora.clom;

import java.net.URL;

import mpi.eudico.server.corpora.event.DurationUnknownException;
import mpi.eudico.server.corpora.event.NoAudioSampleDataException;
import mpi.eudico.server.corpora.event.NoMediaFileException;

/**
 * MediaObject encapsulates all information about media objects on a media
 * server that is used by the EUDICO data objects. Each Transcription is 
 * associated with a MediaObject.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 2-Jun-1999
 */
// 10 0ct 2000; Daan Broeder; made it a LanguageResource
public interface MediaObject extends LanguageResource {

	public static int PAL = 1;
	public static int NTSC = 2;
	/**
	 * Returns a name identitying a media file or media stream.
	 *
	 * @return	the media file or stream name
	 * @exception 	NoMediaFileException	thrown when a video file is unknown or
	 *					not available for this MediaObject
	 */
	public String getMediaFile() throws NoMediaFileException;
	
	public URL getMediaURL();
	
	/**
	 * Returns a name identitying an audio sample data file or stream.
	 *
	 * @return	the audio file or stream name
	 * @exception 	NoAudioSampleDataException	thrown when an audio file is unknown or
	 *						not available for this MediaObject
	 */	
	public String getAudioSampleData() throws NoAudioSampleDataException;
		
	/**
	 * Returns the Duration of the MediaObject in milliseconds.
	 *
	 * @return	the duration in milliseconds
	 * @exception 	DurationUnknownException	thrown if duration is unknown or 
	 *					otherwise unavailable
	 */
	public long getDuration() throws DurationUnknownException;
	
	/**
	 * Returns the sample rate of a media object. (examples: 25 for PAL video,
	 * 29.97 for NTSC video, 44100, ... for audio.
	 */
	public double getMediaSampleRate();
}
