package mpi.search.content.query.model;

import mpi.search.content.model.CorpusType;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;


/**
 * $Id: Utilities.java 10187 2007-09-18 10:59:37Z klasal $
 */
public class Utilities {
    /**
     * adapts regular expression corresponding to constraint.isRegex and
     * constraint.isCaseSensitive
     *
     * @param constraint
     * @param type 
     * @return Pattern
     */
    public static final Pattern getPattern(Constraint constraint,
        CorpusType type) throws PatternSyntaxException {
        Pattern pattern = null;
        String regex = constraint.getPattern();

        if (!constraint.isRegEx() ||
                (type.isClosedVoc(constraint.getTierName()) && !constraint.isRegEx()) ) {
        	// HS 03-2012 added additional check so that it is possible to search tiers with a CV and 
        	// use regular expressions without escaping
            regex = escape(regex);
        }

        if (!constraint.isRegEx()) {
            if (regex.equals("")) {
                // match every non-empty 'word' (substring without spaces)
                regex = "\\b\\S+?\\b";
            } else {
                regex = "\\b" + regex + "\\b";
            }
        }

        int flag = constraint.isCaseSensitive() ? 0 : Pattern.CASE_INSENSITIVE;
        pattern = Pattern.compile(regex, flag);

        return pattern;
    }

    /**
     * Escapes all 'specialChars' in the String
     *
     * @param s
     *
     * @return String
     */
    public static final String escape(String s) {
        StringBuffer escaped = new StringBuffer(s);

        for (int i = 0; i < escaped.length(); i++) {
            if (Constraint.regExMetaChars.indexOf(escaped.charAt(i)) >= 0) {
                escaped.insert(i, "\\");
                i++;
            }
        }

        return escaped.toString();
    }
}
