package mpi.search.content.query.viewer;
import javax.swing.Action;
import java.awt.Graphics;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;

import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.AnchorConstraint;

/**
 * $Id: AnchorConstraintPanel.java 7355 2006-11-28 11:36:23Z klasal $
 *
 * $Author$
 */
public class AnchorConstraintPanel extends AbstractConstraintPanel {
	final private JLabel lockedConstraintLabel = new JLabel();
	private String lockedTierName = null;
	private String lockedPattern = null;

	public AnchorConstraintPanel(AnchorConstraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
		super(constraint, treeModel, type, startAction);
		// 'head line' of constraint
		titleComponent.add(
			new JLabel(
				SearchLocale.getString("Search.Query.Find").toUpperCase()));
		titleComponent.setBorder(new EmptyBorder(0, 0, 5, 0));

		tierComboBox = new JComboBox(type.getTierNames()) {
			public void paint(Graphics g) {
				super.paint(g);
				tierComboBoxWidth = this.getPreferredSize().width;
			}
		};

		selectedTiers = new ArrayList<String>(6);
		if (type.allowsSearchOverMultipleTiers() && type.getTierNames().length > 1){
			tierComboBox.insertItemAt(Constraint.ALL_TIERS, 0);
			if (type instanceof ElanType) {
				tierComboBox.insertItemAt(Constraint.CUSTOM_TIER_SET, 1);
			}
		}
		
		lockedConstraintLabel.setHorizontalAlignment(JLabel.CENTER);
		framedPanel.add(lockedConstraintLabel, "locked");
		
		makeLayout();
		setConstraint(constraint);
		tierComboBox.addPopupMenuListener(this);
	}

	protected void setTierName(String tierName) {
		for (int i = 0; i < type.getIndexTierNames().length; i++) {
			if (type.getIndexTierNames()[i].equals(tierName.toUpperCase())) {
				lockedTierName = tierName.toUpperCase();
				framedPanelLayout.show(framedPanel, "locked");
				return;
			}
		}
		//if lockedField was set, reset.
		if (lockedTierName != null) {
			lockedTierName = null;
			lockedPattern = null;
			framedPanelLayout.show(framedPanel, "");
		}
		super.setTierName(tierName);
	}

	protected void setTierNames(String[] tierNames) {
		if (tierNames.length > 0) {
			if (tierNames.length == 1) {
				setTierName(tierNames[0]);
			} else {
				tierComboBox.setSelectedItem(Constraint.CUSTOM_TIER_SET);
				if (selectedTiers == null) {
					selectedTiers = new ArrayList<String>(6);
				}
				for (String s : tierNames) {
					if (!selectedTiers.contains(s)) {
						selectedTiers.add(s);
					}
				}
			}
		}
		else{
			tierComboBox.setSelectedIndex(0);
		}
	}
	
	public String getTierName(){
	    return lockedTierName == null ? super.getTierName() : lockedTierName;
	}

	protected void setPattern(String pattern) {
		if (lockedTierName != null) {
			lockedPattern = pattern;
			lockedConstraintLabel.setText(type.getUnabbreviatedTierName(lockedTierName) + " " + lockedPattern);
		}
		else
		super.setPattern(pattern);
	}

	protected String getPattern(){
	    return lockedPattern == null ? super.getPattern() : lockedPattern;
	}
	
	public void setConstraint(AnchorConstraint c){
		setTierNames(c.getTierNames());
		super.setConstraint(c);
	}
}
