package mpi.search.content.query.xml;

import java.net.MalformedURLException;

import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import mpi.search.content.query.model.ContentQuery;
import nl.mpi.util.OurURL;

/**
 * Evokes parser to read matches from xml-file
 * Created on Sep 30, 2004
 * @author Alexander Klassmann
 * @version Sep 30, 2004
 */
public class Xml2Query {
	private static XMLReader parser;

	public static void translate(String file, ContentQuery query) throws Exception {
		OurURL url = null;
		try {
			url = new OurURL("file:\\"+file);
		}
		catch (MalformedURLException e1) {
		}
		if(url != null)
		    translate(url, query);
	}

	public static void translate(OurURL url, ContentQuery query) throws Exception {
		if (parser == null)
			parser = new SAXParser();
		parser.setContentHandler(new QueryContentHandler(query));
		parser.parse(new InputSource(url.openStream()));
	}

}
