/*
 * Decompiled with CFR 0.152.
 */
package mpi.annex.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mpi.annex.data.AnnexMediaDescriptor;
import mpi.annex.data.AnnexParser;
import mpi.annex.data.AnnexTier;
import org.apache.log4j.Logger;

public class AnnexTranscription
implements Serializable {
    private static Logger logger = Logger.getLogger("ANNEX.AnnexTranscription");
    private String nodeId;
    private boolean valid;
    private boolean hasVirtualTime;
    private ArrayList mediaDescriptors;
    private ArrayList tiers;
    private int type;
    private String info;
    private String newKey;
    private String masterAudio;
    private String resourceFileName;
    private String videoServerName;
    private String audioServerName;
    private HashMap streams;

    public AnnexTranscription(String nodeId, int type, File file) {
        this.nodeId = nodeId;
        this.type = type;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        this.streams = new HashMap();
        this.valid = AnnexParser.parse(file, type, this);
        this.updateHasVirtualTime();
    }

    private void updateHasVirtualTime() {
        this.hasVirtualTime = false;
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier tier = (AnnexTier)this.tiers.get(i);
            if (!tier.hasVirtualTime) continue;
            this.hasVirtualTime = true;
            break;
        }
    }

    public AnnexTranscription(String nodeId, File file, File typFile) {
        this.nodeId = nodeId;
        this.type = this.type;
        this.mediaDescriptors = new ArrayList();
        this.tiers = new ArrayList();
        this.streams = new HashMap();
        AnnexParser.setTypFile(typFile);
        this.valid = AnnexParser.parse(file, 2, this);
        this.updateHasVirtualTime();
    }

    public Map getStreams() {
        return this.streams;
    }

    public void addStream(String id, String sURL) {
        this.streams.put(id, sURL);
    }

    public boolean hasVirtualTime() {
        return this.hasVirtualTime;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getType() {
        return this.type;
    }

    public String getMasterAudioInfo() {
        return this.masterAudio;
    }

    public String getNewKey() {
        return this.newKey;
    }

    public void setNewKey(String key) {
        this.newKey = key;
    }

    public void setMasterAudio(String masterAudio) {
        this.masterAudio = masterAudio;
    }

    public String getResourceFilename() {
        return this.resourceFileName;
    }

    public void setResourceFilename(String fileName) {
        this.resourceFileName = fileName;
    }

    public String getVideoServerName() {
        return this.videoServerName;
    }

    public void setVideoServerName(String serverName) {
        this.videoServerName = serverName;
    }

    public String getAudioServerName() {
        return this.audioServerName;
    }

    public void setAudioServerName(String serverName) {
        this.audioServerName = serverName;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public ArrayList getMediaDescriptors() {
        return this.mediaDescriptors;
    }

    public ArrayList getTiers() {
        return this.tiers;
    }

    public ArrayList getRealTiers() {
        ArrayList<AnnexTier> realTiers = new ArrayList<AnnexTier>();
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier tier = (AnnexTier)this.tiers.get(i);
            if (tier.hasVirtualTime) continue;
            realTiers.add(tier);
        }
        return realTiers;
    }

    public ArrayList getVirtualTiers() {
        ArrayList<AnnexTier> virtualTiers = new ArrayList<AnnexTier>();
        for (int i = 0; i < this.tiers.size(); ++i) {
            AnnexTier tier = (AnnexTier)this.tiers.get(i);
            if (!tier.hasVirtualTime) continue;
            virtualTiers.add(tier);
        }
        return virtualTiers;
    }

    public AnnexMediaDescriptor getMasterMedia() {
        if (this.mediaDescriptors.size() == 0) {
            return null;
        }
        return (AnnexMediaDescriptor)this.mediaDescriptors.get(0);
    }

    public ArrayList getAllMasterMedia() {
        if (this.mediaDescriptors.size() == 0) {
            return null;
        }
        return this.mediaDescriptors;
    }

    public AnnexMediaDescriptor getMasterAudio() {
        AnnexMediaDescriptor masterMedia = this.getMasterMedia();
        if (masterMedia == null || masterMedia.mimeType.indexOf("audio") >= 0) {
            return masterMedia;
        }
        for (int i = 1; i < this.mediaDescriptors.size(); ++i) {
            AnnexMediaDescriptor media = (AnnexMediaDescriptor)this.mediaDescriptors.get(i);
            if (media.extractedFrom == null || !media.extractedFrom.equals(masterMedia.fileName)) continue;
            return media;
        }
        return null;
    }
}

